/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.internal.installAdaptors.BundleManager;
import com.ibm.cic.agent.internal.installAdaptors.EclipseBundleOperation;
import com.ibm.cic.agent.internal.installAdaptors.Messages;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.eclipseAdapterData.EclipseArtifact;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class RemoveAgentBundleOperation {
    private final BundleManager bundleManager;
    private static final Logger log = Logger.getLogger(RemoveAgentBundleOperation.class);
    private static final String ReferenceSegment = "reference:";
    private static final String FileSegment = "file:";

    public RemoveAgentBundleOperation(BundleManager manager) {
        this.bundleManager = manager;
    }

    public void perform(IProgressMonitor monitor) {
        Bundle[] bundles;
        BundleContext bundleContext = Agent.getInstance().getAgentBundleContext();
        if (this.bundleManager != null && this.bundleManager.hasBundles()) {
            bundles = this.bundleManager.getBundles();
            this.uninstallBundles(bundles, bundleContext);
            this.bundleManager.clear();
        }
        if ((bundles = RemoveAgentBundleOperation.getLoadedOfferingBundles(bundleContext)).length != 0) {
            this.uninstallBundles(bundles, bundleContext);
            log.info(Messages.EclipseInstallAdaptor_loadedOfferingBundlesDetected, new Object[]{RemoveAgentBundleOperation.bundlesToString(bundles)});
        }
    }

    private void uninstallBundles(Bundle[] bundles, BundleContext bundleContext) {
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle nextBundle = bundleArray[n2];
            RemoveAgentBundleOperation.uninstallBundle(nextBundle);
            ++n2;
        }
        EclipseBundleOperation.refreshPackages(bundles, bundleContext);
    }

    public static void uninstallBundle(Bundle bundle) {
        try {
            if (bundle.getState() == 32) {
                bundle.stop();
            }
            if (bundle.getState() != 1) {
                bundle.uninstall();
            }
        }
        catch (BundleException be) {
            log.error((Throwable)be, Messages.EclipseInstallAdaptor_error_removing_agent_bundle, new Object[]{bundle.getSymbolicName(), RemoveAgentBundleOperation.getBundlePath(bundle), be});
        }
        catch (IllegalStateException ise) {
            log.error((Throwable)ise, Messages.EclipseInstallAdaptor_error_removing_agent_bundle, new Object[]{bundle.getSymbolicName(), RemoveAgentBundleOperation.getBundlePath(bundle), ise});
        }
    }

    private static String getBundlePath(Bundle bundle) {
        int jndex;
        String bundlePath = bundle.getLocation();
        int seg1 = bundlePath.indexOf(ReferenceSegment);
        if (seg1 == 0) {
            bundlePath = bundlePath.substring(ReferenceSegment.length(), bundlePath.length());
        }
        if ((jndex = bundlePath.indexOf(FileSegment)) == 0) {
            bundlePath = bundlePath.substring(FileSegment.length(), bundlePath.length());
        }
        return bundlePath;
    }

    protected boolean isMatchingArtifact(IArtifact artifact) {
        return artifact instanceof EclipseArtifact && ((EclipseArtifact)artifact).getType() == 2;
    }

    private static Bundle[] getLoadedOfferingBundles(BundleContext context) {
        Bundle[] bundles;
        String agentBundleLocation = FileUtil.getCanonicalPath((File)Agent.getInstance().getAgentBundleLocation());
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String location = FileUtil.getCanonicalPath((String)RemoveAgentBundleOperation.getBundlePath(bundle));
            if (location.startsWith(agentBundleLocation)) {
                result.add(bundle);
            }
            ++n2;
        }
        return result.toArray(new Bundle[result.size()]);
    }

    private static String bundlesToString(Bundle[] bundles) {
        StringBuilder sb = new StringBuilder();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(bundle.getSymbolicName());
            sb.append('_');
            sb.append(bundle.getVersion());
            ++n2;
        }
        return sb.toString();
    }
}

