/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleInfo;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.ConfigurationEditor;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.Messages;
import com.ibm.cic.agent.internal.installAdaptors.BundleRegistry;
import com.ibm.cic.agent.internal.installAdaptors.ConfigIniContributorRegistry;
import com.ibm.cic.agent.internal.installAdaptors.EclipseIniContributorRegistry;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.eclipse.internals.update.configurator.IPlatformConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ConfigurationContributorEditor
extends ConfigurationEditor {
    private static final Logger log = Logger.getLogger(ConfigurationContributorEditor.class);
    private final ConfigIniContributorRegistry configIniRegistry;
    private final EclipseIniContributorRegistry eclipseIniRegistry;
    private final BundleRegistry bundleRegistry;
    private final File changeStampFile;
    private final boolean isAgentProfile;
    private InstallContext installContext = null;

    public ConfigurationContributorEditor(File configLocation, File launcherLocation, File installLocation, InstallContext context) throws CoreException {
        super(configLocation, launcherLocation, installLocation);
        this.configIniRegistry = new ConfigIniContributorRegistry(context);
        this.configIniRegistry.initialize(this);
        this.eclipseIniRegistry = new EclipseIniContributorRegistry(context);
        this.eclipseIniRegistry.initialize(this);
        this.bundleRegistry = new BundleRegistry(context);
        boolean bundleRegistryWasLoaded = this.bundleRegistry.load();
        this.changeStampFile = new File(context.getAdapterStorage("eclipse"), "changeStamp.txt");
        this.isAgentProfile = context.getEnclosingProfile().isAgentProfile();
        if (this.checkForExternalBundleConfigurationModifications(context, bundleRegistryWasLoaded)) {
            this.stripExternalBundleContributionsAndRestoreInstalledBundles();
        }
        this.installContext = context;
    }

    public void setConfigProperty(IInstallableUnit unit, String key, String value) {
        Map contribution = this.configIniRegistry.getContribution(unit);
        contribution.put(key, value);
    }

    public void addVmArgs(IInstallableUnit unit, List rawArgs) {
        Map contribution = this.eclipseIniRegistry.getContribution(unit);
        this.eclipseIniRegistry.addVmArgs(contribution, rawArgs);
    }

    public void addProgramArgs(IInstallableUnit unit, List rawArgs) {
        Map contribution = this.eclipseIniRegistry.getContribution(unit);
        this.eclipseIniRegistry.addProgramArgs(contribution, rawArgs);
    }

    public void setVmLocation(IInstallableUnit unit, String location) {
        Map contribution = this.eclipseIniRegistry.getContribution(unit);
        this.eclipseIniRegistry.setVmLocation(contribution, location);
    }

    public void removeConfigIniContribution(IInstallableUnit unit) {
        this.configIniRegistry.removeContribution(unit);
    }

    public void removeEclipseIniContribution(IInstallableUnit unit) {
        this.eclipseIniRegistry.removeContribution(unit);
    }

    public void addBundle(BundleInfo info, IInstallableUnit unit) {
        BundleInfo unwantedInfo = this.bundleRegistry.add(info, unit);
        if (unwantedInfo == null) {
            super.add(info);
        } else if (unwantedInfo != info) {
            super.remove(unwantedInfo);
            super.add(info);
        }
    }

    public void removeBundle(BundleInfo info, IInstallableUnit unit) {
        BundleInfo wantedInfo = this.bundleRegistry.remove(info, unit);
        if (wantedInfo == null) {
            super.remove(info);
        } else if (wantedInfo != info) {
            super.remove(info);
            super.add(wantedInfo);
        }
    }

    public boolean isDirty() {
        return this.configIniRegistry.isDirty() || this.eclipseIniRegistry.isDirty() || this.bundleRegistry.isDirty() || super.isDirty();
    }

    public void save(IProgressMonitor monitor) throws CoreException {
        boolean wasDirty = this.isDirty();
        this.bundleRegistry.checkForErroneousBundles();
        if (this.configIniRegistry.isDirty()) {
            this.configIniRegistry.applyMergedChanges(this);
            this.configIniRegistry.store();
        }
        if (this.eclipseIniRegistry.isDirty()) {
            this.eclipseIniRegistry.applyMergedChanges(this);
            this.eclipseIniRegistry.store();
        }
        if (this.bundleRegistry.isDirty()) {
            this.bundleRegistry.store();
        }
        super.save(monitor);
        if (wasDirty) {
            this.saveChangeStamp();
            if (this.isAgentProfile) {
                if (Agent.getInstance().isServerMode()) {
                    if ("com.ibm.cic.agent.web.install.context".equals(this.installContext.getId())) {
                        this.setDefaultRelaunchArguments();
                    }
                } else if ("com.ibm.sdp.eclipse.ide".equals(this.installContext.getId())) {
                    this.setDefaultRelaunchArguments();
                }
            }
        }
    }

    private void setDefaultRelaunchArguments() {
        if (this.configurationIsEmpty() || this.getLauncherName() == null) {
            return;
        }
        String vm = this.getVMLocation();
        if (vm == null) {
            return;
        }
        if (!AgentRelaunch.getInstance().isVmInLauncher() && AgentRelaunch.getInstance().isLibraryVM(vm) && (vm = AgentRelaunch.getInstance().findJavaExe(this.getInstallLocation(), vm)) == null) {
            return;
        }
        String launcherStartupPluginId = "org.eclipse.equinox.launcher";
        String launcherStartupPluginLocation = this.getLauncherPluginLocation(launcherStartupPluginId);
        if (launcherStartupPluginLocation == null) {
            return;
        }
        Properties properties = this.getProperties();
        String ws = properties.getProperty("osgi.ws");
        String arch = properties.getProperty("osgi.arch");
        String launcherLibraryPluginId = String.valueOf(launcherStartupPluginId) + '.' + ws + '.' + Platform.getOS() + '.' + arch;
        String launcherLibraryPluginLocation = this.getLauncherPluginLocation(launcherLibraryPluginId);
        if (launcherLibraryPluginLocation == null) {
            return;
        }
        String[] vmargs = this.getRelaunchVMArguments(launcherStartupPluginLocation);
        String[] programargs = this.getRelaunchProgramArguments(launcherStartupPluginLocation, launcherLibraryPluginLocation);
        AgentRelaunch.getInstance().setDefaultRelaunchArguments(this.getLauncher(), vm, vmargs, programargs, ws, arch);
    }

    private String getLauncherPluginLocation(String pluginId) {
        URL url;
        String bundleLocation = this.findBundleLocation(pluginId);
        if (bundleLocation == null) {
            log.error("getLauncherPluginLocation(): cannot find location for launcher plugin \"{0}\"", new Object[]{pluginId});
            return null;
        }
        try {
            url = new URL(bundleLocation);
        }
        catch (MalformedURLException e) {
            log.error((Throwable)e);
            return null;
        }
        return FileUtil.getCanonicalPath((String)url.getFile());
    }

    private String[] getRelaunchVMArguments(String launcherStartupPluginLocation) {
        List vmargsList = (List)this.getVMArgList().clone();
        if (!AgentRelaunch.getInstance().isVmInLauncher()) {
            vmargsList.add("-jar");
            vmargsList.add(launcherStartupPluginLocation);
        }
        String[] vmargs = vmargsList.toArray(new String[vmargsList.size()]);
        return vmargs;
    }

    private String[] getRelaunchProgramArguments(String launcherStartupPluginLocation, String launcherLibraryPluginLocation) {
        List programargsList = (List)this.getProgramArgumentList().clone();
        String configLocation = this.getConfigurationLocation().getPath();
        programargsList.add("-configuration");
        programargsList.add(configLocation);
        if (!AgentRelaunch.getInstance().isVmInLauncher()) {
            programargsList.add("-launcher");
            programargsList.add(this.getLauncher());
        }
        programargsList.add("--launcher.library");
        programargsList.add(launcherLibraryPluginLocation);
        programargsList.add("-startup");
        programargsList.add(launcherStartupPluginLocation);
        String[] programargs = programargsList.toArray(new String[programargsList.size()]);
        return programargs;
    }

    private boolean checkForExternalBundleConfigurationModifications(InstallContext context, boolean bundleRegistryWasLoaded) throws CoreException {
        boolean isExternallyModifyedConfiguration = false;
        if (!this.changeStampFile.isFile()) {
            if (bundleRegistryWasLoaded) {
                isExternallyModifyedConfiguration = true;
            }
            return isExternallyModifyedConfiguration;
        }
        Reader reader = null;
        try {
            long actualChangeStamp;
            reader = Encodings.DEFAULT.reader(this.changeStampFile);
            char[] cbuf = new char[32];
            int len = reader.read(cbuf);
            if (len < 1) {
                boolean bl = isExternallyModifyedConfiguration;
                return bl;
            }
            String changeStampText = new String(cbuf, 0, len);
            long expectedChangeStamp = Long.parseLong(changeStampText);
            if (expectedChangeStamp != (actualChangeStamp = this.getChangeStamp())) {
                isExternallyModifyedConfiguration = true;
            }
            boolean bl = isExternallyModifyedConfiguration;
            return bl;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
                }
            }
        }
    }

    private void saveChangeStamp() throws CoreException {
        this.changeStampFile.getParentFile().mkdirs();
        Writer writer = null;
        try {
            try {
                writer = Encodings.DEFAULT.writer(this.changeStampFile);
                String changeStampText = String.valueOf(this.getChangeStamp());
                writer.write(changeStampText, 0, changeStampText.length());
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
                }
            }
        }
    }

    private void stripExternalBundleContributionsAndRestoreInstalledBundles() {
        BundleInfo[] bundleInfos;
        String cacheLocationUrl;
        if (this.isAgentProfile) {
            return;
        }
        try {
            File cacheLocation = CacheManager.getDefaultInstance().getCacheLocation();
            cacheLocationUrl = FileURLUtil.toUnescapedFileURL((File)cacheLocation).toExternalForm();
        }
        catch (Throwable t) {
            ExceptionUtil.debugLogToReview((Throwable)t);
            return;
        }
        BundleInfo[] bundleInfoArray = bundleInfos = super.getBundles();
        int n = bundleInfos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo info = bundleInfoArray[n2];
            if (info.getLocation().startsWith(cacheLocationUrl) && !this.bundleRegistry.isConfiguredVersion(info.getSymbolicName(), info.getVersion())) {
                super.remove(info);
            }
            ++n2;
        }
        List allConfiguredBundleInfos = this.bundleRegistry.getAllConfiguredBundleInfos();
        for (BundleInfo bundleInfo : allConfiguredBundleInfos) {
            super.add(bundleInfo);
        }
    }

    protected boolean isEmptyLauncherFileExistedBefore() {
        return this.installContext != null && this.installContext.getEnclosingProfile().isExistingEclipseProfile() && !this.isLauncherNameDefault();
    }

    public void fixAgentPlatformXml() throws CoreException {
        try {
            File pluginListLocation = this.getPluginListLocation();
            if (!pluginListLocation.isFile()) {
                return;
            }
            URL baseUrl = new URL("platform:/base/");
            if (!this.fixSite(baseUrl)) {
                return;
            }
            this.platformXml.isTransient(false);
            this.platformXml.save();
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.ConfigurationEditor_Error_Writing, (Object)this.platformXml.getConfigurationLocation());
            throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, 1, msg, (Throwable)e));
        }
    }

    private boolean fixSite(URL siteUrl) throws IOException {
        IPlatformConfiguration.ISiteEntry site = this.platformXml.findConfiguredSite(siteUrl);
        if (site == null) {
            log.warning("\"{0}\" site does not exist", new Object[]{siteUrl});
            return false;
        }
        this.platformXml.unconfigureSite(site);
        String[] fixedPlugins = this.fixupPlugins(site);
        IPlatformConfiguration.ISitePolicy fixedPolicy = this.platformXml.createSitePolicy(0, fixedPlugins);
        IPlatformConfiguration.ISiteEntry fixedSite = this.platformXml.createSiteEntry(siteUrl, fixedPolicy);
        this.platformXml.configureSite(fixedSite);
        return true;
    }

    private String readFile(File file) throws IOException {
        char[] buffer = new char[16384];
        StringBuffer result = new StringBuffer();
        Reader reader = Encodings.DEFAULT.reader(file);
        try {
            int length;
            while ((length = reader.read(buffer, 0, buffer.length)) != -1) {
                result.append(buffer, 0, length);
            }
        }
        finally {
            reader.close();
        }
        return result.toString();
    }

    private HashSet getExpectedPlugins() throws IOException {
        HashSet<String> set = new HashSet<String>(400);
        File pluginListLocation = this.getPluginListLocation();
        String[] plugins = this.readFile(pluginListLocation).split(",");
        set.addAll(Arrays.asList(plugins));
        return set;
    }

    private File getPluginListLocation() {
        return new File(this.getInstallLocation(), "documentation" + File.separatorChar + "plugins.txt");
    }

    private String[] fixupPlugins(IPlatformConfiguration.ISiteEntry site) throws IOException {
        String[] plugins = site.getPlugins();
        HashSet expectedPlugins = this.getExpectedPlugins();
        ArrayList<String> newPluginList = new ArrayList<String>(plugins.length);
        String[] stringArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            String plugin = stringArray[n2];
            if (!expectedPlugins.contains(plugin)) {
                log.debug("skipping \"{0}\" bundle", new Object[]{plugin});
            } else {
                newPluginList.add(plugin);
            }
            ++n2;
        }
        Object[] newPlugins = newPluginList.toArray(new String[newPluginList.size()]);
        Arrays.sort(newPlugins);
        return newPlugins;
    }
}

