/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleInfo;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;

public class BundleManager {
    private final Map managedBundles = new HashMap();
    private final Set bundleArtifacts = new HashSet();

    public Bundle getBundle(BundleInfo info, IInstallableUnitContainer reference) {
        String key = this.getVersionedId(info);
        ManagedBundle managedBundle = (ManagedBundle)this.managedBundles.get(key);
        if (managedBundle == null) {
            return null;
        }
        managedBundle.addReference(reference);
        return managedBundle.getBundle();
    }

    public void addBundle(Bundle bundle, IInstallableUnitContainer reference) {
        String key = this.getVersionedId(bundle);
        ManagedBundle managedBundle = (ManagedBundle)this.managedBundles.get(key);
        if (managedBundle == null) {
            managedBundle = new ManagedBundle(bundle);
            this.managedBundles.put(key, managedBundle);
        }
        managedBundle.addReference(reference);
    }

    public Bundle removeBundle(BundleInfo info, IInstallableUnitContainer reference) {
        String key = this.getVersionedId(info);
        ManagedBundle managedBundle = (ManagedBundle)this.managedBundles.get(key);
        if (managedBundle == null) {
            return null;
        }
        managedBundle.removeReference(reference);
        if (managedBundle.hasReferences()) {
            return null;
        }
        this.managedBundles.remove(key);
        return managedBundle.getBundle();
    }

    public boolean hasBundles() {
        return this.managedBundles.size() > 0;
    }

    public Bundle[] getBundles() {
        ArrayList<Bundle> result = new ArrayList<Bundle>(this.managedBundles.size());
        Collection values = this.managedBundles.values();
        for (ManagedBundle managedBundle : values) {
            result.add(managedBundle.getBundle());
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public void addArtifacts(Collection artifacts) {
        this.bundleArtifacts.addAll(artifacts);
    }

    public boolean hasArtifacts() {
        return this.bundleArtifacts.size() > 0;
    }

    public Collection getArtifacts() {
        return Collections.unmodifiableCollection(this.bundleArtifacts);
    }

    public void clear() {
        this.managedBundles.clear();
        this.bundleArtifacts.clear();
    }

    private String getVersionedId(Bundle bundle) {
        return String.valueOf(bundle.getSymbolicName()) + '_' + bundle.getVersion().toString();
    }

    private String getVersionedId(BundleInfo info) {
        return String.valueOf(info.getSymbolicName()) + '_' + info.getVersion();
    }

    private static class ManagedBundle {
        private final Bundle bundle;
        private final Set references = new HashSet();

        protected ManagedBundle(Bundle bundle) {
            this.bundle = bundle;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public void addReference(IInstallableUnitContainer reference) {
            this.references.add(reference);
        }

        public void removeReference(IInstallableUnitContainer reference) {
            this.references.remove(reference);
        }

        public boolean hasReferences() {
            return this.references.size() != 0;
        }
    }
}

