/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.internal.installAdaptors.ConfigurationContributorEditor;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public abstract class AbstractPropertyContributorRegistry {
    private static final String REGISTRY_VERSION_KEY = "VERSION";
    private static final Version REGISTRY_VERSION = new Version(0, 0, 2);
    private static final Version REGISTRY_VERSION_WITH_ID_FIX = new Version(0, 0, 2);
    private static final String CONTRIBUTORS_KEY = "CONTRIBUTORS";
    private static final String EXISTING_ECLIPSE_CONTRIBUTOR_ID = "__EXISTING_ECLIPSE__";
    private static final String EXTERNAL_CONTRIBUTOR_ID_PREFIX = "__EXTERNAL_CONTRIBUTOR__";
    private static final String CONTRIBUTION_KEY_PREFIX = "CONTRIBUTION";
    private final File storageFile;
    protected LinkedHashMap contributions = new LinkedHashMap();
    private boolean isDirty = false;
    private Map mergedRegistry = null;

    protected AbstractPropertyContributorRegistry(File storageFile) {
        this.storageFile = storageFile;
    }

    public abstract void initialize(ConfigurationContributorEditor var1) throws CoreException;

    public abstract void applyMergedChanges(ConfigurationContributorEditor var1);

    public Map getContribution(IInstallableUnit contributor) {
        String contributorId = this.getUnitId(contributor);
        return this.getContribution(contributorId);
    }

    public void removeContribution(IInstallableUnit contributor) {
        String contributorId = this.getUnitId(contributor);
        if (this.contributions.remove(contributorId) != null) {
            this.markDirty();
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void store() throws CoreException {
        if (!this.isDirty) {
            return;
        }
        Properties props = new Properties();
        props.setProperty(REGISTRY_VERSION_KEY, REGISTRY_VERSION.toString());
        int i = 0;
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : this.contributions.entrySet()) {
            String contributorId = (String)entry.getKey();
            if (sb.length() != 0) {
                sb.append('\n');
            }
            sb.append(contributorId);
            Map contribution = (Map)entry.getValue();
            String contributionKey = this.getContributionKey(i++);
            String contributionValue = this.serializeContribution(contribution);
            props.setProperty(contributionKey, contributionValue);
        }
        props.setProperty(CONTRIBUTORS_KEY, sb.toString());
        this.storageFile.getParentFile().mkdirs();
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(this.storageFile);
                props.store(stream, null);
                this.isDirty = false;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
                }
            }
        }
    }

    protected Map createNewContribution() {
        return new LinkedHashMap();
    }

    protected abstract Map createMergedPropertyMap();

    protected boolean load() throws CoreException {
        if (!this.storageFile.isFile()) {
            return false;
        }
        Properties props = new Properties();
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(this.storageFile);
                props.load(stream);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.cic.agent.core.eclipseInstallAdaptor", 1, e.toString(), (Throwable)e));
                }
            }
        }
        String registryVersionValue = props.getProperty(REGISTRY_VERSION_KEY);
        Version registryVersion = registryVersionValue == null ? Version.emptyVersion : new Version(registryVersionValue);
        boolean idsNeedFixing = registryVersion.compareTo(REGISTRY_VERSION_WITH_ID_FIX) < 0;
        String contributorsValue = props.getProperty(CONTRIBUTORS_KEY);
        if (contributorsValue.length() == 0) {
            return true;
        }
        String[] contributorIds = contributorsValue.split("\n");
        int i = 0;
        while (i < contributorIds.length) {
            String contributorId = contributorIds[i];
            String contributionKey = this.getContributionKey(i);
            String contributionValue = props.getProperty(contributionKey);
            Map contribution = this.deserializeContribution(contributionValue);
            if (idsNeedFixing) {
                contributorId = this.fixupOldContributorId(contributorId);
            }
            this.contributions.put(contributorId, this.fixupContribution(contribution));
            ++i;
        }
        return true;
    }

    private String fixupOldContributorId(String contributorId) {
        String[] x = contributorId.split(";");
        if (x.length != 2) {
            return contributorId;
        }
        String suIdAndVersion = x[0];
        String iuIdAndVersion = x[1];
        Object[] y = SplitIdVersionUtil.splitIdUnderscoreVersion((String)suIdAndVersion);
        String suId = (String)y[0];
        return String.valueOf(suId) + ';' + iuIdAndVersion;
    }

    protected Map fixupContribution(Map contribution) {
        return contribution;
    }

    protected void addDelta(Map current) throws CoreException {
        String name;
        Map registry = this.getMergedRegistry();
        Map delta = this.createNewContribution();
        for (Map.Entry entry : current.entrySet()) {
            name = (String)entry.getKey();
            String value = (String)entry.getValue();
            String registryValue = (String)registry.get(name);
            if (registryValue != null) {
                if (this.argMergedValueEquals(name, registryValue, value)) continue;
                delta.put(name, value);
                continue;
            }
            delta.put(name, value);
        }
        for (Map.Entry entry : registry.entrySet()) {
            name = (String)entry.getKey();
            String currentValue = (String)current.get(name);
            if (currentValue != null) continue;
            delta.put(name, null);
        }
        if (delta.size() == 0) {
            return;
        }
        String contributorId = this.getExternalContributorId();
        this.addContribution(contributorId, delta);
        this.store();
    }

    protected boolean argMergedValueEquals(String name, String registryValue, String value) {
        return registryValue != null ? registryValue.equals(value) : value == null;
    }

    protected void addExisting(Map current) throws CoreException {
        if (current.size() != 0) {
            this.addContribution(EXISTING_ECLIPSE_CONTRIBUTOR_ID, current);
            this.store();
        }
    }

    protected Map getMergedRegistry() {
        if (this.mergedRegistry == null) {
            this.mergedRegistry = this.createMergedPropertyMap();
            for (Map contribution : this.contributions.values()) {
                for (Map.Entry entry : contribution.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (value == null) {
                        this.mergedRegistry.remove(name);
                        continue;
                    }
                    String currentValue = (String)this.mergedRegistry.get(name);
                    if (currentValue != null) {
                        if (currentValue.equals(value)) continue;
                        value = this.getMergedValue(name, currentValue, value);
                        this.mergedRegistry.put(name, value);
                        continue;
                    }
                    this.mergedRegistry.put(name, value);
                }
            }
        }
        return this.mergedRegistry;
    }

    protected String getMergedValue(String name, String currentValue, String newValue) {
        return newValue;
    }

    private void markDirty() {
        this.isDirty = true;
        this.mergedRegistry = null;
    }

    private Map getContribution(String contributorId) {
        Map contribution = (Map)this.contributions.get(contributorId);
        if (contribution == null) {
            contribution = this.createNewContribution();
            this.addContribution(contributorId, contribution);
        }
        return contribution;
    }

    private void addContribution(String contributorId, Map contribution) {
        this.contributions.put(contributorId, contribution);
        this.markDirty();
    }

    private String getUnitId(IInstallableUnit unit) {
        return String.valueOf(unit.getParent().getIdentity().getId()) + ';' + IdentityUtil.getVersionedId((IContent)unit);
    }

    private String getExternalContributorId() {
        Date date = new Date();
        return EXTERNAL_CONTRIBUTOR_ID_PREFIX + date.getTime();
    }

    private String getContributionKey(int i) {
        return CONTRIBUTION_KEY_PREFIX + i;
    }

    private String serializeContribution(Map contribution) {
        StringBuffer sb = new StringBuffer();
        Set set = contribution.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (sb.length() != 0) {
                sb.append('\n');
            }
            sb.append(key);
            if (value == null) continue;
            sb.append('=');
            sb.append(value);
        }
        return sb.toString();
    }

    private Map deserializeContribution(String contributionValue) {
        String[] entries;
        Map contribution = this.createNewContribution();
        if (contributionValue.length() == 0) {
            return contribution;
        }
        String[] stringArray = entries = contributionValue.split("\n");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String[] keyAndValue = entry.split("=", 2);
            if (keyAndValue.length == 1) {
                contribution.put(keyAndValue[0], null);
            } else if (keyAndValue.length == 2) {
                contribution.put(keyAndValue[0], keyAndValue[1]);
            }
            ++n2;
        }
        return contribution;
    }
}

