/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipse.qualification;

import com.ibm.cic.common.core.utils.AbstractPlatformPolicyFactory;
import com.ibm.cic.common.core.utils.PlatformUtils;
import java.io.File;
import java.io.IOException;

class PPNewProfileQualificationOperation
extends AbstractPlatformPolicyFactory {
    static PPNewProfileQualificationOperation m_factory = new PPNewProfileQualificationOperation();

    PPNewProfileQualificationOperation() {
    }

    protected Object createLinuxPolicy() {
        return new PPLinux();
    }

    protected Object createWindowsPolicy() {
        return new PPWindows();
    }

    static PPCommon getPolicy() {
        return (PPCommon)m_factory.getPlatformPolicy();
    }

    abstract class PPCommon {
        PPCommon() {
        }

        abstract String useExeOnPath(String var1, File var2);
    }

    class PPLinux
    extends PPCommon {
        PPLinux() {
        }

        String useExeOnPath(String exeSimpleName, File adapterLocation) {
            return exeSimpleName;
        }
    }

    class PPWindows
    extends PPCommon {
        PPWindows() {
        }

        String useExeOnPath(String exeSimpleName, File adapterLocation) {
            String exeFileName;
            String pathVar = PlatformUtils.getEnvironmentVariable((String)"PATH");
            if (pathVar == null) {
                return null;
            }
            String[] paths = pathVar.split(";");
            if (paths.length == 0) {
                return null;
            }
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                exeFileName = this.getExeFromPathSegment(exeSimpleName, path);
                if (exeFileName != null) {
                    return exeFileName;
                }
                ++n2;
            }
            if (paths.length > 1 && (exeFileName = this.getExeFromPathSegment(exeSimpleName, paths[1])) != null) {
                return exeFileName;
            }
            return this.getExeFromPathSegment(exeSimpleName, paths[0]);
        }

        private String getExeFromPathSegment(String exeSimpleName, String pathSegment) {
            File exe = new File(pathSegment, exeSimpleName);
            if (exe.isFile()) {
                try {
                    return exe.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return exe.getPath();
                }
            }
            return null;
        }
    }
}

