/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.eclipse.qualification;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.eclipse.qualification.BundleDetails;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.BundleInfo;
import com.ibm.cic.agent.internal.eclipseAdapter.platformConfiguration.manipulator.FeatureInfo;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import com.ibm.cic.common.eclipseAdapterData.EclipseBundleData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.osgi.framework.Version;

abstract class EclipseQualificationHistory {
    private static final String REGISTRY_VERSION_KEY = "VERSION";
    private static final Version REGISTRY_VERSION = new Version(0, 0, 2);
    private static final Version REGISTRY_VERSION_WITH_KEY_FIX = new Version(0, 0, 2);
    private static final String ECLIPSE_UPDATE_ALLOWED_KEY = "ECLIPSE_UPDATE_ALLOWED";
    private final Profile profile;
    public static final String FILTERED = "filtered";
    public static final String UPDATED = "updated";
    private Properties history;
    private boolean historyDirty;
    private boolean eclipseUpdateAllowed;

    public EclipseQualificationHistory(Profile profile, boolean eclipseUpdateAllowed) {
        this.profile = profile;
        this.eclipseUpdateAllowed = eclipseUpdateAllowed;
    }

    protected abstract File getHistoryFile();

    protected File getExistingEclipseStorage() {
        return new File(this.profile.getAdapterStorage("eclipse"), "existingEclipse");
    }

    public void load() {
        boolean keysNeedFixing;
        String registryVersionValue;
        block17: {
            this.history = new Properties();
            this.historyDirty = false;
            File historyFile = this.getHistoryFile();
            if (!historyFile.isFile()) {
                return;
            }
            FileInputStream stream = null;
            try {
                try {
                    stream = new FileInputStream(historyFile);
                    this.history.load(stream);
                }
                catch (IOException iOException) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        Version registryVersion = (registryVersionValue = this.history.getProperty(REGISTRY_VERSION_KEY)) == null ? Version.emptyVersion : new Version(registryVersionValue);
        String eclipseUpdateAllowedValue = this.history.getProperty(ECLIPSE_UPDATE_ALLOWED_KEY);
        this.eclipseUpdateAllowed = registryVersionValue == null ? false : Boolean.valueOf(eclipseUpdateAllowedValue);
        boolean bl = keysNeedFixing = registryVersion.compareTo(REGISTRY_VERSION_WITH_KEY_FIX) < 0;
        if (keysNeedFixing) {
            Properties newHistory = new Properties();
            Set<Map.Entry<Object, Object>> entries = this.history.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                key = this.fixupOldKey(key);
                newHistory.setProperty(key, value);
            }
            this.history = newHistory;
        }
    }

    protected String getContentIdAndVersion(IContent content) {
        return String.valueOf(content.getIdentity().getId()) + '_' + content.getVersion().toString();
    }

    protected String getParentKey(IInstallableUnit unit) {
        IInstallableUnitContainer parent = unit.getParent();
        if (this.eclipseUpdateAllowed) {
            return this.getContentIdAndVersion((IContent)parent);
        }
        return parent.getIdentity().getId();
    }

    protected abstract String getContentKey(IContent var1);

    public void addFiltered(IContent content) {
        this.add(content, FILTERED);
    }

    public boolean isFiltered(IContent content) {
        String value = this.get(content);
        return value != null && value.startsWith(FILTERED);
    }

    public boolean isUpdated(IContent content) {
        String value = this.get(content);
        return value != null && value.startsWith(UPDATED);
    }

    public void add(IContent content, String value) {
        String key = this.getContentKey(content);
        String prevValue = (String)this.history.setProperty(key, value);
        if (!value.equals(prevValue)) {
            this.historyDirty = true;
        }
    }

    public String get(IContent content) {
        String key = this.getContentKey(content);
        return this.history.getProperty(key);
    }

    public void store() {
        block15: {
            if (!this.historyDirty) {
                return;
            }
            this.history.setProperty(REGISTRY_VERSION_KEY, REGISTRY_VERSION.toString());
            this.history.setProperty(ECLIPSE_UPDATE_ALLOWED_KEY, String.valueOf(this.eclipseUpdateAllowed));
            File historyFile = this.getHistoryFile();
            historyFile.getParentFile().mkdirs();
            FileOutputStream stream = null;
            try {
                try {
                    stream = new FileOutputStream(historyFile);
                    this.history.store(stream, null);
                    this.historyDirty = false;
                }
                catch (IOException iOException) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String fixupOldKey(String key) {
        String[] x = key.split(";");
        if (x.length != 2) {
            return key;
        }
        String suIdAndVersion = x[0];
        String iuIdAndVersion = x[1];
        Object[] y = SplitIdVersionUtil.splitIdUnderscoreVersion((String)suIdAndVersion);
        String suId = (String)y[0];
        return String.valueOf(suId) + ';' + iuIdAndVersion;
    }

    public static class FeatureHistory
    extends EclipseQualificationHistory {
        public FeatureHistory(Profile profile, boolean eclipseUpdateAllowed) {
            super(profile, eclipseUpdateAllowed);
        }

        protected File getHistoryFile() {
            return new File(this.getExistingEclipseStorage(), "featureHistory.properties");
        }

        protected String getContentKey(IContent content) {
            IInstallableUnit unit = (IInstallableUnit)content;
            return String.valueOf(this.getParentKey(unit)) + ';' + this.getContentIdAndVersion((IContent)unit);
        }

        public void add(IInstallableUnit unit, FeatureInfo info) {
            String symbolicName = info.getSymbolicName();
            String version = info.getVersion();
            String pluginId = info.getPluginId();
            String pluginVersion = info.getPluginVersion();
            boolean primary = info.isPrimary();
            String application = info.getApplication();
            StringBuffer sb = new StringBuffer();
            sb.append(EclipseQualificationHistory.UPDATED);
            sb.append(';').append(symbolicName);
            sb.append(';').append(version);
            sb.append(';').append(info.getLocation());
            sb.append(';');
            if (pluginId != null && !pluginId.equals(symbolicName)) {
                sb.append(pluginId);
            }
            sb.append(';');
            if (pluginVersion != null && !pluginVersion.equals(version)) {
                sb.append(pluginVersion);
            }
            sb.append(';');
            if (primary) {
                sb.append(primary);
            }
            sb.append(';');
            if (application != null) {
                sb.append(application);
            }
            while (sb.charAt(sb.length() - 1) == ';') {
                sb.setLength(sb.length() - 1);
            }
            this.add((IContent)unit, sb.toString());
        }

        public FeatureInfo createFeatureInfo(String historyText) {
            FeatureInfo info = new FeatureInfo();
            String[] infoParts = historyText.split(";");
            info.setSymbolicName(infoParts[1]);
            info.setVersion(infoParts[2]);
            info.setLocation(infoParts[3]);
            info.setPluginId(this.getOptionalPart(infoParts, 4));
            info.setPluginVersion(this.getOptionalPart(infoParts, 5));
            info.setPrimary(Boolean.valueOf(this.getOptionalPart(infoParts, 6)));
            info.setApplication(this.getOptionalPart(infoParts, 7));
            return info;
        }

        private String getOptionalPart(String[] infoParts, int index) {
            if (infoParts.length <= index) {
                return null;
            }
            String result = infoParts[index].trim();
            if (result.length() == 0) {
                return null;
            }
            return result;
        }
    }

    public static class JreHistory
    extends EclipseQualificationHistory {
        public JreHistory(Profile profile) {
            super(profile, false);
        }

        protected File getHistoryFile() {
            return new File(this.getExistingEclipseStorage(), "jreHistory.properties");
        }

        protected String getContentKey(IContent content) {
            IShareableUnit unit = (IShareableUnit)content;
            return this.getContentIdAndVersion((IContent)unit);
        }
    }

    public static class PluginHistory
    extends EclipseQualificationHistory {
        public PluginHistory(Profile profile, boolean eclipseUpdateAllowed) {
            super(profile, eclipseUpdateAllowed);
        }

        protected File getHistoryFile() {
            return new File(this.getExistingEclipseStorage(), "pluginHistory.properties");
        }

        protected String getContentKey(IContent content) {
            IInstallableUnit unit = (IInstallableUnit)content;
            return String.valueOf(this.getParentKey(unit)) + ';' + this.getContentIdAndVersion((IContent)unit);
        }

        public void add(BundleDetails details) {
            IInstallableUnit unit = details.getUnit();
            BundleInfo info = details.getInfo();
            String value = "updated;" + info.getSymbolicName() + ';' + info.getVersion() + ';' + String.valueOf(info.getStartLevel()) + ';' + EclipseBundleData.convertState((int)info.expectedState()) + ';' + info.getLocation();
            if (!info.isSingleton()) {
                value = String.valueOf(value) + ';' + Boolean.FALSE.toString();
            }
            this.add((IContent)unit, value);
        }

        public BundleInfo createBundleInfo(String historyText) {
            BundleInfo info = new BundleInfo();
            String[] infoParts = historyText.split(";");
            info.setSymbolicName(infoParts[1]);
            info.setVersion(infoParts[2]);
            info.setStartLevel(Integer.parseInt(infoParts[3]));
            info.setExpectedState(EclipseBundleData.convertState((String)infoParts[4]));
            info.setLocation(infoParts[5]);
            if (infoParts.length > 6) {
                info.setSingleton(Boolean.valueOf(infoParts[6]));
            }
            return info;
        }
    }
}

