/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

class ThunkKey {
    protected final String thunkableSignature;

    public static String computeThunkableSignature(String signature) {
        return ThunkKey.computeThunkableSignature(signature, signature.length());
    }

    public static String computeThunkableSignature(String signature, int stopIndex) {
        return ThunkKey.computeThunkableSignature(signature, stopIndex, signature.indexOf(41));
    }

    public static String computeThunkableSignature(String signature, int stopIndex, int restartIndex) {
        int i;
        StringBuilder sb = new StringBuilder();
        int signatureLength = signature.length();
        block4: for (i = 0; i < signatureLength; ++i) {
            if (i == stopIndex) {
                sb.append(signature, i, restartIndex);
                i = restartIndex - 1;
                continue;
            }
            char c = signature.charAt(i);
            switch (c) {
                case 'L': 
                case '[': {
                    sb.append("Ljava/lang/Object;");
                    while (signature.charAt(i) == '[') {
                        ++i;
                    }
                    if (signature.charAt(i) != 'L') continue block4;
                    while (signature.charAt(i) != ';') {
                        ++i;
                    }
                    continue block4;
                }
                case 'B': 
                case 'C': 
                case 'S': 
                case 'Z': {
                    sb.append('I');
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append(signature, i, signatureLength);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof ThunkKey) {
            return ((ThunkKey)other).equalsThunkKey(this);
        }
        return false;
    }

    public int hashCode() {
        return this.thunkableSignature.hashCode();
    }

    protected boolean equalsThunkKey(ThunkKey other) {
        return this.thunkableSignature.equals(other.thunkableSignature);
    }

    public final String thunkableSignature() {
        return this.thunkableSignature;
    }

    public ThunkKey(String thunkableSignature) {
        this.thunkableSignature = thunkableSignature;
    }

    public static void load() {
    }
}

