/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ComputedCalls;
import java.lang.invoke.IndirectHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Method;

final class InterfaceHandle
extends IndirectHandle {
    private static final ThunkTable _thunkTable;

    static native void registerNatives();

    InterfaceHandle(Class definingClass, String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
        super(type, definingClass, methodName, 3);
        assert (definingClass.isInterface());
        this.defc = this.finishMethodInitialization(null, type);
    }

    InterfaceHandle(Method method) throws IllegalAccessException {
        super(MethodType.methodType(method.getReturnType(), method.getParameterTypes()), method.getDeclaringClass(), method.getName(), 3);
        if (!this.definingClass.isInterface()) {
            throw new IllegalArgumentException();
        }
        boolean succeed = InterfaceHandle.setVMSlotAndRawModifiersFromMethod(this, this.definingClass, method, this.kind, this.specialCaller);
        if (!succeed) {
            throw new IllegalAccessException();
        }
    }

    public InterfaceHandle(InterfaceHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
    }

    @Override
    MethodType computeHandleType(MethodType type) {
        return type.insertParameterTypes(0, this.definingClass);
    }

    @Override
    protected final int vtableIndex(Object receiver) {
        Class interfaceClass = this.defc;
        if (interfaceClass.isInstance(receiver)) {
            long interfaceJ9Class = InterfaceHandle.getJ9ClassFromClass(interfaceClass);
            long receiverJ9Class = InterfaceHandle.getJ9ClassFromClass(receiver.getClass());
            return InterfaceHandle.convertITableIndexToVTableIndex(interfaceJ9Class, (int)this.vmSlot, receiverJ9Class);
        }
        throw new Error();
    }

    protected static native int convertITableIndexToVTableIndex(long var0, int var2, long var3);

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @MethodHandle.Invisible
    private final void invokeExact_thunkArchetype_V(Object receiver, int argPlaceholder) {
        ComputedCalls.dispatchVirtual_V(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final int invokeExact_thunkArchetype_I(Object receiver, int argPlaceholder) {
        return ComputedCalls.dispatchVirtual_I(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final long invokeExact_thunkArchetype_J(Object receiver, int argPlaceholder) {
        return ComputedCalls.dispatchVirtual_J(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final float invokeExact_thunkArchetype_F(Object receiver, int argPlaceholder) {
        return ComputedCalls.dispatchVirtual_F(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final double invokeExact_thunkArchetype_D(Object receiver, int argPlaceholder) {
        return ComputedCalls.dispatchVirtual_D(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final Object invokeExact_thunkArchetype_L(Object receiver, int argPlaceholder) {
        return ComputedCalls.dispatchVirtual_L(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new InterfaceHandle(this, newType);
    }

    static {
        InterfaceHandle.registerNatives();
        _thunkTable = new ThunkTable();
    }
}

