/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.FieldHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

final class FieldSetterHandle
extends FieldHandle {
    private static final ThunkTable _thunkTable = new ThunkTable();

    FieldSetterHandle(Class referenceClass, String fieldName, Class fieldClass, Class accessClass) throws IllegalAccessException, NoSuchFieldException {
        super(FieldSetterHandle.fieldMethodType(referenceClass, fieldClass), referenceClass, fieldName, fieldClass, 7, accessClass);
    }

    FieldSetterHandle(Field field) throws IllegalAccessException {
        super(FieldSetterHandle.fieldMethodType(field.getDeclaringClass(), field.getType()), field, 7, false);
    }

    FieldSetterHandle(FieldSetterHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
    }

    private static final MethodType fieldMethodType(Class definingClass, Class fieldClass) {
        return MethodType.methodType(Void.TYPE, definingClass, fieldClass);
    }

    @MethodHandle.Invisible
    private final void invokeExact_thunkArchetype_V(Object receiver, int newValue, int argPlaceholder) {
        if (Modifier.isVolatile(this.rawModifiers)) {
            FieldSetterHandle.getUnsafe().putIntVolatile(receiver, this.vmSlot + (long)HEADER_SIZE, newValue);
        } else {
            FieldSetterHandle.getUnsafe().putInt(receiver, this.vmSlot + (long)HEADER_SIZE, newValue);
        }
    }

    @MethodHandle.Invisible
    private final void invokeExact_thunkArchetype_V(Object receiver, long newValue, int argPlaceholder) {
        if (Modifier.isVolatile(this.rawModifiers)) {
            FieldSetterHandle.getUnsafe().putLongVolatile(receiver, this.vmSlot + (long)HEADER_SIZE, newValue);
        } else {
            FieldSetterHandle.getUnsafe().putLong(receiver, this.vmSlot + (long)HEADER_SIZE, newValue);
        }
    }

    @MethodHandle.Invisible
    private final void invokeExact_thunkArchetype_V(Object receiver, float newValue, int argPlaceholder) {
        if (Modifier.isVolatile(this.rawModifiers)) {
            FieldSetterHandle.getUnsafe().putFloatVolatile(receiver, this.vmSlot + (long)HEADER_SIZE, newValue);
        } else {
            FieldSetterHandle.getUnsafe().putFloat(receiver, this.vmSlot + (long)HEADER_SIZE, newValue);
        }
    }

    @MethodHandle.Invisible
    private final void invokeExact_thunkArchetype_V(Object receiver, double newValue, int argPlaceholder) {
        if (Modifier.isVolatile(this.rawModifiers)) {
            FieldSetterHandle.getUnsafe().putDoubleVolatile(receiver, this.vmSlot + (long)HEADER_SIZE, newValue);
        } else {
            FieldSetterHandle.getUnsafe().putDouble(receiver, this.vmSlot + (long)HEADER_SIZE, newValue);
        }
    }

    @MethodHandle.Invisible
    private final void invokeExact_thunkArchetype_V(Object receiver, Object newValue, int argPlaceholder) {
        if (Modifier.isVolatile(this.rawModifiers)) {
            FieldSetterHandle.getUnsafe().putObjectVolatile(receiver, this.vmSlot + (long)HEADER_SIZE, newValue);
        } else {
            FieldSetterHandle.getUnsafe().putObject(receiver, this.vmSlot + (long)HEADER_SIZE, newValue);
        }
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new FieldSetterHandle(this, newType);
    }
}

