/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

abstract class FieldHandle
extends MethodHandle {
    final Class<?> fieldClass;

    FieldHandle(MethodType type, Class<?> referenceClass, String fieldName, Class fieldClass, int kind, Class<?> accessClass) throws IllegalAccessException, NoSuchFieldException {
        super(type, referenceClass, fieldName, kind, null);
        this.fieldClass = fieldClass;
        this.defc = this.finishFieldInitialization(accessClass);
    }

    FieldHandle(MethodType type, Field field, int kind, boolean isStatic) throws IllegalAccessException {
        super(type, field.getDeclaringClass(), field.getName(), kind, null);
        this.fieldClass = field.getType();
        assert (isStatic == Modifier.isStatic(field.getModifiers()));
        boolean succeed = FieldHandle.setVMSlotAndRawModifiersFromField(this, field);
        if (!succeed) {
            throw new IllegalAccessException();
        }
    }

    FieldHandle(FieldHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.fieldClass = originalHandle.fieldClass;
    }

    final Class<?> finishFieldInitialization(Class<?> accessClass) throws IllegalAccessException, NoSuchFieldException {
        String signature = MethodType.getBytecodeStringName(this.fieldClass);
        try {
            return this.lookupField(this.definingClass, this.name, signature, this.kind, accessClass);
        }
        catch (NoSuchFieldError e) {
            throw new NoSuchFieldException(e.getMessage());
        }
        catch (LinkageError e) {
            throw (IllegalAccessException)new IllegalAccessException(e.getMessage()).initCause(e);
        }
    }
}

