/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.AgentInitializationException;
import com.ibm.tools.attach.AgentLoadException;
import com.ibm.tools.attach.AttachNotSupportedException;
import com.ibm.tools.attach.VirtualMachineDescriptor;
import com.ibm.tools.attach.javaSE.Permissions;
import com.ibm.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class VirtualMachine {
    private final AttachProvider provider;
    private final String id;

    protected VirtualMachine(AttachProvider provider, String id) {
        this.provider = provider;
        this.id = id;
    }

    public static List<VirtualMachineDescriptor> list() {
        List<AttachProvider> providerList = AttachProvider.providers();
        ArrayList<VirtualMachineDescriptor> allVMs = new ArrayList<VirtualMachineDescriptor>();
        if (null != providerList) {
            for (AttachProvider provider : providerList) {
                List<VirtualMachineDescriptor> vms = provider.listVirtualMachines();
                if (vms == null) continue;
                allVMs.addAll(vms);
            }
        }
        return allVMs;
    }

    public static VirtualMachine attach(String id) throws AttachNotSupportedException, IOException {
        VirtualMachine.checkSecurity();
        if (null == id) {
            throw new NullPointerException(Msg.getString("K0554"));
        }
        List<AttachProvider> providers = AttachProvider.providers();
        if (null == providers || providers.isEmpty()) {
            throw new AttachNotSupportedException(Msg.getString("K0534"));
        }
        AttachNotSupportedException providerException = null;
        for (AttachProvider provider : providers) {
            try {
                VirtualMachine vm = provider.attachVirtualMachine(id);
                if (vm == null) continue;
                return vm;
            }
            catch (AttachNotSupportedException e) {
                providerException = e;
            }
        }
        if (null != providerException) {
            throw providerException;
        }
        throw new AttachNotSupportedException(Msg.getString("K0542", id));
    }

    public static VirtualMachine attach(VirtualMachineDescriptor descriptor) throws AttachNotSupportedException, IOException {
        VirtualMachine.checkSecurity();
        if (null == descriptor) {
            throw new NullPointerException(Msg.getString("K0554"));
        }
        AttachProvider provider = descriptor.provider();
        return provider.attachVirtualMachine(descriptor);
    }

    public abstract void detach() throws IOException;

    public boolean equals(Object comparand) {
        if (comparand == null || !(comparand instanceof VirtualMachine)) {
            return false;
        }
        VirtualMachine otherVM = (VirtualMachine)comparand;
        return this.id().equals(otherVM.id());
    }

    public abstract Properties getAgentProperties() throws IOException;

    public abstract Properties getSystemProperties() throws IOException;

    public int hashCode() {
        return this.provider().hashCode() + this.id().hashCode();
    }

    public final String id() {
        return this.id;
    }

    public void loadAgent(String agent) throws AgentLoadException, AgentInitializationException, IOException {
        if (null == agent) {
            throw new AgentLoadException(Msg.getString("K0570"));
        }
        this.loadAgent(agent, "");
    }

    public abstract void loadAgent(String var1, String var2) throws AgentLoadException, AgentInitializationException, IOException;

    public void loadAgentLibrary(String agentLibrary) throws AgentLoadException, AgentInitializationException, IOException {
        if (null == agentLibrary) {
            throw new AgentLoadException(Msg.getString("K0573"));
        }
        this.loadAgentLibrary(agentLibrary, "");
    }

    public abstract void loadAgentLibrary(String var1, String var2) throws AgentLoadException, AgentInitializationException, IOException;

    public void loadAgentPath(String agentPath) throws AgentLoadException, AgentInitializationException, IOException {
        this.loadAgentPath(agentPath, "");
    }

    public abstract void loadAgentPath(String var1, String var2) throws AgentLoadException, AgentInitializationException, IOException;

    public final AttachProvider provider() {
        return this.provider;
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + ";" + this.id();
    }

    private static void checkSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.ATTACH_VM);
        }
    }
}

