/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.AbstractClassLoader;
import com.ibm.oti.vm.VM;
import java.io.FilePermission;
import java.util.Enumeration;
import java.util.Hashtable;

public final class BootstrapClassLoader
extends AbstractClassLoader {
    private static BootstrapClassLoader singleton;
    private Hashtable packages = new Hashtable();
    ThreadLocal definingPackage = new ThreadLocal();

    private BootstrapClassLoader() {
        int count = VM.getClassPathCount();
        this.types = new int[count];
        this.cache = new Object[count];
        this.parsedPath = new String[count];
        VM.initializeClassLoader(this, true, false);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        String packageName;
        Class loadedClass = VM.findClassOrNull(className, this);
        if (loadedClass != null && (packageName = this.getPackageName(loadedClass)) != null && super.getPackage(packageName) == null) {
            int index = VM.getCPIndexImpl(loadedClass);
            this.addPackage(packageName, index);
        }
        return loadedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackage(String packageName, int index) {
        Hashtable hashtable = this.packages;
        synchronized (hashtable) {
            if (!this.packages.containsKey(packageName)) {
                this.packages.put(packageName, new Integer(index));
            }
        }
    }

    public static ClassLoader singleton() {
        if (singleton != null) {
            throw new SecurityException(Msg.getString("K0084"));
        }
        singleton = new BootstrapClassLoader();
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package getPackage(String name) {
        Package result;
        Integer index = (Integer)this.packages.get(name);
        if (index == null) {
            return super.getPackage(name);
        }
        String inPackage = (String)this.definingPackage.get();
        if (name.equals(inPackage)) {
            return null;
        }
        if (inPackage != null) {
            throw new InternalError();
        }
        this.definingPackage.set(name);
        try {
            result = this.definePackage(name, index);
            this.packages.remove(name);
        }
        finally {
            this.definingPackage.set(null);
        }
        return result;
    }

    @Override
    protected Package[] getPackages() {
        while (this.packages.size() > 0) {
            Hashtable packagesClone = (Hashtable)this.packages.clone();
            Enumeration keys = packagesClone.keys();
            while (keys.hasMoreElements()) {
                this.getPackage((String)keys.nextElement());
            }
        }
        return super.getPackages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToClassPathForInstrumentation(String jarPath) throws Throwable {
        Object object = cacheLock;
        synchronized (object) {
            int newCount = this.addJar(Util.getBytes(jarPath));
            int[] newTypes = new int[newCount];
            System.arraycopy((Object)this.types, 0, (Object)newTypes, 0, newCount - 1);
            this.types = newTypes;
            Object[] newCache = new Object[newCount];
            System.arraycopy((Object)this.cache, 0, (Object)newCache, 0, newCount - 1);
            this.cache = newCache;
            String[] newParsedPath = new String[newCount];
            System.arraycopy((Object)this.parsedPath, 0, (Object)newParsedPath, 0, newCount - 1);
            this.parsedPath = newParsedPath;
            if (this.permissions != null) {
                FilePermission[] newPermissions = new FilePermission[newCount];
                System.arraycopy((Object)this.permissions, 0, (Object)newPermissions, 0, newCount - 1);
                this.permissions = newPermissions;
            }
        }
    }

    private native int addJar(byte[] var1);

    static {
        VM.initializeVM();
        Class<Integer> clazz = Integer.class;
    }
}

