/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.commons.net;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.downloads.PreferencesHolder;
import com.ibm.cic.common.downloads.SocketEvents;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.net.SocketFactory;

public class TimeoutSocketFactory
implements SocketFactory {
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket socket = new ServerSocket(port);
        socket.setSoTimeout(PreferencesHolder.INSTANCE.getReadTimeout() * 1000);
        return socket;
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        ServerSocket socket = new ServerSocket(port, backlog);
        socket.setSoTimeout(PreferencesHolder.INSTANCE.getReadTimeout() * 1000);
        return socket;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        ServerSocket socket = new ServerSocket(port, backlog, bindAddr);
        socket.setSoTimeout(PreferencesHolder.INSTANCE.getReadTimeout() * 1000);
        return socket;
    }

    public Socket createSocket(String host, int port) throws UnknownHostException, IOException {
        InetSocketAddress address = host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port);
        InetSocketAddress localAddress = new InetSocketAddress(0);
        return this.createConnectedSocket(localAddress, address);
    }

    private Socket createConnectedSocket(InetSocketAddress localAddress, InetSocketAddress address) throws IOException {
        if (address == null) {
            throw new NullPointerException();
        }
        Socket socket = javax.net.SocketFactory.getDefault().createSocket();
        if (CicCommonSettings.isWindowsVista()) {
            socket.setReuseAddress(true);
        }
        SocketEvents.SocketToConnect stc = new SocketEvents.SocketToConnect(socket, address, localAddress);
        try {
            SocketEvents.FIRE.onBeforeSocketConnected(stc);
            socket.bind(localAddress);
            int timeout = PreferencesHolder.INSTANCE.getConnectTimeout() * 1000;
            socket.connect(address, timeout);
            socket.setSoTimeout(PreferencesHolder.INSTANCE.getReadTimeout() * 1000);
            SocketEvents.FIRE.onSocketConnected(stc);
            return new SocketEvents.SocketEventEmittingWrapper(socket, null);
        }
        catch (SocketException e) {
            socket.close();
            SocketEvents.FIRE.onSocketConnectFailed(stc, (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            socket.close();
            SocketEvents.FIRE.onSocketConnectFailed(stc, (Throwable)e);
            throw e;
        }
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        if (address == null) {
            throw new NullPointerException();
        }
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        InetSocketAddress localAddress = new InetSocketAddress(0);
        return this.createConnectedSocket(localAddress, socketAddress);
    }

    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws UnknownHostException, IOException {
        InetSocketAddress socketAddress = host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port);
        InetSocketAddress localAddress = new InetSocketAddress(localAddr, localPort);
        return this.createConnectedSocket(localAddress, socketAddress);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        if (address == null) {
            throw new NullPointerException();
        }
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        InetSocketAddress localAddress = new InetSocketAddress(localAddr, localPort);
        return this.createConnectedSocket(localAddress, socketAddress);
    }
}

