/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.commons.net;

import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.downloads.handlerImpl.AbstractAuthenticator;
import com.ibm.cic.common.downloads.handlerImpl.FtpUrlEncodedLogin;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import org.eclipse.osgi.util.NLS;

public class FtpCredentialsProvider
implements FtpUrlEncodedLogin.IFtpCredentialProvider {
    public static final FtpCredentialsProvider INSTANCE = new FtpCredentialsProvider();
    private final AbstractAuthenticator authenticator = new AbstractAuthenticator(){

        protected String getTraceName() {
            return "FtpCommonsNetAuthenticator";
        }
    };

    private FtpCredentialsProvider() {
    }

    public boolean getUsernameAndPassword(URI uri, boolean allowUserPrompt, String[] outUserPass) throws IOException {
        CredentialRequested requested = FtpUrlEncodedLogin.getRequested((URI)uri);
        AbstractAuthenticator.CredentialResult credResult = this.authenticator.getCredentials(requested, allowUserPrompt);
        if (credResult == null) {
            return false;
        }
        if (!credResult.getStatus().isOK()) {
            assert (credResult.getStatus().matches(8));
            String msg = NLS.bind((String)Messages.CredentialPrompter_canceled_credentials, (Object)requested.getRealm());
            throw new InterruptedIOException(msg);
        }
        CredentialInfo credInfo = credResult.getCredentialInfo();
        outUserPass[0] = credInfo.getUid();
        outUserPass[1] = credInfo.getPwd();
        return true;
    }

    public AbstractAuthenticator getAuthenticator() {
        return this.authenticator;
    }
}

