/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util.objectpool;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.util.WSThreadLocal;
import com.ibm.ws.util.objectpool.CircularObjectPool;
import com.ibm.ws.util.objectpool.LocalThreadObjectPool;
import com.ibm.ws.util.objectpool.ObjectDestroyer;
import com.ibm.ws.util.objectpool.ObjectFactory;
import com.ibm.ws.util.objectpool.ObjectPool;
import java.util.Hashtable;

public class TwoTierObjectPool
implements ObjectPool {
    public static final String TWO_TIER_OBJECT_POOL = "TwoTierObjectPool";
    private int threadPoolSize;
    private WSThreadLocal threadLocals = null;
    private CircularObjectPool mainPool = null;
    private ObjectFactory factory;
    private Hashtable inUseTable = null;
    private boolean inUseTracking;
    private boolean cleanUpOld = true;
    private ObjectDestroyer destroyer;
    private static final TraceComponent tc;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TwoTierObjectPool(int n, int n2, ObjectFactory objectFactory, boolean bl) {
        this.threadPoolSize = n;
        int n3 = n2;
        this.factory = objectFactory;
        this.inUseTracking = bl;
        if (this.threadPoolSize > 0) {
            this.threadLocals = new WSThreadLocal();
        }
        if (n3 > 0) {
            this.mainPool = new CircularObjectPool(n3, this.factory);
        }
        if (this.inUseTracking) {
            this.inUseTable = new Hashtable(this.threadPoolSize * 2 + n3 * 2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Object Pool " + this + " created, local size: " + this.threadPoolSize + ", main pool size: " + n3);
        }
    }

    public TwoTierObjectPool(int n, int n2, ObjectFactory objectFactory, ObjectDestroyer objectDestroyer, boolean bl) {
        this.threadPoolSize = n;
        int n3 = n2;
        this.factory = objectFactory;
        this.destroyer = objectDestroyer;
        this.inUseTracking = bl;
        if (this.threadPoolSize > 0) {
            this.threadLocals = new WSThreadLocal();
        }
        if (n3 > 0) {
            this.mainPool = new CircularObjectPool(n3, this.factory, this.destroyer);
        }
        if (this.inUseTracking) {
            this.inUseTable = new Hashtable(this.threadPoolSize * 2 + n3 * 2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Object Pool " + this + " created, local size: " + this.threadPoolSize + ", main pool size: " + n3);
        }
    }

    public TwoTierObjectPool(int n, int n2) {
        this(n, n2, null, false);
    }

    public void doNotCleanUpOld() {
        if (this.mainPool != null) {
            this.mainPool.setCleanUpOld(false);
        }
        this.cleanUpOld = false;
    }

    public Object get() {
        Object object = null;
        LocalThreadObjectPool localThreadObjectPool = this.getThreadLocalObjectPool();
        if (localThreadObjectPool != null) {
            object = localThreadObjectPool.get();
        }
        if (object == null && this.mainPool != null) {
            if (localThreadObjectPool != null) {
                Object[] objectArray = this.mainPool.getBatch();
                localThreadObjectPool.putBatch(objectArray);
                object = localThreadObjectPool.get();
            } else {
                object = this.mainPool.get();
            }
        }
        if (object == null && this.factory != null) {
            object = this.factory.create();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Object Pool " + this + " couldn't obtain object from either local or global pool, new object created");
            }
        }
        if (this.inUseTracking && object != null) {
            this.inUseTable.put(object, object);
        }
        return object;
    }

    public Object put(Object object) {
        LocalThreadObjectPool localThreadObjectPool;
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        Object object2 = object;
        if (this.inUseTracking) {
            this.inUseTable.remove(object);
        }
        if ((localThreadObjectPool = this.getThreadLocalObjectPool()) != null) {
            object2 = localThreadObjectPool.put(object2);
        }
        if (this.mainPool != null && object2 != null) {
            Object[] objectArray;
            this.mainPool.put(object2);
            if (localThreadObjectPool != null && (objectArray = localThreadObjectPool.getBatch())[0] != null) {
                this.mainPool.putBatch(objectArray);
            }
        }
        return null;
    }

    private LocalThreadObjectPool getThreadLocalObjectPool() {
        if (this.threadPoolSize <= 0) {
            return null;
        }
        LocalThreadObjectPool localThreadObjectPool = null;
        if (this.threadLocals != null && (localThreadObjectPool = (LocalThreadObjectPool)this.threadLocals.get()) == null) {
            localThreadObjectPool = new LocalThreadObjectPool(this.threadPoolSize, null, this.destroyer);
            this.threadLocals.set(localThreadObjectPool);
            localThreadObjectPool.setCleanUpOld(this.cleanUpOld);
        }
        return localThreadObjectPool;
    }

    public void removeFromInUse(Object object) {
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        if (this.inUseTracking) {
            this.inUseTable.remove(object);
        }
    }

    public Object[] getInUseTable() {
        return ((Hashtable)this.inUseTable.clone()).keySet().toArray();
    }

    public void purgeThreadLocal() {
        Object[] objectArray;
        LocalThreadObjectPool localThreadObjectPool;
        if (null != this.threadLocals && null != (localThreadObjectPool = (LocalThreadObjectPool)this.threadLocals.get()) && 0 < (objectArray = localThreadObjectPool.purge()).length) {
            this.mainPool.putBatch(objectArray);
        }
    }

    static {
        $assertionsDisabled = !TwoTierObjectPool.class.desiredAssertionStatus();
        tc = Tr.register(TwoTierObjectPool.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    }
}

