/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.io.Converters;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class SBCS_Decoder
extends CharsetDecoder {
    private final char[] byteToCharTable_charr;
    private final char[] charMap;
    private int byteOff;
    private int charOff;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static boolean bidiConfigDone = false;
    private static String bidiInit;
    protected static final int NEW_LINE_INDEX = 149;
    protected static final char SWAPPED_NEW_LINE_CHAR = '\u0085';
    private String csName = null;

    protected SBCS_Decoder(Charset charset, String string) {
        super(charset, 1.0f, 1.0f);
        String string2 = this.handleIBMSwapLF(string);
        this.byteToCharTable_charr = string2.toCharArray();
        this.charMap = SBCS_Decoder.createCharMap(string2);
        this.csName = charset.name();
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    protected String handleIBMSwapLF(String string) {
        return string;
    }

    public static final boolean isSwapLF() {
        return Converters.isSwapLF();
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n4 = charBuffer.arrayOffset() + charBuffer.position();
        int n5 = charBuffer.arrayOffset() + charBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        boolean bl = false;
        int n6 = n2;
        int n7 = n4;
        int n8 = n3 - n2;
        if (n8 > n5 - n4) {
            bl = true;
            n8 = n5 - n4;
        }
        int n9 = n8;
        char c = '\u0000';
        if (this.charMap != null) {
            for (n = 0; n < n9; ++n) {
                cArray[n + n7] = c = this.charMap[byArray[n + n6] & 0xFF];
            }
        } else {
            while (n < n9) {
                cArray[n + n7] = c = this.byteToCharTable_charr[byArray[n + n6] + 128];
                ++n;
            }
        }
        this.byteOff = n2 + n8;
        this.charOff = n4 + n8;
        if (bl) {
            coderResult = CoderResult.OVERFLOW;
        }
        byteBuffer.position(this.byteOff - byteBuffer.arrayOffset());
        charBuffer.position(this.charOff - charBuffer.arrayOffset());
        return coderResult;
    }

    private static boolean isRemapTable() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.name");
            }
        });
        return "z/OS".equals(string);
    }

    protected static char[] createCharMap(String string) {
        char[] cArray;
        if (SBCS_Decoder.isRemapTable()) {
            int n;
            cArray = new char[256];
            for (n = 0; n < 128; ++n) {
                cArray[n + 128] = string.charAt(n);
            }
            for (n = 128; n < 256; ++n) {
                cArray[n - 128] = string.charAt(n);
            }
        } else {
            cArray = null;
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.hasRemaining()) {
                int n2 = byteBuffer.get() + 128;
                char c = n2 >= this.byteToCharTable_charr.length || n2 < 0 ? (char)'\ufffd' : (char)this.decode(n2, this.byteToCharTable_charr[n2]);
                if (c == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n;
                charBuffer.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        BidiConvert bidiConvert;
        int n;
        int n2;
        char[] cArray;
        CoderResult coderResult;
        boolean bl;
        int n3 = charBuffer.position();
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            bl = true;
            coderResult = this.decodeArrayLoop(byteBuffer, charBuffer);
            int n4 = charBuffer.position();
            cArray = charBuffer.array();
            n2 = charBuffer.arrayOffset() + n3;
            n = charBuffer.arrayOffset() + n4;
        } else {
            bl = false;
            coderResult = this.decodeBufferLoop(byteBuffer, charBuffer);
            int n5 = charBuffer.position();
            n2 = 0;
            n = n5 - n3;
            cArray = new char[n];
            charBuffer.position(n3);
            charBuffer.get(cArray);
            charBuffer.position(n5);
        }
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n2, n, this.bidiParms, this.csName)) {
            cArray = bidiConvert.toUnicode(cArray, n2, n, this.bidiParms, this.csName);
            if (bl) {
                System.arraycopy(cArray, 0, charBuffer.array(), charBuffer.arrayOffset() + n3, cArray.length);
            } else {
                charBuffer.position(n3);
                charBuffer.put(cArray);
            }
        }
        return coderResult;
    }

    public char decode(int n, char c) {
        return c;
    }

    @Override
    protected void implReset() {
        this.charOff = 0;
        this.byteOff = 0;
    }
}

