/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Encoder;

public class EUC_JP_LINUX
extends Charset
implements HistoricallyNamedCharset {
    public EUC_JP_LINUX() {
        super("x-EUC_JP_LINUX", ExtendedCharsets.aliasesFor("x-EUC_JP_LINUX"));
    }

    @Override
    public String historicalName() {
        return "x-EUC_JP_LINUX";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof JIS_X_0201 || charset.name().equals("US-ASCII") || charset instanceof EUC_JP_LINUX;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends CharsetEncoder {
        JIS_X_0201.Encoder encoderJ0201;
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        private static final short[] jis0208Index1 = JIS_X_0208_Encoder.getIndex1();
        private static final String[] jis0208Index2 = JIS_X_0208_Encoder.getIndex2();

        private Encoder(Charset charset) {
            super(charset, 2.0f, 2.0f);
            this.encoderJ0201 = new JIS_X_0201.Encoder(charset);
        }

        @Override
        public boolean canEncode(char c) {
            byte[] byArray = new byte[2];
            return this.encodeSingle(c, byArray) != 0 || this.encodeDouble(c) != 0;
        }

        protected int encodeSingle(char c, byte[] byArray) {
            if (c == '\u0000') {
                byArray[0] = 0;
                return 1;
            }
            byte by = this.encoderJ0201.encode(c);
            if (by == 0) {
                return 0;
            }
            if (by > 0 && by < 128) {
                byArray[0] = by;
                return 1;
            }
            byArray[0] = -114;
            byArray[1] = by;
            return 2;
        }

        protected int encodeDouble(char c) {
            int n = jis0208Index1[(c & 0xFF00) >> 8] << 8;
            char c2 = jis0208Index2[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
            if (c2 != '\u0000') {
                return c2 + 32896;
            }
            return c2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            byte[] byArray2 = new byte[2];
            try {
                for (n = n <= n2 ? n : n2; n < n2; ++n) {
                    int n5;
                    char c = cArray[n];
                    if (Character.isSurrogate(c)) {
                        if (this.sgp.parse(c, cArray, n, n2) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    int n6 = this.encodeSingle(c, byArray2);
                    if (n6 == 0) {
                        n5 = this.encodeDouble(c);
                        if (n5 != 0 && (n5 & 0xFF0000) == 0) {
                            byArray2[0] = (byte)((n5 & 0xFF00) >> 8);
                            byArray2[1] = (byte)(n5 & 0xFF);
                            n6 = 2;
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (n4 - n3 < n6) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (n5 = 0; n5 < n6; ++n5) {
                        byArray[n3++] = byArray2[n5];
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            byte[] byArray = new byte[4];
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n2;
                    char c = charBuffer.get();
                    if (Character.isSurrogate(c)) {
                        if (this.sgp.parse(c, charBuffer) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    int n3 = this.encodeSingle(c, byArray);
                    if (n3 == 0) {
                        n2 = this.encodeDouble(c);
                        if (n2 != 0) {
                            if ((n2 & 0xFF0000) == 0) {
                                byArray[0] = (byte)((n2 & 0xFF00) >> 8);
                                byArray[1] = (byte)(n2 & 0xFF);
                                n3 = 2;
                            }
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (byteBuffer.remaining() < n3) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        byteBuffer.put(byArray[n2]);
                    }
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        JIS_X_0201.Decoder decoderJ0201;
        protected final char REPLACE_CHAR = (char)65533;
        private static final int start = 161;
        private static final int end = 254;
        private static final short[] jis0208Index1 = JIS_X_0208_Decoder.getIndex1();
        private static final String[] jis0208Index2 = JIS_X_0208_Decoder.getIndex2();

        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
            this.decoderJ0201 = new JIS_X_0201.Decoder(charset);
        }

        protected char convSingleByte(int n) {
            if (n < 0 || n > 127) {
                return '\ufffd';
            }
            return this.decoderJ0201.decode(n);
        }

        protected char decodeDouble(int n, int n2) {
            if (n == 142) {
                return this.decoderJ0201.decode(n2 - 256);
            }
            if (n < 0 || n > jis0208Index1.length || n2 < 161 || n2 > 254) {
                return '\ufffd';
            }
            int n3 = (jis0208Index1[n - 128] & 0xF) * 94 + (n2 - 161);
            return jis0208Index2[jis0208Index1[n - 128] >> 4].charAt(n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n <= n2);
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 65533;
            try {
                for (n = n <= n2 ? n : n2; n < n2; n += n7) {
                    n5 = byArray[n] & 0xFF;
                    n7 = 1;
                    if ((n5 & 0x80) == 0) {
                        n8 = (char)n5;
                    } else {
                        if ((n5 & 0xFF) == 143) {
                            if (n + 3 > n2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n7 = 3;
                            CoderResult coderResult = CoderResult.unmappableForLength(n7);
                            return coderResult;
                        }
                        if (n + 2 > n2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n6 = byArray[n + 1] & 0xFF;
                        n7 = 2;
                        n8 = this.decodeDouble(n5, n6);
                    }
                    if (n8 == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n7);
                        return coderResult;
                    }
                    if (n3 + 1 > n4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n3++] = n8;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            char c = '\ufffd';
            try {
                while (byteBuffer.hasRemaining()) {
                    int n2 = byteBuffer.get() & 0xFF;
                    int n3 = 1;
                    if ((n2 & 0x80) == 0) {
                        c = (char)n2;
                    } else {
                        if ((n2 & 0xFF) == 143) {
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(3);
                            return coderResult;
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int n4 = byteBuffer.get() & 0xFF;
                        ++n3;
                        c = this.decodeDouble(n2, n4);
                    }
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(n3);
                        return coderResult;
                    }
                    if (charBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put(c);
                    n += n3;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }
    }
}

