/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208;
import sun.nio.cs.ext.JIS_X_0208_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Encoder;
import sun.nio.cs.ext.JIS_X_0212;
import sun.nio.cs.ext.JIS_X_0212_Decoder;
import sun.nio.cs.ext.JIS_X_0212_Encoder;

public class EUC_JP
extends Charset
implements HistoricallyNamedCharset {
    public EUC_JP() {
        super("EUC-JP", ExtendedCharsets.aliasesFor("EUC-JP"));
    }

    @Override
    public String historicalName() {
        return "EUC_JP";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof JIS_X_0201 || charset instanceof JIS_X_0208 || charset instanceof JIS_X_0212 || charset instanceof EUC_JP;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        byte[] byArray = new byte[]{63};
        return new Encoder(this).replaceWith(byArray);
    }

    static class Encoder
    extends JIS_X_0208_Encoder {
        JIS_X_0201.Encoder encoderJ0201;
        JIS_X_0212_Encoder encoderJ0212;
        private static final short[] j0208Index1 = JIS_X_0208_Encoder.getIndex1();
        private static final String[] j0208Index2 = JIS_X_0208_Encoder.getIndex2();
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        protected Encoder(Charset charset) {
            super(charset, 3.0f, 3.0f);
            this.encoderJ0201 = new JIS_X_0201.Encoder(charset);
            this.encoderJ0212 = new JIS_X_0212_Encoder(charset);
        }

        @Override
        public boolean canEncode(char c) {
            byte[] byArray = new byte[3];
            return this.encodeSingle(c, byArray) != 0 || this.encodeDouble(c) != 0;
        }

        protected int encodeSingle(char c, byte[] byArray) {
            if (c == '\u0000') {
                byArray[0] = 0;
                return 1;
            }
            byte by = this.encoderJ0201.encode(c);
            if (by == 0) {
                return 0;
            }
            if (by > 0 && by < 128) {
                byArray[0] = by;
                return 1;
            }
            byArray[0] = -114;
            byArray[1] = by;
            return 2;
        }

        @Override
        protected int encodeDouble(char c) {
            int n = j0208Index1[(c & 0xFF00) >> 8] << 8;
            int n2 = j0208Index2[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
            if (n2 != 0) {
                return n2 + 32896;
            }
            n2 = this.encoderJ0212.encodeDouble(c);
            if (n2 == 0) {
                return n2;
            }
            return n2 + 0x8F8080;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 0;
            boolean bl = false;
            byte[] byArray2 = new byte[3];
            try {
                for (n = n <= n2 ? n : n2; n < n2; ++n) {
                    int n6;
                    byte[] byArray3 = byArray2;
                    char c = cArray[n];
                    if (Character.isSurrogate(c)) {
                        if (this.sgp.parse(c, cArray, n, n2) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    n5 = this.encodeSingle(c, byArray3);
                    if (n5 == 0) {
                        n6 = this.encodeDouble(c);
                        if (n6 != 0) {
                            if ((n6 & 0xFF0000) == 0) {
                                byArray3[0] = (byte)((n6 & 0xFF00) >> 8);
                                byArray3[1] = (byte)(n6 & 0xFF);
                                n5 = 2;
                            } else {
                                byArray3[0] = -113;
                                byArray3[1] = (byte)((n6 & 0xFF00) >> 8);
                                byArray3[2] = (byte)(n6 & 0xFF);
                                n5 = 3;
                            }
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (n4 - n3 < n5) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (n6 = 0; n6 < n5; ++n6) {
                        byArray[n3++] = byArray3[n6];
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = 0;
            boolean bl = false;
            byte[] byArray = new byte[3];
            int n2 = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n3;
                    byte[] byArray2 = byArray;
                    char c = charBuffer.get();
                    if (Character.isSurrogate(c)) {
                        if (this.sgp.parse(c, charBuffer) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    n = this.encodeSingle(c, byArray2);
                    if (n == 0) {
                        n3 = this.encodeDouble(c);
                        if (n3 != 0) {
                            if ((n3 & 0xFF0000) == 0) {
                                byArray2[0] = (byte)((n3 & 0xFF00) >> 8);
                                byArray2[1] = (byte)(n3 & 0xFF);
                                n = 2;
                            } else {
                                byArray2[0] = -113;
                                byArray2[1] = (byte)((n3 & 0xFF00) >> 8);
                                byArray2[2] = (byte)(n3 & 0xFF);
                                n = 3;
                            }
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (byteBuffer.remaining() < n) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (n3 = 0; n3 < n; ++n3) {
                        byteBuffer.put(byArray2[n3]);
                    }
                    ++n2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n2);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }

    static class Decoder
    extends JIS_X_0208_Decoder
    implements DelegatableDecoder {
        JIS_X_0201.Decoder decoderJ0201;
        JIS_X_0212_Decoder decoderJ0212;
        private static final short[] j0208Index1 = JIS_X_0208_Decoder.getIndex1();
        private static final String[] j0208Index2 = JIS_X_0208_Decoder.getIndex2();

        protected Decoder(Charset charset) {
            super(charset);
            this.decoderJ0201 = new JIS_X_0201.Decoder(charset);
            this.decoderJ0212 = new JIS_X_0212_Decoder(charset);
            this.start = 161;
            this.end = 254;
        }

        protected char decode0212(int n, int n2) {
            return this.decoderJ0212.decodeDouble(n, n2);
        }

        @Override
        protected char decodeDouble(int n, int n2) {
            if (n == 142) {
                return this.decoderJ0201.decode(n2 - 256);
            }
            if (n < 0 || n > Decoder.getIndex1().length || n2 < this.start || n2 > this.end) {
                return '\ufffd';
            }
            int n3 = (j0208Index1[n - 128] & 0xF) * (this.end - this.start + 1) + (n2 - this.start);
            return j0208Index2[j0208Index1[n - 128] >> 4].charAt(n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n <= n2);
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 65533;
            try {
                for (n = n <= n2 ? n : n2; n < n2; n += n7) {
                    n5 = byArray[n] & 0xFF;
                    n7 = 1;
                    if ((n5 & 0x80) == 0) {
                        n8 = (char)n5;
                    } else if ((n5 & 0xFF) == 143) {
                        if (n + 3 > n2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n5 = byArray[n + 1] & 0xFF;
                        n6 = byArray[n + 2] & 0xFF;
                        n7 += 2;
                        n8 = this.decode0212(n5 - 128, n6 - 128);
                    } else {
                        if (n + 2 > n2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n6 = byArray[n + 1] & 0xFF;
                        ++n7;
                        n8 = this.decodeDouble(n5, n6);
                    }
                    if (n8 == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n7);
                        return coderResult;
                    }
                    if (n3 + 1 > n4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n3++] = n8;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            char c = '\ufffd';
            try {
                while (byteBuffer.hasRemaining()) {
                    n2 = byteBuffer.get() & 0xFF;
                    n4 = 1;
                    if ((n2 & 0x80) == 0) {
                        c = (char)n2;
                    } else if ((n2 & 0xFF) == 143) {
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n2 = byteBuffer.get() & 0xFF;
                        n3 = byteBuffer.get() & 0xFF;
                        n4 += 2;
                        c = this.decode0212(n2 - 128, n3 - 128);
                    } else {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n3 = byteBuffer.get() & 0xFF;
                        ++n4;
                        c = this.decodeDouble(n2, n3);
                    }
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(n4);
                        return coderResult;
                    }
                    if (charBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put(c);
                    n += n4;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        @Override
        public void implReset() {
            super.implReset();
        }

        @Override
        public CoderResult implFlush(CharBuffer charBuffer) {
            return super.implFlush(charBuffer);
        }
    }
}

