/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.io.Converters;
import sun.nio.cs.Surrogate;

public abstract class DBCS_IBM_EBCDIC_Encoder
extends CharsetEncoder {
    protected static final char REPLACE_CHAR = '\ufffd';
    private byte b1;
    private byte b2;
    protected short[] index1;
    protected String index2;
    protected String index2a;
    protected int mask1;
    protected int mask2;
    private final int[] mask1All = new int[]{65535, 65534, 65532, 65528, 65520, 65504, 65472, 65408, 65280};
    private final int[] mask2All = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    protected int shift;
    private boolean islegal = true;
    private static final int SBCS = 0;
    private static final int DBCS = 1;
    private static final byte SO = 14;
    private static final byte SI = 15;
    private int currentState;
    private int convertType = 0;
    private static String swapValue;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    protected String byteArray = "";
    protected String leftPair = "";
    protected String rightPair = "";
    protected String bytePair = "";
    protected int[] surrogateArray = null;
    protected int numberOfSurrogates = 0;
    private int savedFirstOfPairBytes;
    private char savedFirstOfPair;
    protected boolean subMode = false;
    protected char[] index;
    private int charOff;
    private int byteOff;
    protected int badInputLength;
    public static final float MIX_AVERAGE_BYTES_PER_CHAR = 4.0f;
    public static final float MIX_MAX_BYTES_PER_CHAR = 5.0f;
    public static final float SBCS_AVERAGE_BYTES_PER_CHAR = 1.0f;
    public static final float SBCS_MAX_BYTES_PER_CHAR = 1.0f;
    public static final float DBCS_AVERAGE_BYTES_PER_CHAR = 2.0f;
    public static final float DBCS_MAX_BYTES_PER_CHAR = 2.0f;
    static final float[] AVERAGE_BYTES_PER_CHARS;
    static final float[] MAX_BYTES_PER_CHARS;
    protected static final int LINE_FEED_INDEX = 10;
    protected static final char SWAPPED_LINE_FEED_CHAR = '%';

    protected DBCS_IBM_EBCDIC_Encoder(Charset charset, float f, float f2) {
        super(charset, f, f2, new byte[]{111});
    }

    protected DBCS_IBM_EBCDIC_Encoder(Charset charset, byte[] byArray, float f, float f2) {
        super(charset, f, f2, new byte[]{111});
        if (null != byArray) {
            this.replaceWith(byArray);
        }
    }

    protected DBCS_IBM_EBCDIC_Encoder(Charset charset, int n) {
        this(charset, AVERAGE_BYTES_PER_CHARS[n > 2 ? 0 : n], MAX_BYTES_PER_CHARS[n > 2 ? 0 : n]);
        this.setType(n);
    }

    protected DBCS_IBM_EBCDIC_Encoder(Charset charset, byte[] byArray, int n) {
        this(charset, byArray, AVERAGE_BYTES_PER_CHARS[n > 2 ? 0 : n], MAX_BYTES_PER_CHARS[n > 2 ? 0 : n]);
        this.setType(n);
    }

    protected DBCS_IBM_EBCDIC_Encoder(Charset charset) {
        super(charset, 4.0f, 5.0f, new byte[]{111});
        this.index = null;
    }

    protected DBCS_IBM_EBCDIC_Encoder(Charset charset, byte[] byArray) {
        super(charset, 4.0f, 5.0f, new byte[]{111});
        this.index = null;
        if (null != byArray) {
            this.replaceWith(byArray);
        }
    }

    @Override
    public boolean isLegalReplacement(byte[] byArray) {
        if (2 == this.convertType) {
            if (2 != byArray.length) {
                return false;
            }
            if (-2 == byArray[0] && -2 == byArray[1]) {
                return true;
            }
            return super.isLegalReplacement(byArray);
        }
        if (this.islegal) {
            return true;
        }
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    protected String setIndex2(String string, int n) {
        if (DBCS_IBM_EBCDIC_Encoder.isSwapLF()) {
            char[] cArray = string.toCharArray();
            cArray[n] = 37;
            return new String(cArray);
        }
        return string;
    }

    @Override
    protected void implReset() {
        this.byteOff = 0;
        this.charOff = 0;
        this.savedFirstOfPair = '\u0000';
        this.savedFirstOfPairBytes = 0;
        if (this.convertType == 0) {
            this.currentState = 0;
        }
    }

    @Override
    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        if ('\u0000' != this.savedFirstOfPair) {
            int n = this.savedFirstOfPairBytes;
            if (this.currentState == 0) {
                if (byteBuffer.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)14);
                this.currentState = 1;
            }
            if (byteBuffer.remaining() < 2) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)((n & 0xFF00) >> 8));
            byteBuffer.put((byte)(n & 0xFF));
            this.savedFirstOfPair = '\u0000';
            this.savedFirstOfPairBytes = 0;
        }
        if (this.currentState == 1 && this.convertType != 2) {
            if (byteBuffer.remaining() < 1) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)15);
        }
        this.implReset();
        return CoderResult.UNDERFLOW;
    }

    @Override
    public boolean canEncode(char c) {
        char c2;
        if (1 == this.convertType) {
            return this.canEncodeType1(c);
        }
        if (2 == this.convertType) {
            return this.canEncodeType2(c);
        }
        int n = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
        if (n < 0) {
            n += 65536;
        }
        if ((c2 = n < 15000 ? this.index2.charAt(n) : this.index2a.charAt(n - 15000)) != '\u0000') {
            return true;
        }
        return c == '\u0000';
    }

    private boolean canEncodeType1(char c) {
        char c2;
        int n = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
        if (n < 0) {
            n += 65536;
        }
        if ((c2 = n < 15000 ? this.index2.charAt(n) : this.index2a.charAt(n - 15000)) != '\u0000' && c2 <= '\u00ff') {
            return true;
        }
        return c == '\u0000';
    }

    private boolean canEncodeType2(char c) {
        char c2;
        int n = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
        if (n < 0) {
            n += 65536;
        }
        return (c2 = n < 15000 ? this.index2.charAt(n) : this.index2a.charAt(n - 15000)) < '\u0000' || c2 > '\u00ff';
    }

    protected void setType(int n) {
        this.convertType = n;
        this.currentState = n == 2 ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        try {
            int n5;
            int n6;
            char c;
            if (this.convertType != 0) {
                if (this.convertType == 1) {
                    CoderResult coderResult = this.convertType1(cArray, n, n2, byArray, n3, n4);
                    return coderResult;
                }
                CoderResult coderResult = this.convertType2(cArray, n, n2, byArray, n3, n4);
                return coderResult;
            }
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = n;
            int n11 = n3;
            int n12 = n2;
            int n13 = n4;
            int n14 = this.replacement().length;
            byte by = this.replacement()[0];
            byte by2 = 0;
            if (n14 > 1) {
                by2 = this.replacement()[1];
            }
            boolean bl = this.subMode;
            char[] cArray2 = this.index;
            int n15 = this.currentState;
            int n16 = 0;
            int n17 = 1;
            int n18 = 14;
            int n19 = 15;
            if ('\u0000' != this.savedFirstOfPair) {
                c = cArray[n10];
                n6 = this.getBytesForPairedCharacters(this.savedFirstOfPair, c);
                n5 = 0 != n6 ? n6 : this.savedFirstOfPairBytes;
                if (n15 == n16) {
                    if (n11 >= n13) {
                        CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                        return coderResult;
                    }
                    byArray[n11++] = n18;
                    n15 = n17;
                }
                if (n11 + 1 >= n13) {
                    CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                    return coderResult;
                }
                byArray[n11++] = (byte)((n5 & 0xFF00) >> 8);
                byArray[n11++] = (byte)(n5 & 0xFF);
                if (0 != n6) {
                    ++n10;
                }
                this.savedFirstOfPair = '\u0000';
                this.savedFirstOfPairBytes = 0;
            }
            if (n15 == n16) {
                n8 = n13 - n11;
                n7 = n12 - n10;
                int n20 = n9 = n8 < n7 ? n10 + n8 : n12;
                while (n10 < n9 && (n5 = cArray2[c = cArray[n10]]) < 256) {
                    byArray[n11++] = (byte)n5;
                    ++n10;
                }
            }
            if (n10 < n12) {
                n8 = (n13 - n11) / 3;
                n7 = n12 - n10;
                int n21 = n9 = n8 < n7 ? n10 + n8 : n12;
                while (n10 < n9) {
                    c = cArray[n10];
                    n5 = cArray2[c];
                    if (n5 < 256) {
                        if (n15 != n16) {
                            byArray[n11++] = n19;
                            n15 = n16;
                        }
                        byArray[n11++] = (byte)n5;
                    } else {
                        if (n5 < 65534 && this.isFirstOfAPair(c)) break;
                        if (n5 < 65534) {
                            if (n15 == n16) {
                                byArray[n11++] = n18;
                                n15 = n17;
                            }
                            byArray[n11++] = (byte)(n5 >> 8);
                            byArray[n11++] = (byte)(n5 & 0xFF);
                        } else {
                            if (n5 != 65535) break;
                            if (!bl) {
                                CoderResult coderResult = this.throwUnknownCharacterException(n10, n11, n15, 1);
                                return coderResult;
                            }
                            if (n14 == 1) {
                                if (n15 != n16) {
                                    byArray[n11++] = n19;
                                    n15 = n16;
                                }
                                byArray[n11++] = by;
                            } else {
                                if (n15 == n16) {
                                    byArray[n11++] = n18;
                                    n15 = n17;
                                }
                                byArray[n11++] = by;
                                byArray[n11++] = by2;
                            }
                        }
                    }
                    ++n10;
                }
                while (n10 < n12) {
                    int n22;
                    c = cArray[n10];
                    n5 = cArray2[c];
                    if (n5 < 256) {
                        if (n15 != n16) {
                            if (n11 >= n13) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                return coderResult;
                            }
                            byArray[n11++] = n19;
                            n15 = n16;
                        }
                        if (n11 >= n13) {
                            CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                            return coderResult;
                        }
                        byArray[n11++] = (byte)n5;
                    } else if (this.isFirstOfAPair(c) && n10 + 1 >= n12) {
                        this.savedFirstOfPair = c;
                        this.savedFirstOfPairBytes = n5;
                    } else if (n5 < 65534) {
                        if (this.isFirstOfAPair(c) && 0 != (n22 = this.getBytesForPairedCharacters(c, (char)(n6 = cArray[n10 + 1])))) {
                            n5 = n22;
                            ++n10;
                        }
                        if (n15 == n16) {
                            if (n11 >= n13) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                return coderResult;
                            }
                            byArray[n11++] = n18;
                            n15 = n17;
                        }
                        if (n11 + 1 >= n13) {
                            CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                            return coderResult;
                        }
                        byArray[n11++] = (byte)(n5 >> 8);
                        byArray[n11++] = (byte)(n5 & 0xFF);
                    } else if (n5 == 65535) {
                        if (!bl) {
                            CoderResult coderResult = this.throwUnknownCharacterException(n10, n11, n15, 1);
                            return coderResult;
                        }
                        if (n14 == 1) {
                            if (n15 != n16) {
                                if (n11 >= n13) {
                                    CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                    return coderResult;
                                }
                                byArray[n11++] = n19;
                                n15 = n16;
                            }
                            if (n11 >= n13) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                return coderResult;
                            }
                            byArray[n11++] = by;
                        } else {
                            if (n15 == n16) {
                                if (n11 >= n13) {
                                    CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                    return coderResult;
                                }
                                byArray[n11++] = n18;
                                n15 = n17;
                            }
                            if (n11 + 1 >= n13) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                return coderResult;
                            }
                            byArray[n11++] = by;
                            byArray[n11++] = by2;
                        }
                    } else {
                        if (c >= '\udc00') {
                            CoderResult coderResult = this.throwMalformedInputException(n10, n11, n15, 1);
                            return coderResult;
                        }
                        n6 = c;
                        if (n10 + 1 >= n12) {
                            this.charOff = n10;
                            this.byteOff = n11;
                            this.currentState = n15;
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        c = cArray[n10 + 1];
                        if (c >= '\udc00' && c <= '\udfff') {
                            n22 = this.getBytesForSurrogatePair(n6, c);
                            if (0 != n22) {
                                if (n15 == n16) {
                                    if (n11 >= n13) {
                                        CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                        return coderResult;
                                    }
                                    byArray[n11++] = n18;
                                    n15 = n17;
                                }
                                if (n11 + 1 >= n13) {
                                    CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                    return coderResult;
                                }
                                byArray[n11++] = (byte)((n22 & 0xFF00) >> 8);
                                byArray[n11++] = (byte)(n22 & 0xFF);
                                ++n10;
                            } else {
                                if (!bl) {
                                    CoderResult coderResult = this.throwUnknownCharacterException(n10, n11, n15, 2);
                                    return coderResult;
                                }
                                if (n14 == 1) {
                                    if (n15 != n16) {
                                        if (n11 >= n13) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                            return coderResult;
                                        }
                                        byArray[n11++] = n19;
                                        n15 = n16;
                                    }
                                    if (n11 >= n13) {
                                        CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                        return coderResult;
                                    }
                                    byArray[n11++] = by;
                                } else {
                                    if (n15 == n16) {
                                        if (n11 >= n13) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                            return coderResult;
                                        }
                                        byArray[n11++] = n18;
                                        n15 = n17;
                                    }
                                    if (n11 + 1 >= n13) {
                                        CoderResult coderResult = this.throwConversionBufferFullException(n10, n11, n15);
                                        return coderResult;
                                    }
                                    byArray[n11++] = by;
                                    byArray[n11++] = by2;
                                }
                                ++n10;
                            }
                        } else {
                            CoderResult coderResult = this.throwMalformedInputException(n10, n11, n15, 1);
                            return coderResult;
                        }
                    }
                    ++n10;
                }
            }
            this.charOff = n10;
            this.byteOff = n11;
            this.currentState = n15;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(this.charOff - charBuffer.arrayOffset());
            byteBuffer.position(this.byteOff - byteBuffer.arrayOffset());
        }
    }

    protected static char[] expandMap(short[] sArray, String string, String string2, int n, int n2, int n3) {
        char c = '\u0000';
        char[] cArray = new char[65536];
        for (int i = 0; i < cArray.length; ++i) {
            if (i >= 55296 && i <= 57343) {
                cArray[i] = 65534;
                continue;
            }
            int n4 = sArray[(i & n2) >> n] + (i & n3);
            c = n4 >= 0 ? (n4 < 15000 ? string.charAt(n4) : string2.charAt(n4 - 15000)) : string2.charAt((n4 & 0xFFFF) - 15000);
            cArray[i] = c == '\u0000' && i != 0 ? 65535 : c;
        }
        return cArray;
    }

    private int getBytesForPairedCharacters(char c, char c2) {
        int n = this.leftPair.indexOf(c);
        while (n > -1) {
            if (this.rightPair.charAt(n) == c2) {
                return this.bytePair.charAt(n);
            }
            n = this.leftPair.indexOf(c, n + 1);
        }
        return 0;
    }

    private CoderResult throwConversionBufferFullException(int n, int n2, int n3) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        return CoderResult.OVERFLOW;
    }

    private CoderResult throwUnknownCharacterException(int n, int n2, int n3, int n4) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        this.badInputLength = n4;
        return CoderResult.unmappableForLength(n4);
    }

    private CoderResult throwMalformedInputException(int n, int n2, int n3, int n4) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        this.badInputLength = n4;
        return CoderResult.unmappableForLength(n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoderResult convertType1(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) {
        char c;
        char c2;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n3;
        int n10 = n2;
        int n11 = n4;
        byte by = this.replacement()[0];
        boolean bl = this.subMode;
        char[] cArray2 = this.index;
        int n12 = this.currentState;
        n7 = n11 - n9;
        n6 = n10 - n5;
        int n13 = n8 = n7 < n6 ? n5 + n7 : n10;
        for (n5 = n; n5 < n8 && (c2 = cArray2[c = cArray[n5]]) < '\u0100'; ++n5) {
            byArray[n9++] = (byte)c2;
        }
        if (n5 < n10) {
            n7 = n11 - n9;
            n6 = n10 - n5;
            int n14 = n8 = n7 < n6 ? n5 + n7 : n10;
            while (n5 < n8) {
                c = cArray[n5];
                c2 = cArray2[c];
                if (c2 < '\u0100') {
                    byArray[n9++] = (byte)c2;
                } else {
                    if (c2 == '\ufffe') break;
                    if (!bl) return this.throwUnknownCharacterException(n5, n9, 0, 1);
                    byArray[n9++] = by;
                }
                ++n5;
            }
            while (n5 < n10) {
                c = cArray[n5];
                c2 = cArray2[c];
                if (c2 < '\u0100') {
                    if (n9 >= n11) {
                        return this.throwConversionBufferFullException(n5, n9, 0);
                    }
                    byArray[n9++] = (byte)c2;
                } else if (c2 != '\ufffe') {
                    if (!bl) return this.throwUnknownCharacterException(n5, n9, 0, 1);
                    if (n9 >= n11) {
                        return this.throwConversionBufferFullException(n5, n9, 0);
                    }
                    byArray[n9++] = by;
                } else {
                    if (c >= '\udc00') return this.throwMalformedInputException(n5, n9, 0, 1);
                    if (n5 + 1 >= n10) {
                        this.charOff = n5;
                        this.byteOff = n9;
                        return CoderResult.UNDERFLOW;
                    }
                    c = cArray[n5 + 1];
                    if (c < '\udc00' || c > '\udfff') return this.throwMalformedInputException(n5, n9, 0, 1);
                    if (!bl) return this.throwUnknownCharacterException(n5, n9, 0, 2);
                    if (n9 >= n11) {
                        return this.throwConversionBufferFullException(n5, n9, 0);
                    }
                    byArray[n9++] = by;
                    ++n5;
                }
                ++n5;
            }
        }
        this.charOff = n5;
        this.byteOff = n9;
        return CoderResult.UNDERFLOW;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoderResult convertType2(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = n;
        int n12 = n3;
        int n13 = n2;
        int n14 = n4;
        int n15 = this.replacement().length;
        byte by = this.replacement()[0];
        byte by2 = this.replacement()[1];
        boolean bl = this.subMode;
        char[] cArray2 = this.index;
        if ('\u0000' != this.savedFirstOfPair) {
            n7 = cArray[n11];
            n6 = this.getBytesForPairedCharacters(this.savedFirstOfPair, (char)n7);
            n5 = 0 != n6 ? n6 : this.savedFirstOfPairBytes;
            if (n12 + 1 >= n14) {
                return this.throwConversionBufferFullException(n11, n12, this.currentState);
            }
            byArray[n12++] = (byte)((n5 & 0xFF00) >> 8);
            byArray[n12++] = (byte)(n5 & 0xFF);
            if (0 != n6) {
                ++n11;
            }
            this.savedFirstOfPair = '\u0000';
            this.savedFirstOfPairBytes = 0;
        }
        if (n11 < n13) {
            n9 = (n14 - n12) / 2;
            n8 = n13 - n11;
            int n16 = n10 = n9 < n8 ? n11 + n9 : n13;
            while (!(n11 >= n10 || (n5 = cArray2[n7 = cArray[n11]]) < 65534 && this.isFirstOfAPair((char)n7))) {
                if (n5 < 65534 && n5 >= 256) {
                    byArray[n12++] = (byte)(n5 >> 8);
                    byArray[n12++] = (byte)(n5 & 0xFF);
                } else if (n5 < 65534 && -1 != this.encodeCT2((char)n7)) {
                    n5 = this.encodeCT2((char)n7);
                    byArray[n12++] = (byte)(n5 >> 8);
                    byArray[n12++] = (byte)(n5 & 0xFF);
                } else {
                    if (n5 == 65534) break;
                    if (!bl) return this.throwUnknownCharacterException(n11, n12, 1, 1);
                    byArray[n12++] = by;
                    byArray[n12++] = by2;
                }
                ++n11;
            }
            while (n11 < n13) {
                int n17;
                n7 = cArray[n11];
                n5 = cArray2[n7];
                if (n5 < 65534 && this.isFirstOfAPair((char)n7) && n11 + 1 >= n13) {
                    this.savedFirstOfPair = (char)n7;
                    this.savedFirstOfPairBytes = n5;
                } else if (n5 < 65534 && n5 >= 256) {
                    if (this.isFirstOfAPair((char)n7) && n11 + 1 < n13 && 0 != (n17 = this.getBytesForPairedCharacters((char)n7, (char)(n6 = cArray[n11 + 1])))) {
                        n5 = n17;
                        ++n11;
                    }
                    if (n12 + 1 >= n14) {
                        return this.throwConversionBufferFullException(n11, n12, 1);
                    }
                    byArray[n12++] = (byte)(n5 >> 8);
                    byArray[n12++] = (byte)(n5 & 0xFF);
                } else if (n5 != 65534) {
                    if (!bl) return this.throwUnknownCharacterException(n11, n12, 1, 1);
                    if (n12 + 1 >= n14) {
                        return this.throwConversionBufferFullException(n11, n12, 1);
                    }
                    byArray[n12++] = by;
                    byArray[n12++] = by2;
                } else {
                    if (n7 >= 56320) return this.throwMalformedInputException(n11, n12, 1, 1);
                    n6 = n7;
                    if (n11 + 1 >= n13) {
                        this.charOff = n11;
                        this.byteOff = n12;
                        return CoderResult.UNDERFLOW;
                    }
                    n7 = cArray[n11 + 1];
                    if (n7 < 56320 || n7 > 57343) return this.throwMalformedInputException(n11, n12, 1, 1);
                    n17 = this.getBytesForSurrogatePair(n6, n7);
                    if (0 != n17) {
                        if (this.currentState == 0) {
                            if (n12 >= n14) {
                                return this.throwConversionBufferFullException(n11, n12, this.currentState);
                            }
                            byArray[n12++] = 14;
                            this.currentState = 1;
                        }
                        if (n12 + 1 >= n14) {
                            return this.throwConversionBufferFullException(n11, n12, this.currentState);
                        }
                        byArray[n12++] = (byte)((n17 & 0xFF00) >> 8);
                        byArray[n12++] = (byte)(n17 & 0xFF);
                        ++n11;
                    } else {
                        if (!bl) return this.throwUnknownCharacterException(n11, n12, 1, 2);
                        if (n12 + 1 >= n14) {
                            return this.throwConversionBufferFullException(n11, n12, 1);
                        }
                        byArray[n12++] = by;
                        byArray[n12++] = by2;
                        ++n11;
                    }
                }
                ++n11;
            }
        }
        this.charOff = n11;
        this.byteOff = n12;
        return CoderResult.UNDERFLOW;
    }

    private int getBytesForSurrogatePair(int n, int n2) {
        if (0 == this.numberOfSurrogates) {
            return 0;
        }
        int n3 = this.numberOfSurrogates;
        int n4 = -1;
        int n5 = ((n & 0x3FF) << 10 | n2 & 0x3FF) + 65536;
        int n6 = n3 / 2;
        int n7 = 0;
        if (this.surrogateArray[0] == n5) {
            n4 = 0;
            n6 = 0;
        } else if (this.surrogateArray[n3 - 1] == n5) {
            n4 = n3 - 1;
            n6 = 0;
        }
        while (n6 >= 1) {
            if (this.surrogateArray[n6] == n5) {
                n4 = n6;
                break;
            }
            if (this.surrogateArray[n6] < n5) {
                if ((n3 + n6) / 2 == n6) {
                    n6 = 0;
                    continue;
                }
                n6 = (n3 + n6) / 2;
                continue;
            }
            if (this.surrogateArray[n6] <= n5) continue;
            n3 = n6;
            n6 = n3 / 2;
        }
        if (n4 >= 0) {
            n7 = this.byteArray.charAt(n4);
        }
        return n7;
    }

    protected boolean isFirstOfAPair(char c) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (this.convertType == 1) {
            return this.encodeBufferLoop_CT1(charBuffer, byteBuffer);
        }
        if (this.convertType == 2) {
            return this.encodeBufferLoop_CT2(charBuffer, byteBuffer);
        }
        int n = charBuffer.position();
        boolean bl = false;
        try {
            int n2;
            byte by;
            int n3;
            int n4;
            char c;
            int n5;
            if ('\u0000' != this.savedFirstOfPair) {
                n5 = 0;
                c = charBuffer.get();
                n4 = this.getBytesForPairedCharacters(this.savedFirstOfPair, c);
                n5 = 0 != n4 ? n4 : this.savedFirstOfPairBytes;
                n3 = (byte)((n5 & 0xFF00) >> 8);
                by = (byte)(n5 & 0xFF);
                if (this.currentState == 1 && n3 == 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                    byteBuffer.put((byte)15);
                } else if (this.currentState == 0 && n3 != 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                    byteBuffer.put((byte)14);
                }
                n2 = this.currentState == 1 ? 2 : 1;
                if (byteBuffer.remaining() < n2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    byteBuffer.put(by);
                } else {
                    if (this.currentState == 1) {
                        byteBuffer.put((byte)n3);
                    }
                    byteBuffer.put(by);
                }
                if (0 != n4) {
                    ++n;
                }
                this.savedFirstOfPair = '\u0000';
                this.savedFirstOfPairBytes = 0;
            }
            while (charBuffer.hasRemaining()) {
                boolean bl2;
                block53: {
                    int n6;
                    int n7;
                    int n8;
                    block55: {
                        block54: {
                            c = '\u0000';
                            charBuffer.position(n);
                            n4 = charBuffer.get();
                            n3 = this.leftPair.indexOf(n4);
                            by = 0;
                            bl2 = false;
                            if (charBuffer.hasRemaining() && n3 > -1 && null != this.surrogateArray) {
                                while (n3 > -1) {
                                    if (this.rightPair.charAt(n3) == charBuffer.get(n + 1)) {
                                        c = this.bytePair.charAt(n3);
                                        ++n;
                                        charBuffer.get();
                                        by = 1;
                                        n3 = -1;
                                        continue;
                                    }
                                    n3 = this.leftPair.indexOf(n4, n3 + 1);
                                }
                            }
                            if (!Surrogate.is(n4)) break block53;
                            if (this.sgp.parse((char)n4, charBuffer) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (null == this.surrogateArray || by != 0) break block54;
                            n8 = this.numberOfSurrogates;
                            n7 = -1;
                            boolean bl3 = false;
                            n6 = n8 / 2;
                            if (this.surrogateArray[0] == this.sgp.character()) {
                                n7 = 0;
                                n6 = 0;
                                break block55;
                            } else if (this.surrogateArray[n8 - 1] == this.sgp.character()) {
                                n7 = n8 - 1;
                                n6 = 0;
                            }
                            break block55;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    while (n6 >= 1) {
                        if (this.surrogateArray[n6] == this.sgp.character()) {
                            n7 = n6;
                            break;
                        }
                        if (this.surrogateArray[n6] < this.sgp.character()) {
                            if ((n8 + n6) / 2 == n6) {
                                n6 = 0;
                                continue;
                            }
                            n6 = (n8 + n6) / 2;
                            continue;
                        }
                        if (this.surrogateArray[n6] <= this.sgp.character()) continue;
                        n8 = n6;
                        n6 = n8 / 2;
                    }
                    if (n7 >= 0) {
                        c = this.byteArray.charAt(n7);
                        ++n;
                        bl2 = true;
                    } else {
                        this.sgp.unmappableResult();
                        break;
                    }
                }
                if (n4 >= 65534) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                n5 = this.index1[(n4 & this.mask1) >> this.shift] + (n4 & this.mask2);
                if (by == 0 && !bl2) {
                    c = n5 >= 0 ? (n5 < 15000 ? this.index2.charAt(n5) : this.index2a.charAt(n5 - 15000)) : this.index2a.charAt((n5 & 0xFFFF) - 15000);
                }
                if (!charBuffer.hasRemaining() && n3 > -1) {
                    this.savedFirstOfPair = (char)n4;
                    this.savedFirstOfPairBytes = c;
                    ++n;
                    continue;
                }
                this.b1 = (byte)((c & 0xFF00) >> 8);
                this.b2 = (byte)(c & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && n4 != 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 && this.b1 == 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                    byteBuffer.put((byte)15);
                } else if (this.currentState == 0 && this.b1 != 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                    byteBuffer.put((byte)14);
                }
                n2 = this.currentState == 1 ? 2 : 1;
                if (byteBuffer.remaining() < n2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    byteBuffer.put(this.b2);
                } else {
                    if (this.currentState == 1 || by != 0 || bl2) {
                        byteBuffer.put(this.b1);
                    }
                    byteBuffer.put(this.b2);
                }
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop_CT1(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                int n3 = this.leftPair.indexOf(c);
                boolean bl3 = false;
                boolean bl4 = false;
                if (charBuffer.hasRemaining() && n3 > -1 && null != this.surrogateArray) {
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n4 = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char c2 = n4 >= 0 ? (n4 < 15000 ? this.index2.charAt(n4) : this.index2a.charAt(n4 - 15000)) : this.index2a.charAt((n4 & 0xFFFF) - 15000);
                this.b1 = (byte)((c2 & 0xFF00) >> 8);
                this.b2 = (byte)(c2 & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 0 && this.b1 != 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState != 0) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n2 = 1;
                if (byteBuffer.remaining() < n2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    if (this.b2 > 255) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                } else {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                byteBuffer.put(this.b2);
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop_CT2(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        boolean bl = false;
        try {
            int n2;
            byte by;
            int n3;
            int n4;
            char c;
            int n5;
            if ('\u0000' != this.savedFirstOfPair) {
                n5 = 0;
                c = charBuffer.get();
                n4 = this.getBytesForPairedCharacters(this.savedFirstOfPair, c);
                n5 = 0 != n4 ? n4 : this.savedFirstOfPairBytes;
                n3 = (byte)((n5 & 0xFF00) >> 8);
                by = (byte)(n5 & 0xFF);
                if (this.currentState == 1 && n3 == 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                    byteBuffer.put((byte)15);
                } else if (this.currentState == 0 && n3 != 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                    byteBuffer.put((byte)14);
                }
                n2 = this.currentState == 1 ? 2 : 1;
                if (byteBuffer.remaining() < n2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    byteBuffer.put(by);
                } else {
                    if (this.currentState == 1) {
                        byteBuffer.put((byte)n3);
                    }
                    byteBuffer.put(by);
                }
                if (0 != n4) {
                    ++n;
                }
                this.savedFirstOfPair = '\u0000';
                this.savedFirstOfPairBytes = 0;
            }
            while (charBuffer.hasRemaining()) {
                int n6;
                boolean bl2;
                block54: {
                    int n7;
                    int n8;
                    block56: {
                        block55: {
                            charBuffer.position(n);
                            n4 = charBuffer.get();
                            n3 = this.leftPair.indexOf(n4);
                            by = 0;
                            bl2 = false;
                            c = '\u0000';
                            if (charBuffer.hasRemaining() && n3 > -1 && null != this.surrogateArray) {
                                while (n3 > -1) {
                                    if (this.rightPair.charAt(n3) == charBuffer.get(n + 1)) {
                                        c = this.bytePair.charAt(n3);
                                        ++n;
                                        charBuffer.get();
                                        by = 1;
                                        n3 = -1;
                                        continue;
                                    }
                                    n3 = this.leftPair.indexOf(n4, n3 + 1);
                                }
                            }
                            if (!Surrogate.is(n4)) break block54;
                            if (this.sgp.parse((char)n4, charBuffer) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (null == this.surrogateArray || by != 0) break block55;
                            n6 = this.numberOfSurrogates;
                            n8 = -1;
                            boolean bl3 = false;
                            n7 = n6 / 2;
                            if (this.surrogateArray[0] == this.sgp.character()) {
                                n8 = 0;
                                n7 = 0;
                                break block56;
                            } else if (this.surrogateArray[n6 - 1] == this.sgp.character()) {
                                n8 = n6 - 1;
                                n7 = 0;
                            }
                            break block56;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    while (n7 >= 1) {
                        if (this.surrogateArray[n7] == this.sgp.character()) {
                            n8 = n7;
                            break;
                        }
                        if (this.surrogateArray[n7] < this.sgp.character()) {
                            if ((n6 + n7) / 2 == n7) {
                                n7 = 0;
                                continue;
                            }
                            n7 = (n6 + n7) / 2;
                            continue;
                        }
                        if (this.surrogateArray[n7] <= this.sgp.character()) continue;
                        n6 = n7;
                        n7 = n6 / 2;
                    }
                    if (n8 >= 0) {
                        c = this.byteArray.charAt(n8);
                        ++n;
                        bl2 = true;
                    } else {
                        this.sgp.unmappableResult();
                        break;
                    }
                }
                if ('\u0000' == c) {
                    if (n4 >= 65534) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    n5 = this.index1[(n4 & this.mask1) >> this.shift] + (n4 & this.mask2);
                    c = n5 >= 0 ? (n5 < 15000 ? this.index2.charAt(n5) : this.index2a.charAt(n5 - 15000)) : this.index2a.charAt((n5 & 0xFFFF) - 15000);
                }
                if (!charBuffer.hasRemaining() && n3 > -1) {
                    this.savedFirstOfPair = n4;
                    this.savedFirstOfPairBytes = c;
                    ++n;
                    continue;
                }
                this.b1 = (byte)((c & 0xFF00) >> 8);
                this.b2 = (byte)(c & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && n4 != 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 && this.b1 == 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    n6 = this.encodeCT2((char)n4);
                    if (-1 == n6) {
                        this.currentState = 0;
                    } else {
                        this.b1 = (byte)((n6 & 0xFF00) >> 8);
                        this.b2 = (byte)(n6 & 0xFF);
                    }
                } else if (this.currentState == 0 && this.b1 != 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                }
                n2 = this.currentState == 1 ? 2 : 1;
                if (byteBuffer.remaining() < n2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 || by != 0 || bl2) {
                    byteBuffer.put(this.b1);
                }
                byteBuffer.put(this.b2);
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeArrayLoop_CT2(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        boolean bl = false;
        try {
            for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                char c;
                boolean bl2;
                boolean bl3;
                char c2;
                block35: {
                    int n5;
                    int n6;
                    int n7;
                    block37: {
                        block36: {
                            c2 = cArray[n];
                            int n8 = this.leftPair.indexOf(c2);
                            bl3 = false;
                            bl2 = false;
                            if (n + 1 < n2 && n8 > -1 && null != this.surrogateArray) {
                                while (n8 > -1) {
                                    if (this.rightPair.charAt(n8) == cArray[n + 1]) {
                                        c = this.bytePair.charAt(n8);
                                        ++n;
                                        bl3 = true;
                                        n8 = -1;
                                        continue;
                                    }
                                    n8 = this.leftPair.indexOf(c2, n8 + 1);
                                }
                            }
                            if (!Surrogate.is(c2)) break block35;
                            if (this.sgp.parse(c2, cArray, n, n2) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (null == this.surrogateArray || bl3) break block36;
                            n7 = this.numberOfSurrogates;
                            n6 = -1;
                            boolean bl4 = false;
                            n5 = n7 / 2;
                            if (this.surrogateArray[0] == this.sgp.character()) {
                                n6 = 0;
                                n5 = 0;
                                break block37;
                            } else if (this.surrogateArray[n7 - 1] == this.sgp.character()) {
                                n6 = n7 - 1;
                                n5 = 0;
                            }
                            break block37;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    while (n5 >= 1) {
                        if (this.surrogateArray[n5] == this.sgp.character()) {
                            n6 = n5;
                            break;
                        }
                        if (this.surrogateArray[n5] < this.sgp.character()) {
                            if ((n7 + n5) / 2 == n5) {
                                n5 = 0;
                                continue;
                            }
                            n5 = (n7 + n5) / 2;
                            continue;
                        }
                        if (this.surrogateArray[n5] <= this.sgp.character()) continue;
                        n7 = n5;
                        n5 = n7 / 2;
                    }
                    if (n6 >= 0) {
                        c = this.byteArray.charAt(n6);
                        ++n;
                        bl2 = true;
                    } else {
                        this.sgp.unmappableResult();
                        break;
                    }
                }
                if (c2 >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n9 = this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2);
                c = n9 >= 0 ? (n9 < 15000 ? this.index2.charAt(n9) : this.index2a.charAt(n9 - 15000)) : this.index2a.charAt((n9 & 0xFFFF) - 15000);
                this.b1 = (byte)((c & 0xFF00) >> 8);
                this.b2 = (byte)(c & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c2 != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 && this.b1 == 0) {
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                } else if (this.currentState == 0 && this.b1 != 0) {
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                }
                int n10 = this.currentState == 1 ? 2 : 1;
                if (n4 - n3 < n10) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 || bl3 || bl2) {
                    byArray[n3++] = this.b1;
                }
                byArray[n3++] = this.b2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop_CT1(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        boolean bl = false;
        int n5 = 0;
        try {
            for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                char c = cArray[n];
                int n6 = this.leftPair.indexOf(c);
                boolean bl2 = false;
                boolean bl3 = false;
                if (n + 1 < n2 && n6 > -1 && null != this.surrogateArray) {
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, cArray, n, n2) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n7 = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char c2 = n7 >= 0 ? (n7 < 15000 ? this.index2.charAt(n7) : this.index2a.charAt(n7 - 15000)) : this.index2a.charAt((n7 & 0xFFFF) - 15000);
                this.b1 = (byte)((c2 & 0xFF00) >> 8);
                this.b2 = (byte)(c2 & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 0 && this.b1 != 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState != 0) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n5 = 1;
                if (n4 - n3 < n5) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    if (this.b2 > 255) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                } else {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                byArray[n3++] = this.b2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
        }
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }

    protected int encodeCT2(char c) {
        return -1;
    }

    protected String handleIBMSwapLF(String string) {
        return string;
    }

    public static final boolean isSwapLF() {
        return Converters.isSwapLF();
    }

    static {
        AVERAGE_BYTES_PER_CHARS = new float[]{4.0f, 1.0f, 2.0f};
        MAX_BYTES_PER_CHARS = new float[]{5.0f, 1.0f, 2.0f};
    }
}

