/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter;

import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.IInstallOperation;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.LumkitInstallOperation;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.nativeAdapterData.EnvironmentNativeData;
import com.ibm.cic.common.nativeAdapterData.LumkitNativeData;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class NativeInstallAdapter
extends ICommonNativeInstallAdapter
implements IInstallAdaptor {
    private static final Logger log = Logger.getLogger(NativeInstallAdapter.class);

    public String getId() {
        return "native";
    }

    public IStatus preInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(10, 40, pair, context, monitor);
    }

    public IStatus install(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(21, 51, pair, context, monitor);
    }

    public IStatus postInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(30, 60, pair, context, monitor);
    }

    protected Logger getLog() {
        return log;
    }

    protected void dispatcher(int phase, IInstallableUnit unit, InstallContext context, ICommonNativeData data, IProgressMonitor monitor) throws CoreException {
        boolean processed = this.processCommonOperation(phase, unit, context, data, monitor);
        if (!processed) {
            if (data instanceof LumkitNativeData) {
                this.handleLumKitOperation(phase, unit, context, (LumkitNativeData)data, monitor);
            } else if (data instanceof EnvironmentNativeData) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void handleLumKitOperation(int phase, IInstallableUnit unit, InstallContext context, LumkitNativeData data, IProgressMonitor monitor) throws CoreException {
        LumkitInstallOperation op = new LumkitInstallOperation(phase, unit, context, data);
        context.performOperation((IInstallOperation)op, monitor);
    }

    protected void customOperation(int phase, IInstallableUnit unit, InstallContext context, ICommonNativeData data, PerformCommonNativeData performData, IProgressMonitor monitor) throws CoreException {
        this.processCommonPerformOperation(phase, unit, context, data, performData, monitor);
    }
}

