/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallOperation;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.DesktopMenu;
import com.ibm.cic.agent.core.nativeInstallAdapter.desktopMenu.IOsSpecificPolicy;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.Messages;
import com.ibm.cic.common.commonNativeAdapterData.CommonDesktopEntyNativeData;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.logging.Logger;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;

public class DesktopMenuHandler {
    private final IOsSpecificPolicy m_osPolicy;
    private final DesktopMenu m_menu;
    private final boolean m_installForAllUsers;
    private final ICommonNativeInstallOperation m_operation;
    private final String m_commonName;
    private final String m_commonShortName;
    private Writer m_writer;
    public static final Logger log = Logger.getLogger(DesktopMenuHandler.class, (Plugin)AgentActivator.getDefault());
    public static final String PREFIX = "IBMIM_";

    public DesktopMenuHandler(ICommonNativeInstallOperation a_op, IOsSpecificPolicy a_policy, CommonDesktopEntyNativeData data) {
        this.m_operation = a_op;
        this.m_osPolicy = a_policy;
        this.m_installForAllUsers = data.installForAllUsers();
        this.m_menu = new DesktopMenu(this, data);
        String profileName = this.performVariableSubstitutions("${profileId}");
        String performName = this.performVariableSubstitutions(data.getName());
        this.m_commonName = PREFIX + profileName + '_' + performName + '_';
        this.m_commonShortName = "IBM_IM_" + profileName + '_' + profileName + '_' + performName + '_';
    }

    public DesktopMenuHandler(ICommonNativeInstallOperation a_op, IOsSpecificPolicy a_policy, CommonDesktopEntyNativeData data, Writer writer) {
        this(a_op, a_policy, data);
        this.m_writer = writer;
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public boolean installForAllUsers() {
        return this.m_installForAllUsers;
    }

    public String getCommonName() {
        return this.m_commonName;
    }

    public String getCommonShortName() {
        return this.m_commonShortName;
    }

    IOsSpecificPolicy getPolicy() {
        return this.m_osPolicy;
    }

    public void removeAllItems() {
        this.m_menu.remove();
    }

    public boolean writeToDisk() throws CoreException {
        return this.m_menu.writeToDisk();
    }

    public String performVariableSubstitutions(String s) {
        try {
            return this.m_operation.performVariableSubstitutions(s);
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException variableSubstitutionException) {
            return s;
        }
    }

    public boolean isAgentProfile() {
        return this.m_operation.getProfile().isAgentProfile();
    }

    String addPrefixtoNameForNonAdminAndGroup(String name) {
        if (this.isAgentProfile()) {
            if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                return String.valueOf(Messages.folderPrefixForGroup) + ' ' + name;
            }
            if (CicCommonSettings.getAccessRightsMode().isNonAdminMode()) {
                return String.valueOf(Messages.folderPrefixForNonAdmin) + ' ' + name;
            }
        }
        return name;
    }

    String addGksudoForAdminOnUbuntu(String name) {
        if (CicCommonSettings.isUbuntu() && this.isAgentProfile() && CicCommonSettings.getAccessRightsMode().isAdminMode()) {
            return "gksudo " + name;
        }
        return name;
    }
}

