/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.resync.internal;

import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.ws.sync.core.internal.SyncUtil;

public class ResyncUtil {
    public static boolean hasImportedOfferings(IProfile profile) {
        IOffering[] offerings;
        if (profile == null) {
            return false;
        }
        IOffering[] iOfferingArray = offerings = profile.getInstalledOfferings();
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            String imported = profile.getOfferingUserData("user.cic.imported", offering.getIdentity().getId());
            if (imported != null && imported.equals("WAS")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasImportedOfferings(String profileId) {
        return ResyncUtil.hasImportedOfferings((IProfile)SyncUtil.findExistingProfile(profileId));
    }

    public static boolean hasImportedEnabledOfferings(IProfile profile) {
        IOffering[] offerings = profile.getInstalledOfferings();
        boolean importEnabled = false;
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            LinkedProperties property = offering.getProperties();
            importEnabled = Boolean.valueOf(property.getProperty("import.enabled"));
            if (importEnabled) {
                return true;
            }
            ++n2;
        }
        return importEnabled;
    }
}

