/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.parser;

import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.ISourceConverter;
import com.ibm.cic.common.xml.core.IXMLProcessor;
import com.ibm.cic.common.xml.core.ProblemVisitor;
import com.ibm.cic.common.xml.core.internal.parser.SAXContentHandler;
import com.ibm.cic.common.xml.core.model.IProblem;
import com.ibm.cic.common.xml.core.model.IProcessingInstruction;
import com.ibm.cic.common.xml.core.model.IXMLModel;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import com.ibm.cic.common.xml.core.model.schema.ISchemaRule;
import com.ibm.cic.common.xml.core.model.schema.ISchemaRuleVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLProcessor
implements IXMLProcessor {
    private static final String NONSTRICT = "nonstrict";
    private static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private static final String STRING_INTERN_FEATURE = "http://xml.org/sax/features/string-interning";
    private static final String FEATURE_NS_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private XMLReader fReader;
    private SAXContentHandler fHandler;
    private ISourceConverter fConverter;
    private final ArrayList fRules = new ArrayList();
    private ISchema fSchema;
    private ServiceTracker parserTracker = null;
    private final BundleContext fContext;

    public XMLProcessor(BundleContext context, SAXParserFactory factory) {
        this.fContext = context;
        try {
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            this.fReader = parser.getXMLReader();
            this.fReader.setFeature(STRING_INTERN_FEATURE, true);
            this.fReader.setFeature(VALIDATION_FEATURE, false);
            this.fReader.setFeature(FEATURE_NS_PREFIXES, true);
            this.fHandler = new SAXContentHandler();
            this.fReader.setContentHandler(this.fHandler);
            this.fReader.setErrorHandler(this.fHandler);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IXMLModel getRoot() {
        return this.fHandler.getDocRoot();
    }

    @Override
    public void process(InputSource inputSource) throws IOException {
        try {
            this.fReader.parse(inputSource);
        }
        catch (SAXException sAXException) {}
        if (this.fSchema != null) {
            IProcessingInstruction[] procs;
            IXMLModel root = this.fHandler.getDocRoot();
            IProcessingInstruction[] iProcessingInstructionArray = procs = root.getProcessingInstructions();
            int n = procs.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessingInstruction proc = iProcessingInstructionArray[n2];
                if (proc.getTarget().equals(NONSTRICT)) {
                    return;
                }
                ++n2;
            }
            ISchemaRuleVisitor visitor = CicXMLCore.getDefault().getSchemaRuleVisitor(this.fSchema, this.fConverter);
            Iterator iter = this.fRules.iterator();
            while (iter.hasNext()) {
                visitor.addSchemaRule((ISchemaRule)iter.next());
            }
            root.visit(visitor);
        }
    }

    @Override
    public IXMLTextModelItem getErrorPart() {
        return this.fHandler.getLastErrorPart();
    }

    @Override
    public void setSourceConverter(ISourceConverter converter) {
        this.fHandler.setSourceConverter(converter);
        this.fConverter = converter;
    }

    @Override
    public String[] getKnownTags() {
        return this.fHandler.getTags();
    }

    @Override
    public void setSchema(ISchema schema) {
        this.fSchema = schema;
    }

    @Override
    public void addRule(ISchemaRule rule) {
        this.fRules.add(rule);
    }

    @Override
    public IProblem[] getProblems() {
        IXMLModel root = this.fHandler.getDocRoot();
        if (root != null) {
            ProblemVisitor visitor = new ProblemVisitor();
            root.visit(visitor);
            List problems = visitor.getCollectedProblems();
            IProblem[] ret = new IProblem[problems.size()];
            return problems.toArray(ret);
        }
        return new IProblem[0];
    }

    @Override
    public void dispose() {
        this.fRules.clear();
        this.fConverter = null;
        this.fHandler = null;
        this.fReader = null;
        this.fSchema = null;
    }

    public SAXParserFactory getFactory() {
        SAXParserFactory theFactory;
        if (this.parserTracker == null) {
            this.parserTracker = new ServiceTracker(this.fContext, SAXParserFactory.class.getName(), null);
            this.parserTracker.open();
        }
        if ((theFactory = (SAXParserFactory)this.parserTracker.getService()) != null) {
            theFactory.setNamespaceAware(false);
            theFactory.setValidating(false);
        }
        return theFactory;
    }
}

