/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.parser;

import com.ibm.cic.common.xml.core.ISourceConverter;
import com.ibm.cic.common.xml.core.TextProblem;
import com.ibm.cic.common.xml.core.internal.model.ProcInstruction;
import com.ibm.cic.common.xml.core.internal.model.TextModelItem;
import com.ibm.cic.common.xml.core.internal.model.XMLElement;
import com.ibm.cic.common.xml.core.internal.model.XMLModel;
import com.ibm.cic.common.xml.core.model.IXMLModel;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.NamespaceSupport;

public class SAXContentHandler
implements ContentHandler,
ErrorHandler {
    private static final byte STATE_DOC = 0;
    private static final byte STATE_ELEMENT = 1;
    private static final byte STATE_CDATA = 2;
    private byte fState;
    private static final String COM_END = "-->";
    private static final String COM_START = "<!--";
    private static final String LT = "<";
    private static final String CLOSE_TAG_START = "</";
    private ISourceConverter fConverter;
    private Locator fLocator;
    private final XMLModel fRoot = new XMLModel();
    private XMLElement fActiveBranch;
    private IXMLTextModelItem fErrorPart;
    private int fLastTagIdx;
    private final ArrayList fTags = new ArrayList();
    private final NamespaceSupport fNSSupport = new NamespaceSupport();

    public void setSourceConverter(ISourceConverter converter) {
        this.fConverter = converter;
    }

    public String[] getTags() {
        String[] tags = new String[this.fTags.size()];
        return this.fTags.toArray(tags);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.fActiveBranch != null) {
            if (length > 0) {
                char[] chars = new char[length];
                System.arraycopy(ch, start, chars, 0, length);
                String value = new String(chars);
                if (value.length() > 0) {
                    String existing;
                    if (this.fState == 2 && (existing = this.fActiveBranch.getElementCDATA()) != null) {
                        StringBuffer cdata = new StringBuffer(existing);
                        cdata.append(value);
                        value = cdata.toString();
                        cdata = null;
                    }
                    this.fActiveBranch.setElementCDATA(value);
                }
            }
            this.fActiveBranch.getTextSpan().setLength(this.fActiveBranch.getTextSpan().getLength() + length);
            this.fState = (byte)2;
        }
    }

    @Override
    public void endDocument() {
        this.fRoot.setEndColumn(this.fLocator.getColumnNumber());
        this.fRoot.setEndLineNumber(this.fLocator.getLineNumber() - 1);
        if (this.fConverter != null) {
            this.fRoot.getTextSpan().setLength(this.fConverter.getOffset(this.fLocator.getLineNumber() - 1, this.fLocator.getColumnNumber()) - this.fRoot.getTextSpan().getOffset());
        }
    }

    @Override
    public void endElement(String uri, String localname, String qname) {
        if (this.fActiveBranch != null) {
            int line = this.fLocator.getLineNumber() - 1;
            int col = this.fLocator.getColumnNumber();
            XMLElement _part = this.fActiveBranch;
            _part.setEndColumn(col);
            _part.setEndLineNumber(line);
            _part.setValid();
            int offset = 0;
            if (_part.isSingleLine()) {
                offset = _part.getOpenTagEnd();
                _part.getTextSpan().setLength(offset - _part.getTextSpan().getOffset());
            } else {
                offset = this.fLastTagIdx;
                if (this.fConverter != null) {
                    int lineOff = this.fConverter.getOffsetOfLine(line);
                    int lineLen = this.fConverter.getLengthOfLine(line);
                    String content = this.fConverter.getTextRange(offset, lineOff + lineLen - offset);
                    int idx = -1;
                    if (content != null && (idx = content.indexOf(CLOSE_TAG_START + qname)) >= 0) {
                        offset += idx + qname.length() + 3;
                    }
                }
            }
            _part.getTextSpan().setLength(offset - _part.getTextSpan().getOffset());
            this.fLastTagIdx = offset;
            this.fActiveBranch.updateLengthForChild(_part);
            this.fActiveBranch = (XMLElement)_part.getParent();
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.fNSSupport.popContext();
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
        ProcInstruction inst = new ProcInstruction();
        inst.setData(data);
        inst.setTarget(target);
        this.fRoot.addProcessingInstruction(inst);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    @Override
    public void skippedEntity(String arg0) {
        System.out.println(arg0);
    }

    @Override
    public void startDocument() {
        this.fState = 0;
        this.fErrorPart = null;
        this.fLastTagIdx = 0;
        this.fRoot.setStartColumn(this.fLocator.getColumnNumber());
        this.fRoot.setStartLineNumber(this.fLocator.getLineNumber());
        this.fRoot.setWellFormed(true);
        if (this.fConverter != null) {
            this.fRoot.getTextSpan().setOffset(this.fConverter.getOffset(this.fLocator.getLineNumber(), this.fLocator.getColumnNumber()));
        }
        this.fRoot.clearProcessingIntructions();
        this.fActiveBranch = this.fRoot;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        this.fState = 1;
        int offset = 0;
        int startTagEnd = 0;
        int line = this.fLocator.getLineNumber() - 1;
        int col = this.fLocator.getColumnNumber();
        boolean single = false;
        if (this.fConverter != null) {
            offset = this.fLastTagIdx;
            int lineOffset = this.fConverter.getOffsetOfLine(line) - 1;
            int lineLen = this.fConverter.getLengthOfLine(line);
            String lineContent = this.fConverter.getTextRange(this.fLastTagIdx, lineOffset + lineLen - this.fLastTagIdx);
            if (qName != null && lineContent != null) {
                int idx = 0;
                idx = this.checkForComments(lineContent);
                idx = lineContent.indexOf(LT + qName, idx);
                if (idx > 0) {
                    int idxNext = idx + 1;
                    while (offset + idx < this.fLastTagIdx) {
                        idxNext = lineContent.indexOf(LT + qName, idxNext + 1);
                        if (idxNext <= 0) break;
                        idx = idxNext;
                    }
                    offset += idx;
                }
            }
            startTagEnd = offset;
            int tminus = 32;
            while (startTagEnd < this.fConverter.getLength()) {
                char t = this.fConverter.charAt(startTagEnd);
                if (t == '>') {
                    if (tminus == 47) {
                        single = true;
                    }
                    ++startTagEnd;
                    break;
                }
                ++startTagEnd;
                tminus = t;
            }
        }
        this.fLastTagIdx = startTagEnd;
        if (this.fActiveBranch != null) {
            TextModelItem _new = null;
            if (this.fConverter != null) {
                _new = this.fActiveBranch.findElement(offset, qName);
            }
            if (_new == null) {
                _new = new XMLElement(qName);
                this.fActiveBranch.addChild((IXMLTextModelItem)((Object)_new));
            }
            _new.getTextSpan().setOffset(offset);
            _new.getTextSpan().setLength(startTagEnd - offset);
            ((XMLElement)_new).setOpenTagEnd(startTagEnd);
            ((XMLElement)_new).setSingleLine(single);
            _new.setStartColumn(col);
            _new.setStartLineNumber(line);
            ((XMLElement)_new).setValid();
            ((XMLElement)_new).clearAttributes();
            String[] split = new String[3];
            split = this.fNSSupport.processName(qName, split, false);
            if (split != null && split[0] != null) {
                String prefix = this.fNSSupport.getPrefix(split[0]);
                ((XMLElement)_new).setName(prefix, split[1], split[2]);
            }
            int i = 0;
            while (i < attrs.getLength()) {
                ((XMLElement)_new).setAttributeValue(attrs.getQName(i), attrs.getValue(i));
                ++i;
            }
            if (this.fConverter != null) {
                this.fActiveBranch.updateLengthForChild((IXMLTextModelItem)((Object)_new));
            }
            this.fActiveBranch = _new;
        }
    }

    private int checkForComments(String content) {
        int comStart = content.indexOf(COM_START);
        if (comStart > -1) {
            int more = comStart + 1;
            while (more > -1) {
                comStart = more + 1;
                more = content.indexOf(COM_START, comStart);
            }
            int endCom = content.indexOf(COM_END, comStart);
            if (endCom > -1) {
                return endCom + 3;
            }
        }
        return 0;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.fNSSupport.declarePrefix(prefix, uri);
        this.fNSSupport.pushContext();
    }

    public IXMLModel getDocRoot() {
        return this.fRoot;
    }

    public IXMLTextModelItem getLastErrorPart() {
        return this.fErrorPart;
    }

    @Override
    public void error(SAXParseException ex) {
        this.fRoot.setWellFormed(false);
        if (this.fActiveBranch != null) {
            this.fActiveBranch.setEndColumn(ex.getColumnNumber());
            this.fActiveBranch.setEndLineNumber(ex.getLineNumber());
            if (this.fConverter != null) {
                XMLElement element;
                IXMLTextModelItem[] children;
                int offset = this.fActiveBranch.getOpenTagEnd();
                int line = ex.getLineNumber() - 1;
                int col = ex.getColumnNumber();
                if (col != -1) {
                    int exOff = this.fConverter.getOffset(line, col);
                    if (exOff > offset) {
                        offset = exOff;
                    }
                } else {
                    int lineOffset = this.fConverter.getOffsetOfLine(ex.getLineNumber() - 1);
                    if (lineOffset > offset) {
                        offset = lineOffset;
                    }
                }
                if (this.fActiveBranch.getOpenTagEnd() < offset) {
                    this.fActiveBranch.getTextSpan().setLength(offset - this.fActiveBranch.getTextSpan().getOffset());
                }
                IXMLTextModelItem[] iXMLTextModelItemArray = children = this.fActiveBranch.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IXMLTextModelItem element2 = iXMLTextModelItemArray[n2];
                    if (element2.isValid() && element2.getTextSpan().getOffset() > offset) {
                        offset = element2.getTextSpan().getOffset() + element2.getTextSpan().getLength();
                    }
                    ++n2;
                }
                String dat = this.fConverter.getTextRange(this.fLastTagIdx, this.fConverter.getLength() - this.fLastTagIdx - 1);
                if (dat != null && dat.trim().length() > 0 && dat.indexOf(60) > -1 && (element = this.parseBrokenTag(this.fLastTagIdx + 1, dat)) != null) {
                    element.setValid();
                    this.fActiveBranch = element;
                }
            }
        }
        this.reportSAXError(ex, this.fActiveBranch, 2);
    }

    private boolean isBreak(char c) {
        switch (c) {
            case '\n': 
            case '\r': 
            case ' ': 
            case '!': 
            case '/': 
            case '=': 
            case '>': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    private XMLElement parseBrokenTag(int startOffset, String tag) {
        int sidx = tag.indexOf(60);
        if (sidx > -1) {
            tag = tag.substring(sidx + 1);
        }
        startOffset += sidx + 1;
        StringBuffer name = new StringBuffer();
        int pos = 0;
        while (pos < tag.length()) {
            char c = tag.charAt(pos);
            if (this.isBreak(c)) {
                ++pos;
                break;
            }
            name.append(c);
            ++pos;
        }
        if (name.toString().startsWith("?")) {
            return null;
        }
        XMLElement elem = new XMLElement(name.toString());
        boolean val = false;
        StringBuffer attr = new StringBuffer();
        StringBuffer value = new StringBuffer();
        while (pos < tag.length()) {
            char c = tag.charAt(pos);
            if (c == '<' || c == '>') break;
            if (!val) {
                if (c != '=') {
                    attr.append(c);
                } else {
                    value.setLength(0);
                    val = true;
                }
            } else if (c != '\'' && c != '\"') {
                value.append(c);
            } else if (this.isBreak(c)) {
                elem.setAttributeValue(attr.toString(), value.toString());
                attr.setLength(0);
                val = false;
            }
            ++pos;
        }
        if (attr.length() > 0) {
            elem.setAttributeValue(attr.toString(), value.toString());
        }
        elem.getTextSpan().setOffset(startOffset - 1);
        elem.getTextSpan().setLength(pos);
        this.fActiveBranch.addChild(elem);
        this.fActiveBranch = elem;
        return elem;
    }

    @Override
    public void fatalError(SAXParseException ex) {
        this.error(ex);
    }

    @Override
    public void warning(SAXParseException ex) {
        this.reportSAXError(ex, null, 1);
    }

    public void reportSAXError(SAXParseException exception, IXMLTextModelItem part, int severity) {
        if (part != null) {
            part.addProblem(new TextProblem(severity, exception.getLocalizedMessage(), part.getTextSpan().getOffset(), part.getTextSpan().getLength(), part.getStartLineNumber()));
            this.fErrorPart = part;
            return;
        }
    }
}

