/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema;

import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.internal.model.schema.IValueRefinement;
import com.ibm.cic.common.xml.core.internal.model.schema.SchemaFactory;
import com.ibm.cic.common.xml.core.internal.model.schema.Type;
import com.ibm.cic.common.xml.core.internal.model.schema.XMLUtility;
import com.ibm.cic.common.xml.core.model.schema.IReferencable;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import com.ibm.cic.common.xml.core.model.schema.IValueRestriction;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleType
extends Type
implements IValueRestriction {
    private final ArrayList fValues = new ArrayList();
    private final ArrayList fRefinements = new ArrayList();
    private IReferencable fBaseType;
    private String fBaseName;
    private String fErrorMsg;

    public SimpleType(ISchema schema) {
        this.fSchema = schema;
    }

    public SimpleType(Element domNode, ISchema schema) {
        super(domNode, schema);
        this.readContent(domNode);
    }

    @Override
    public byte getType() {
        return 2;
    }

    private void readContent(Element domNode) {
        NodeList children = domNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1 && "restriction".equals(n.getNodeName())) {
                this.fBaseName = XMLUtility.getAttribute(n, "base");
                if (this.fBaseName != null) {
                    this.fBaseType = this.fSchema.getResolver().lookupType(this.fBaseName);
                }
                Element restriction = (Element)n;
                NodeList refinements = restriction.getChildNodes();
                int e = 0;
                while (e < refinements.getLength()) {
                    if (refinements.item(e).getNodeType() == 1) {
                        Element refine = (Element)refinements.item(e);
                        if ("enumeration".equals(refine.getNodeName())) {
                            String val = refine.getAttribute("value");
                            if (val != null) {
                                this.addValue(val);
                            }
                        } else {
                            IValueRefinement refinement = SchemaFactory.createRefinement(refine);
                            if (refinement != null) {
                                this.fRefinements.add(refinement);
                            }
                        }
                    }
                    ++e;
                }
            }
            ++i;
        }
    }

    protected void addValue(String value) {
        if (this.getBaseType() != null && this.getBaseType() instanceof IValueRestriction) {
            IValueRestriction restiction = (IValueRestriction)((Object)this.fBaseType);
            if (restiction.isValueValid(null, value)) {
                this.fValues.add(value);
            } else {
                CicXMLCore.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.bind((String)Messages.intErr_simpleType, (Object)this.fRefName)));
            }
        } else {
            this.fValues.add(value);
        }
    }

    @Override
    public String[] getValues() {
        String[] ret = new String[this.fValues.size()];
        return this.fValues.toArray(ret);
    }

    @Override
    public boolean isFixedValueSet() {
        IValueRestriction override;
        if (this.fSchema != null && (override = this.fSchema.getCustomTypeRule(this.fName)) != null) {
            return override.isFixedValueSet();
        }
        return this.fValues.size() > 0;
    }

    public IReferencable getBaseType() {
        if (this.fBaseType == null && this.fSchema != null) {
            this.fBaseType = this.fSchema.getResolver().lookupType(this.fBaseName);
        }
        return this.fBaseType;
    }

    @Override
    public boolean isValueValid(String attribute, String value) {
        IValueRestriction custom;
        IValueRestriction restrict;
        this.fErrorMsg = null;
        if (attribute == null) {
            attribute = "";
        }
        if (this.getBaseType() != null && this.getBaseType() instanceof IValueRestriction && !(restrict = (IValueRestriction)((Object)this.fBaseType)).isValueValid(null, value)) {
            this.fErrorMsg = restrict.getFailureMessage(attribute, value);
            return false;
        }
        for (IValueRefinement ref : this.fRefinements) {
            if (ref.isValueValid(value)) continue;
            this.fErrorMsg = ref.getFailureMessage(attribute, value);
            return false;
        }
        if (this.fSchema != null && (custom = this.fSchema.getCustomTypeRule(this.fName)) != null) {
            if (!custom.isValueValid(attribute, value)) {
                this.fErrorMsg = custom.getFailureMessage(attribute, value);
                return false;
            }
            if (!custom.isFixedValueSet()) {
                return true;
            }
        }
        if (this.isFixedValueSet()) {
            return this.fValues.contains(value);
        }
        return true;
    }

    @Override
    public String getFailureMessage(String attribute, String value) {
        return this.fErrorMsg;
    }

    @Override
    public void init(ISchema applicableSchema) {
        this.fSchema = applicableSchema;
    }

    @Override
    public String[] getValueProposals(String existing) {
        IValueRestriction override;
        if (this.fSchema != null && (override = this.fSchema.getCustomTypeRule(this.fName)) != null) {
            return override.getValueProposals(existing);
        }
        return this.getValues();
    }
}

