/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema;

import com.ibm.cic.common.xml.core.internal.model.schema.Multiplicity;
import com.ibm.cic.common.xml.core.internal.model.schema.SchemaFactory;
import com.ibm.cic.common.xml.core.internal.model.schema.Type;
import com.ibm.cic.common.xml.core.internal.model.schema.XMLUtility;
import com.ibm.cic.common.xml.core.model.schema.IContainerContainer;
import com.ibm.cic.common.xml.core.model.schema.IElementContainer;
import com.ibm.cic.common.xml.core.model.schema.IElementDefinition;
import com.ibm.cic.common.xml.core.model.schema.IReferencable;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ContainerType
extends Type
implements IElementContainer,
IContainerContainer {
    protected ArrayList fElements = new ArrayList();
    protected ArrayList fContainers = new ArrayList();
    private ArrayList fAggrElements;
    protected String fDoc = "";
    protected boolean fReference;
    protected String fRefType;
    protected IReferencable fType;
    protected Multiplicity fMulti = new Multiplicity();

    public ContainerType(Element domNode, ISchema schema) {
        super(domNode, schema);
        this.readContents();
    }

    public IElementDefinition[] getOwnedElements() {
        IElementDefinition[] ret = new IElementDefinition[this.fElements.size()];
        return this.fElements.toArray(ret);
    }

    protected void readContents() {
        this.fRefType = this.fNode.getAttribute("ref");
        String min = this.fNode.getAttribute("minOccurs");
        String max = this.fNode.getAttribute("maxOccurs");
        this.fMulti.setMax(max);
        this.fMulti.setMin(min);
        if (!XMLUtility.isEmpty(this.fRefType)) {
            this.fReference = true;
            return;
        }
        NodeList nodes = this.fNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 1) {
                IReferencable ref = SchemaFactory.createType((Element)n, this.fSchema);
                if (ref != null) {
                    switch (ref.getType()) {
                        case 6: {
                            ((IElementDefinition)ref).setParent(this);
                            this.fElements.add(ref);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 9: {
                            this.fContainers.add(ref);
                            break;
                        }
                    }
                } else if ("annotation".equals(n.getNodeName())) {
                    Element el = (Element)n;
                    this.fDoc = XMLUtility.getDocumentation(el);
                }
            }
            ++i;
        }
    }

    @Override
    public void addContainer(IElementContainer container) {
        this.fContainers.add(container);
    }

    @Override
    public Iterator containerIterator() {
        if (this.fReference) {
            if (this.getTypeElement() != null && this.fType instanceof IContainerContainer) {
                return ((IContainerContainer)((Object)this.fType)).containerIterator();
            }
            return new ArrayList(0).iterator();
        }
        return this.fContainers.iterator();
    }

    @Override
    public IElementContainer[] containerList() {
        if (this.fReference) {
            if (this.getTypeElement() != null && this.fType instanceof IContainerContainer) {
                return ((IContainerContainer)((Object)this.fType)).containerList();
            }
            return new IElementContainer[0];
        }
        IElementContainer[] ret = new IElementContainer[this.fContainers.size()];
        return this.fContainers.toArray(ret);
    }

    @Override
    public void addElement(IElementDefinition element) {
        if (!this.fElements.contains(element)) {
            this.fElements.add(element);
        }
    }

    @Override
    public Multiplicity getMultiplicity() {
        return this.fMulti;
    }

    @Override
    public synchronized IElementDefinition[] getElements() {
        if (this.fReference) {
            if (this.getTypeElement() != null && this.fType instanceof IElementContainer) {
                return ((IElementContainer)((Object)this.fType)).getElements();
            }
            return new IElementDefinition[0];
        }
        if (this.fAggrElements == null) {
            this.fAggrElements = new ArrayList();
            for (IElementContainer container : this.fContainers) {
                IElementDefinition[] elems;
                IElementDefinition[] iElementDefinitionArray = elems = container.getElements();
                int n = elems.length;
                int n2 = 0;
                while (n2 < n) {
                    IElementDefinition elem = iElementDefinitionArray[n2];
                    this.fAggrElements.add(elem);
                    ++n2;
                }
            }
            for (IElementDefinition el : this.fElements) {
                el.getElementType();
            }
            this.fAggrElements.addAll(this.fElements);
        }
        IElementDefinition[] ret = new IElementDefinition[this.fAggrElements.size()];
        return this.fAggrElements.toArray(ret);
    }

    @Override
    public IElementDefinition getElementByName(String name) {
        IElementDefinition[] elems;
        if (this.fReference) {
            if (this.getTypeElement() != null && this.fType instanceof IElementContainer) {
                return ((IElementContainer)((Object)this.fType)).getElementByName(name);
            }
            return null;
        }
        IElementDefinition[] iElementDefinitionArray = elems = this.getElements();
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IElementDefinition elem = iElementDefinitionArray[n2];
            if (elem.getName().equals(name)) {
                return elem;
            }
            ++n2;
        }
        return null;
    }

    protected IReferencable getTypeElement() {
        if (this.fReference && this.fType == null) {
            this.fType = this.fSchema.getResolver().lookupType(this.fRefType);
            return this.fType;
        }
        return this;
    }

    @Override
    public int getChildElementCount() {
        if (this.fReference) {
            if (this.getTypeElement() != null && this.fType instanceof IElementContainer) {
                return ((IElementContainer)((Object)this.fType)).getChildElementCount();
            }
            return 0;
        }
        int total = 0;
        for (IElementContainer c : this.fContainers) {
            total += c.getChildElementCount();
        }
        return total + this.fElements.size();
    }

    @Override
    public IElementDefinition[] getLocalElements() {
        IElementDefinition[] ret = new IElementDefinition[this.fElements.size()];
        return this.fElements.toArray(ret);
    }

    @Override
    public boolean isReference() {
        return this.fReference;
    }

    @Override
    public String getTypeName() {
        return this.fRefType;
    }
}

