/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema;

import com.ibm.cic.common.xml.core.internal.model.schema.SimpleType;
import com.ibm.cic.common.xml.core.internal.model.schema.Type;
import com.ibm.cic.common.xml.core.model.schema.IAttributeDefinition;
import com.ibm.cic.common.xml.core.model.schema.IReferencable;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class AttributeDefinition
extends Type
implements IAttributeDefinition {
    private String fDefault;
    private String fType;
    private IReferencable fResolvedType;
    private boolean fRequired;
    private boolean fProhibited;
    private final ArrayList fEnum = new ArrayList();

    public AttributeDefinition(Element node, ISchema schema) {
        super(node, schema);
    }

    public String[] getEnumValues() {
        String[] ret = new String[this.fEnum.size()];
        return this.fEnum.toArray(ret);
    }

    void addEnumValue(String value) {
        if (!this.fEnum.contains(value)) {
            this.fEnum.add(value);
        }
    }

    void setName(String name) {
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    void setAttributeType(String type) {
        this.fType = type;
        this.fResolvedType = this.fSchema.getResolver().lookupType(type);
    }

    @Override
    public String getAttributeTypeName() {
        return this.fType;
    }

    public boolean isEnum() {
        return false;
    }

    void setRequired(boolean required) {
        this.fRequired = required;
    }

    @Override
    public boolean isRequired() {
        return this.fRequired;
    }

    void setDefault(String value) {
        this.fDefault = value;
    }

    @Override
    public String getDefault() {
        return this.fDefault;
    }

    @Override
    public boolean isProhibited() {
        return this.fProhibited;
    }

    void setProhibited(boolean value) {
        this.fProhibited = value;
    }

    @Override
    public byte getType() {
        return 7;
    }

    public void setType(SimpleType type) {
        this.fResolvedType = type;
    }

    @Override
    public IReferencable getAttributeType() {
        if (this.fResolvedType == null) {
            this.fResolvedType = this.fSchema.getResolver().lookupType(this.fType);
        }
        return this.fResolvedType;
    }
}

