/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model;

import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.xml.core.ISourceConverter;
import com.ibm.cic.common.xml.core.internal.Messages;
import com.ibm.cic.common.xml.core.internal.model.ElementComparator;
import com.ibm.cic.common.xml.core.internal.model.TextModelItem;
import com.ibm.cic.common.xml.core.internal.model.TextSpan;
import com.ibm.cic.common.xml.core.internal.model.XMLComment;
import com.ibm.cic.common.xml.core.model.IProblem;
import com.ibm.cic.common.xml.core.model.IXMLElementVisitor;
import com.ibm.cic.common.xml.core.model.IXMLModel;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class XMLElement
extends TextModelItem
implements IXMLTextModelItem {
    private static final String COMMENT_END = "-->";
    private static final String COMMENT_START = "<!--";
    private static final String XMLNS = "xmlns:";
    private CopyOnWriteArrayList<IXMLTextModelItem> fChildren;
    private HashMap fAttributes;
    private final List<String> fHiddenAttributes;
    private String fName;
    private boolean fValid;
    private String fCDATA;
    private int fTagEndOffset;
    private final ArrayList fProblems;
    private boolean fSingleLine;
    private IXMLTextModelItem fParent;
    private final HashMap fData;
    private HashMap fNSMap;
    private String fNSPrefix;
    private String fLocalName;
    private String fElementNSURI;

    public XMLElement(String name) {
        this.fName = name;
        this.fValid = false;
        this.fChildren = new CopyOnWriteArrayList();
        this.fAttributes = new HashMap();
        this.fProblems = new ArrayList();
        this.fData = new HashMap(1);
        this.fNSMap = new HashMap(1);
        this.fHiddenAttributes = new ArrayList<String>();
    }

    public void setOpenTagEnd(int offset) {
        this.fTagEndOffset = offset;
    }

    public int getOpenTagEnd() {
        return this.fTagEndOffset;
    }

    @Override
    public void addChild(IXMLTextModelItem part) {
        this.fChildren.add(part);
        part.setParent(this);
        if (this.getTextSpan().lastIndex() < part.getTextSpan().lastIndex()) {
            this.getTextSpan().setLength(part.getTextSpan().lastIndex() - this.getTextSpan().getOffset());
        }
    }

    @Override
    public void setParent(IXMLTextModelItem parent) {
        this.fParent = parent;
    }

    @Override
    public IXMLTextModelItem getChildAt(int offset) {
        if (this.getTextSpan().contains(offset)) {
            for (IXMLTextModelItem _part : this.fChildren) {
                if (!_part.getTextSpan().contains(offset)) continue;
                return this.descend(_part, offset);
            }
            return this;
        }
        return null;
    }

    public void updateLengthForChild(IXMLTextModelItem part) {
        if (this.getTextSpan().lastIndex() < part.getTextSpan().lastIndex()) {
            this.getTextSpan().setLength(part.getTextSpan().lastIndex() - this.getTextSpan().getOffset());
        }
        if (this.fParent instanceof XMLElement) {
            ((XMLElement)this.fParent).updateLengthForChild(part);
        }
    }

    private final IXMLTextModelItem descend(IXMLTextModelItem _part, int offset) {
        IXMLTextModelItem _child = _part.getChildAt(offset);
        while (_child != null && !_child.equals(_part)) {
            _part = _child;
            _child = _part.getChildAt(offset);
        }
        return _part;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public IXMLTextModelItem getParent() {
        return this.fParent;
    }

    public IXMLTextModelItem getParentByName(String qname) {
        if (qname.equals(this.fName)) {
            return this;
        }
        IXMLTextModelItem _parent = this.fParent;
        while (_parent != null) {
            if (qname.equals(_parent.getName())) {
                return _parent;
            }
            _parent = _parent.getParent();
        }
        return null;
    }

    @Override
    public IXMLTextModelItem[] getChildren() {
        IXMLTextModelItem[] _ret = new IXMLTextModelItem[this.fChildren.size()];
        return this.fChildren.toArray(_ret);
    }

    @Override
    public void setChildren(IXMLTextModelItem[] children) {
        if (children == null) {
            throw new NullPointerException();
        }
        this.fChildren = new CopyOnWriteArrayList<IXMLTextModelItem>(children);
    }

    @Override
    public int getChildCount() {
        return this.fChildren.size();
    }

    @Override
    public void clearChildren() {
        Iterator<IXMLTextModelItem> _iter = this.fChildren.iterator();
        while (_iter.hasNext()) {
            IXMLTextModelItem _p = _iter.next();
            _iter.remove();
            _p.clearChildren();
        }
    }

    public IXMLTextModelItem getChildAtStartOffset(int offset) {
        if (offset == this.getTextSpan().getOffset()) {
            return this;
        }
        for (IXMLTextModelItem _part : this.fChildren) {
            if (_part.getTextSpan().getOffset() != offset) continue;
            return _part;
        }
        return null;
    }

    @Override
    public void setValid() {
        this.fValid = true;
    }

    @Override
    public boolean isValid() {
        return this.fValid;
    }

    public XMLElement findElement(int offset, String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        for (IXMLTextModelItem part : this.fChildren) {
            if (!(part instanceof XMLElement) || offset != part.getTextSpan().getOffset() || !name.equals(part.getName())) continue;
            return (XMLElement)part;
        }
        return null;
    }

    @Override
    public void removeChild(IXMLTextModelItem child) {
        this.fChildren.remove(child);
    }

    @Override
    public void invalidate() {
        this.fValid = false;
        Iterator<IXMLTextModelItem> iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            iter.next().invalidate();
        }
    }

    @Override
    public boolean hasError() {
        for (IProblem p : this.fProblems) {
            if (p.getSeverity() != 2) continue;
            return true;
        }
        Iterator<IXMLTextModelItem> iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            if (!iter.next().hasError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasWarning() {
        for (IProblem p : this.fProblems) {
            if (p.getSeverity() != 1) continue;
            return true;
        }
        Iterator<IXMLTextModelItem> iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            if (!iter.next().hasWarning()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof XMLElement) {
            IXMLTextModelItem[] otherChildren;
            String[] attributeNames;
            XMLElement otherElement = (XMLElement)other;
            if (!this.fName.equals(otherElement.getName())) {
                return false;
            }
            String[] stringArray = attributeNames = otherElement.getAttributeNames();
            int n = attributeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeName = stringArray[n2];
                String otherValue = otherElement.getAttributeValue(attributeName);
                String myValue = this.getAttributeValue(attributeName);
                if (myValue == null || !myValue.equals(otherValue)) {
                    return false;
                }
                ++n2;
            }
            if (otherElement.getTextSpan().getOffset() != 0 || this.getTextSpan().getOffset() != 0) {
                return otherElement.getTextSpan().getOffset() == this.getTextSpan().getOffset();
            }
            IXMLTextModelItem[] myChildren = this.getChildren();
            if (myChildren.length != (otherChildren = otherElement.getChildren()).length) {
                return false;
            }
            int i = 0;
            while (i < myChildren.length) {
                if (!myChildren[i].equals(otherChildren[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public void clearAttributes() {
        this.fAttributes.clear();
    }

    @Override
    public String[] getAttributeNames() {
        ArrayList<String> listOfPublicAttributes = new ArrayList<String>();
        for (String attribute : this.fAttributes.keySet()) {
            if (this.fHiddenAttributes.contains(attribute)) continue;
            listOfPublicAttributes.add(attribute);
        }
        String[] ret = new String[listOfPublicAttributes.size()];
        return listOfPublicAttributes.toArray(ret);
    }

    public String[] getDataNames() {
        ArrayList<String> listOfDataNames = new ArrayList<String>();
        for (String attribute : this.fData.keySet()) {
            listOfDataNames.add(attribute);
        }
        String[] ret = new String[listOfDataNames.size()];
        return listOfDataNames.toArray(ret);
    }

    @Override
    public String getAttributeValue(String name) {
        return (String)this.fAttributes.get(name);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.fAttributes.containsKey(name);
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public void visit(IXMLElementVisitor visitor) {
        if (visitor.visit(this)) {
            for (IXMLTextModelItem item : this.fChildren) {
                item.visit(visitor);
            }
        }
    }

    @Override
    public void addProblem(IProblem problem) {
        this.fProblems.add(problem);
    }

    @Override
    public void clearProblems() {
        this.fProblems.clear();
    }

    @Override
    public List getProblemList() {
        return (List)this.fProblems.clone();
    }

    @Override
    public boolean hasNamedChild(String childName) {
        for (IXMLTextModelItem next : this.fChildren) {
            if (!childName.equals(next.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeProblem(IProblem problem) {
        this.fProblems.remove(problem);
    }

    public boolean isSingleLine() {
        return this.fSingleLine;
    }

    public void setSingleLine(boolean value) {
        this.fSingleLine = value;
    }

    @Override
    public void setElementCDATA(String data) {
        this.fCDATA = data;
    }

    @Override
    public String getElementCDATA() {
        return this.fCDATA;
    }

    @Override
    public void setAttributeValue(String name, String value) {
        if (name.startsWith(XMLNS)) {
            String ns = name.substring(XMLNS.length());
            this.fNSMap.put(ns, value);
        } else {
            this.fAttributes.put(name, value);
        }
    }

    @Override
    public void removeAttribute(String name) {
        this.fAttributes.remove(name);
    }

    @Override
    public void resolveComments(ISourceConverter converter) throws CoreException {
        IXMLTextModelItem[] children;
        IXMLTextModelItem comment;
        String text;
        if (this.isSingleLine()) {
            return;
        }
        int curIdx = this.getOpenTagEnd();
        if (this.getChildCount() == 0) {
            String txt = converter.getTextRange(curIdx, this.getTextSpan().getLength() - (curIdx - this.getTextSpan().getOffset()));
            if (txt == null) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.common.xml.core", Messages.XMLElement_badDelims, null));
            }
            IXMLTextModelItem com = this.getComment(txt, curIdx);
            if (com != null) {
                this.addChild(com);
            }
            return;
        }
        TreeSet<IXMLTextModelItem> sortedChildren = new TreeSet<IXMLTextModelItem>(new ElementComparator());
        sortedChildren.addAll(this.fChildren);
        Iterator it = sortedChildren.iterator();
        XMLElement e = null;
        while (it.hasNext()) {
            e = (XMLElement)it.next();
            text = converter.getTextRange(curIdx, e.getTextSpan().getOffset() - curIdx);
            if (text != null && (comment = this.getComment(text, 0)) != null) {
                int idx = this.fChildren.indexOf(e);
                this.fChildren.add(idx, comment);
            }
            curIdx = e.getTextSpan().getOffset() + e.getTextSpan().getLength();
        }
        if (e != null && (text = converter.getTextRange(curIdx, this.getTextSpan().getOffset() + this.getTextSpan().getLength() - curIdx)) != null && (comment = this.getComment(text, curIdx)) != null) {
            this.fChildren.add(comment);
        }
        IXMLTextModelItem[] iXMLTextModelItemArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IXMLTextModelItem element = iXMLTextModelItemArray[n2];
            element.resolveComments(converter);
            ++n2;
        }
    }

    private IXMLTextModelItem getComment(String text, int sIdx) {
        int end;
        int idx = text.indexOf(COMMENT_START);
        if (idx >= 0 && (end = text.lastIndexOf(COMMENT_END)) >= 0) {
            String body = text.substring(idx + 4, end);
            XMLComment ret = new XMLComment();
            ret.setBody(body);
            TextSpan span = new TextSpan();
            span.setOffset(sIdx + idx);
            span.setLength(end + 3);
            ret.setTextSpan(span);
            return ret;
        }
        return null;
    }

    @Override
    public IXMLTextModelItem[] getChildrenByName(String name) {
        Iterator<IXMLTextModelItem> iter = this.fChildren.iterator();
        ArrayList<IXMLTextModelItem> matches = new ArrayList<IXMLTextModelItem>(0);
        while (iter.hasNext()) {
            IXMLTextModelItem next = iter.next();
            if (!name.equals(next.getName())) continue;
            matches.add(next);
        }
        IXMLTextModelItem[] ret = new IXMLTextModelItem[matches.size()];
        ret = matches.toArray(ret);
        matches.clear();
        return ret;
    }

    public String toString() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public void setData(String key, Object data) {
        this.fData.put(key, data);
    }

    @Override
    public Object getData(String key) {
        return this.fData.get(key);
    }

    @Override
    public IXMLTextModelItem makeCopy() {
        XMLElement copy = new XMLElement(this.fName);
        copy.fAttributes = (HashMap)this.fAttributes.clone();
        copy.fNSMap = (HashMap)this.fNSMap.clone();
        copy.fCDATA = this.fCDATA;
        copy.fSpan = this.fSpan;
        copy.fEndColumn = this.fEndColumn;
        copy.fEndLine = this.fEndLine;
        copy.fStartColumn = this.fStartColumn;
        copy.fStartLine = this.fStartLine;
        for (IXMLTextModelItem child : this.fChildren) {
            IXMLTextModelItem childClone = child.makeCopy();
            copy.addChild(childClone);
        }
        return copy;
    }

    @Override
    public IXMLModel getModel() {
        if (this instanceof IXMLModel) {
            return (IXMLModel)((Object)this);
        }
        IXMLTextModelItem parent = this.fParent;
        while (parent != null) {
            if (parent instanceof IXMLModel) {
                return (IXMLModel)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    public void defineNamespace(String ns, String nsURI) {
        this.fNSMap.put(ns, nsURI);
    }

    @Override
    public String[] getDefinedNamespaces() {
        return this.fNSMap.keySet().toArray(new String[this.fNSMap.keySet().size()]);
    }

    @Override
    public String getDeclaredNamespaceURI(String ns) {
        return (String)this.fNSMap.get(ns);
    }

    public void setNSPrefix(String ns) {
        this.fNSPrefix = ns;
    }

    @Override
    public String getNSPrefix() {
        return this.fNSPrefix;
    }

    @Override
    public String getLocalName() {
        return this.fLocalName;
    }

    public void setName(String prefix, String local, String raw) {
        this.fName = raw;
        this.fNSPrefix = prefix;
        this.fLocalName = local;
    }

    public void setLocalName(String name) {
        this.fLocalName = name;
    }

    public void setElementNamespaceURI(String uri) {
        this.fElementNSURI = uri;
    }

    @Override
    public String getElementNSURI() {
        return this.fElementNSURI;
    }

    @Override
    public void makeAttributePrivate(String name) {
        if (this.fAttributes.containsKey(name) && !this.fHiddenAttributes.contains(name)) {
            this.fHiddenAttributes.add(name);
        }
    }

    public void makeAttibutePublic(String name) {
        if (this.fHiddenAttributes.contains(name)) {
            this.fHiddenAttributes.remove(name);
        }
    }

    public int hashCode() {
        return Util.hashCode((Object)this.fName);
    }
}

