/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.delta;

import com.ibm.cic.common.xml.core.delta.AbstractXMLDelta;
import com.ibm.cic.common.xml.core.delta.IXMLDelta;
import com.ibm.cic.common.xml.core.model.IXMLTextModelItem;

public class AttributeDelta
extends AbstractXMLDelta
implements IXMLDelta {
    protected String fAttr;
    private String fSrcVal;
    private String fTargetVal;

    public AttributeDelta(IXMLTextModelItem src, IXMLTextModelItem target, String attr, IXMLDelta parent) {
        super(src, target);
        this.fAttr = attr;
        if (src != null && target != null) {
            this.check(src, target);
        }
        if (parent != null) {
            parent.addChild(this);
        }
    }

    protected void check(IXMLTextModelItem src, IXMLTextModelItem target) {
        if (src == null && target != null) {
            this.fDelta = (byte)(this.fDelta | 1);
            this.fTargetVal = target.getAttributeValue(this.fAttr);
        }
        if (src != null && target == null) {
            this.fDelta = (byte)(this.fDelta | 4);
            this.fSrcVal = src.getAttributeValue(this.fAttr);
        } else if (src != null && target != null) {
            this.fSrcVal = src.getAttributeValue(this.fAttr);
            this.fTargetVal = target.getAttributeValue(this.fAttr);
            if (src.hasAttribute(this.fAttr) && !target.hasAttribute(this.fAttr)) {
                this.fDelta = (byte)(this.fDelta | 1);
            } else if (!src.hasAttribute(this.fAttr) && target.hasAttribute(this.fAttr)) {
                this.fDelta = (byte)(this.fDelta | 4);
            } else if (!this.fSrcVal.equals(this.fTargetVal)) {
                this.fDelta = (byte)(this.fDelta | 8);
            }
        }
    }

    @Override
    public byte getDelta() {
        return this.fDelta;
    }

    @Override
    public String getName() {
        return this.fAttr;
    }

    @Override
    public String getSourceName() {
        return this.fAttr;
    }

    @Override
    public String getSourceValue() {
        return this.fSrcVal;
    }

    @Override
    public String getTargetName() {
        return this.fAttr;
    }

    @Override
    public String getTargetValue() {
        return this.fTargetVal;
    }

    @Override
    public byte getType() {
        return 1;
    }
}

