/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter.fileUtils;

import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.PlatformUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class FileUtils {
    public static void copyFile(File src, File dest, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        FileUtils.copy(src, dest, null, monitor);
    }

    public static void copyDir(File src, File dest, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        FileUtils.copy(src, dest, null, monitor);
    }

    public static void copy(File src, File dest, String perm, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (src.isFile()) {
            FileUtil.copyFile((File)src, (File)dest, (boolean)false, (String)perm, (IProgressMonitor)monitor);
        } else if (src.isDirectory()) {
            FileUtil.copyDir((File)src, (File)dest, (String)perm, (IProgressMonitor)monitor);
        }
    }

    public static void moveFile(File src, File dest, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        FileUtils.move(src, dest, null, monitor);
    }

    public static void move(File src, File dest, String perm, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        boolean moved = src.renameTo(dest);
        if (moved) {
            if (perm != null) {
                FileUtils.chmod(perm, true, false, dest);
            }
        } else if (src.isFile()) {
            FileUtil.copyFile((File)src, (File)dest, (boolean)false, (String)perm, (IProgressMonitor)monitor);
            FileUtils.removeFile(src, monitor);
        } else if (src.isDirectory()) {
            FileUtil.copyDir((File)src, (File)dest, (String)perm, (IProgressMonitor)monitor);
            FileUtil.rm_r((File)src, (boolean)true);
        }
    }

    public static void removeFile(File src, IProgressMonitor monitor) {
        FileUtil.rm((File)src);
    }

    public static void remove(File src, boolean removeIfEmpty, IProgressMonitor monitor) {
        boolean empty;
        if (removeIfEmpty && !PlatformUtils.isSymlink((File)src) && !src.isFile() && !(empty = FileUtils.isDirEmpty(src))) {
            return;
        }
        FileUtil.rm_r((File)src, (boolean)true);
    }

    public static boolean isDirEmpty(File file) {
        if (PlatformUtils.isSymlink((File)file)) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] fileList;
            File[] fileArray = fileList = file.listFiles();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File currFile = fileArray[n2];
                if (!FileUtils.isDirEmpty(currFile)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public static boolean containsPattern(String path) {
        Path filePath = new Path(path);
        String lastSegment = filePath.lastSegment();
        return lastSegment.indexOf(42) != -1 || lastSegment.indexOf(63) != -1;
    }

    public static boolean patternMatch(String pattern, String str) {
        String str1 = pattern.replaceAll("\\.", "\\\\.");
        String str2 = str1.replaceAll("\\?", ".");
        String str3 = str2.replaceAll("\\*", ".*");
        return Pattern.matches(str3, str);
    }

    public static File[] getFileList(String path) {
        if (!FileUtils.containsPattern(path)) {
            File currFile = new File(path);
            File[] array = new File[]{currFile};
            return array;
        }
        File currFile = new File(path);
        File parentFile = currFile.getParentFile();
        String pattern = currFile.getName();
        if (!parentFile.exists() || parentFile.isFile()) {
            return new File[0];
        }
        File[] children = parentFile.listFiles();
        ArrayList<File> list = new ArrayList<File>();
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            String childName = child.getName();
            if (FileUtils.patternMatch(pattern, childName)) {
                list.add(child);
            }
            ++n2;
        }
        return list.toArray(new File[0]);
    }

    public static File getTopNonExistingDir(File dir) {
        File parentDir = dir.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            return FileUtils.getTopNonExistingDir(parentDir);
        }
        return !dir.exists() ? dir : null;
    }

    public static boolean chmod(String perm, boolean recursive, boolean shellSyntax, File file) {
        return FileUtil.chmod((String)perm, (boolean)recursive, (boolean)shellSyntax, (String[])new String[]{FileUtil.getCanonicalPath((File)file)});
    }
}

