/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallTransaction;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.BackupDirs;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.BackupFiles;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.DelayedProcessing;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.TempUnzipUtil;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Util;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.common.commonNativeAdapterData.ZipCommonNativeData;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.model.Action;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.Phases;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ZipInstallOperation
extends ICommonNativeInstallOperation {
    static final Logger log = Logger.getLogger(ZipInstallOperation.class);
    private final ZipCommonNativeData data;
    private final BackupDirs backupDirs;
    private boolean isInstall;

    public ZipInstallOperation(int phase, IInstallableUnit unit, InstallContext context, ZipCommonNativeData data, BackupDirs backupDirs, boolean isInstall) {
        super(phase, unit, context);
        this.data = data;
        this.backupDirs = backupDirs;
        this.isInstall = isInstall;
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    @Override
    protected boolean shouldPerform() {
        if (this.isInstall) {
            return this.shouldBeInstalled();
        }
        return this.shouldBeUninstalled();
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        if (this.isInstall) {
            this.install(monitor);
        } else {
            this.uninstall(monitor);
        }
        return Status.OK_STATUS;
    }

    public IStatus undoPerform(InstallTransaction transaction, IProgressMonitor monitor) {
        this.isInstall = !this.isInstall;
        return super.undoPerform(transaction, monitor);
    }

    private void install(IProgressMonitor monitor) throws CoreException {
        TempUnzipUtil.ZipEntryFileMap zipEntryFileMap;
        ContentInfoComputation.IValidatingInputStream visZip;
        IArtifact artifact = this.data.getArtifact();
        String destination = this.performVariableSubstitutions(this.data.getDestination());
        try {
            visZip = CacheManager.getDefaultInstance().getArtifactStream(this.getUnit(), artifact, null);
            if (visZip == null) {
                throw Util.coreException(Messages.failed_to_download_artifact, artifact.toUserString());
            }
        }
        catch (CacheManager.CacheManagerException e) {
            throw Util.coreException(e, Messages.failed_to_download_artifact, artifact.toUserString());
        }
        Object zipSource = visZip.getSource();
        IProgressMonitor[] pm = Util.splitProgressMonitor(monitor, 3);
        IProgressMonitor unzipPM = pm[0];
        IProgressMonitor backupPM = pm[1];
        IProgressMonitor movePM = pm[2];
        File destinationDir = this.getDestinationDir(destination);
        this.logUnzip(visZip.getSource(), destinationDir);
        String taskName = NLS.bind((String)Messages.unzipping, (Object)artifact.toUserString());
        String perm = CicCommonSettings.isWindows() ? null : this.data.getPerm();
        File explodedArtifact = AgentInstall.getInstance().getExplodedInstallerArtifact((File)zipSource);
        if (explodedArtifact != null) {
            try {
                IStatus status = AgentInstall.getInstance().installExplodedInstallerArtifact(explodedArtifact, destinationDir, perm, taskName, unzipPM);
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                return;
            }
            finally {
                FileUtil.close((Closeable)visZip.getInputStream());
                unzipPM.done();
                backupPM.done();
                movePM.done();
            }
        }
        FileUtil.ensureDirectory((File)destinationDir);
        String relUnpackPath = this.getArtifactUnpackRelativePath(artifact);
        TempUtil.UniqueTempDir utdForUnzip = TempUnzipUtil.getTempDestination(zipSource, destinationDir, relUnpackPath);
        try {
            zipEntryFileMap = TempUnzipUtil.unzipAndDetermineEntries(this.isUndoable(), visZip, taskName, utdForUnzip, unzipPM);
        }
        catch (CoreException e) {
            TempUnzipUtil.removeIntermediatedUnzipDir(utdForUnzip, e.getStatus(), zipSource);
            destinationDir.delete();
            throw e;
        }
        IStatus statusCheckDigests = visZip.getValidityStatus();
        if (statusCheckDigests.matches(4)) {
            CicMultiStatus ms = Statuses.ERROR.getMultiStatus(Messages.ZipInstallOperation_artifactInconsistent, new Object[]{visZip.getSource()});
            ms.add(statusCheckDigests);
            TempUnzipUtil.removeIntermediatedUnzipDir(utdForUnzip, statusCheckDigests, zipSource);
            destinationDir.delete();
            throw new CoreException((IStatus)ms);
        }
        try {
            try {
                backupPM.beginTask(Messages.backing_up, 1);
                boolean enableBackup = this.determineEnableBackup();
                BackupFiles backupFiles = new BackupFiles(this.backupDirs.getArtifactBackupDir(this.getUnit(), artifact), enableBackup);
                backupFiles.backupFilesInDir(this.data, artifact, zipEntryFileMap, zipSource, destinationDir, backupPM);
            }
            catch (IOException e) {
                ICicStatus error = Statuses.ERROR.get((Throwable)e, NLS.bind((String)Messages.error_backing_up, (Object)zipSource), new Object[0]);
                TempUnzipUtil.removeIntermediatedUnzipDir(utdForUnzip, (IStatus)error, zipSource);
                destinationDir.delete();
                throw new CoreException((IStatus)error);
            }
            catch (CoreException e) {
                log.debug(e.getMessage());
                TempUnzipUtil.removeIntermediatedUnzipDir(utdForUnzip, e.getStatus(), zipSource);
                destinationDir.delete();
                throw e;
            }
        }
        finally {
            backupPM.done();
        }
        try {
            DelayedProcessing delayedProcessing = new DelayedProcessing(this.data.getDelayedDeleteFiles());
            CicMultiStatus ms = Util.multiStatus(NLS.bind((String)Messages.ZipInstallOperation_movingUnpackedFilesTo, (Object)zipSource, (Object)destinationDir));
            delayedProcessing.moveToDestination(ms, this.isUndoable(), zipSource, zipEntryFileMap, destinationDir, perm, taskName, movePM);
            TempUnzipUtil.removeIntermediatedUnzipDir(utdForUnzip, (IStatus)ms, zipSource);
            if (!ms.isOK()) {
                throw new CoreException((IStatus)ms);
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean determineEnableBackup() {
        boolean overwrite = this.data.isOverwrite();
        boolean enableBackup = overwrite || AgentUserOptions.CIC_NATIVE_ALLOW_REPLACE.isSet() || this.getProfile().isAgentProfile();
        return enableBackup;
    }

    private void uninstall(IProgressMonitor monitor) throws CoreException {
        IArtifact artifact = this.data.getArtifact();
        if (Phases.isUninstallationPhase((int)this.getPhase())) {
            this.getInstallContext().setNeedArtifacts(true);
        }
        if (!this.isUndoable() && AgentInstall.getInstance().isAgentInstallerRunning()) {
            File explodedArtifact;
            try {
                File zipFile = CacheManager.getDefaultInstance().getArtifactLocation(this.getUnit(), artifact, null);
                explodedArtifact = AgentInstall.getInstance().getExplodedInstallerArtifact(zipFile);
            }
            catch (CacheManager.CacheManagerException cacheManagerException) {
                explodedArtifact = null;
            }
            if (explodedArtifact != null) {
                String destination = this.performVariableSubstitutions(this.data.getDestination());
                File destinationDir = this.getDestinationDir(destination);
                FileUtil.rm_r((File)destinationDir, (boolean)true);
                return;
            }
        }
        BackupFiles backupFiles = new BackupFiles(this.backupDirs.getArtifactBackupDir(this.getUnit(), artifact));
        DelayedProcessing delayedProcessing = new DelayedProcessing(this.data.getDelayedDeleteFiles());
        IStatus status = backupFiles.restore(this.isUndoable(), delayedProcessing, monitor);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private String getArtifactUnpackRelativePath(IArtifact artifact) {
        String iuPath = String.valueOf(this.getUnit().getIdentity().getId()) + '_' + this.getUnit().getVersion();
        return PathUtil.concatPathSegments((String)iuPath, (String)String.valueOf(this.getUnit().getAdapterData().artifactIndexOf(artifact)));
    }

    private void logUnzip(Object zipFile, File destinationDir) {
        if (!log.isDebugLoggable()) {
            return;
        }
        log.debug("Unzipping {0} for IU {1} {2}", new Object[]{zipFile, this.getUnit().getIdentity(), this.getUnit().getVersion()});
        Object[] list = destinationDir.list();
        if (list == null) {
            log.debug("Destination: {0}; non-existent", new Object[]{destinationDir});
        } else if (list.length == 0) {
            log.debug("Destination: {0}; empty", new Object[]{destinationDir});
        } else {
            log.debug("Destination: {0}; contents: {1}", new Object[]{destinationDir, com.ibm.cic.common.core.utils.Util.toString((Object[])list, (Util.Formatter)new Util.Formatter(" "))});
        }
    }

    private boolean shouldBeInstalled() {
        int currPhase = this.getPhase();
        if (this.data.canInstallArtifact(currPhase)) {
            return !Phases.isUninstallationPhase((int)currPhase) || !this.artifactBackupExists();
        }
        if (this.isUndoable() && this.data.isFirstUninstallPhase(currPhase) && this.isRetroactiveUninstall() && !this.artifactBackupExists()) {
            return true;
        }
        return this.getInstallContext().isInstallableUnitTransactionUndoing() && Phases.isInstallationPhase((int)currPhase) && this.data.shouldBeInstalled(currPhase) && !this.artifactBackupExists();
    }

    private boolean shouldBeUninstalled() {
        int currPhase = this.getPhase();
        if (this.data.canUninstallArtifact(currPhase)) {
            return true;
        }
        if (this.isUndoable() && this.data.isLastInstallPhase(currPhase) && this.isRetroactiveInstall() && this.artifactBackupExists()) {
            return true;
        }
        return this.getInstallContext().isInstallableUnitTransactionUndoing() && Phases.isUninstallationPhase((int)currPhase) && !this.data.shouldBeInstalled(currPhase) && this.artifactBackupExists();
    }

    private boolean isRetroactiveUnit() {
        String retroactiveValue = this.getUnit().getProperties().getProperty("order.dependencies.are.retroactive");
        return "true".equalsIgnoreCase(retroactiveValue);
    }

    private boolean isRetroactiveInstall() {
        InstallContext context = this.getInstallContext();
        IInstallableUnit iu = this.getUnit();
        return this.isRetroactiveUnit() && context.getIUAction(iu) == Action.REINSTALL && context.getOriginalIUAction(iu) == Action.UNINSTALL;
    }

    private boolean isRetroactiveUninstall() {
        InstallContext context = this.getInstallContext();
        IInstallableUnit iu = this.getUnit();
        return this.isRetroactiveUnit() && context.getIUAction(iu) == Action.REINSTALL && context.getOriginalIUAction(iu) == Action.INSTALL;
    }

    private boolean artifactBackupExists() {
        IArtifact artifact = this.data.getArtifact();
        BackupFiles backupFiles = new BackupFiles(this.backupDirs.getArtifactBackupDir(this.getUnit(), artifact));
        return backupFiles.artifactBackupExists();
    }

    private File getDestinationDir(String destination) {
        File destinationDir;
        Path destPath = new Path(destination);
        if (destPath.isAbsolute()) {
            destinationDir = destPath.toFile();
        } else {
            destinationDir = new File(this.getInstallContext().getInstallLocation());
            if (!destination.equals(".")) {
                destinationDir = new File(destinationDir, destination);
            }
        }
        return destinationDir;
    }
}

