/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Util;
import com.ibm.cic.common.core.utils.AbstractPlatformPolicyFactory;
import com.ibm.cic.common.core.utils.FileName;
import java.io.File;
import org.eclipse.core.runtime.CoreException;

class PPExecInstallOperation
extends AbstractPlatformPolicyFactory {
    static PPExecInstallOperation m_factory = new PPExecInstallOperation();

    PPExecInstallOperation() {
    }

    protected Object createLinuxPolicy() {
        return new PPLinux();
    }

    protected Object createWindowsPolicy() {
        return new PPWindows();
    }

    static PPCommon getPolicy() {
        return (PPCommon)m_factory.getPlatformPolicy();
    }

    abstract class PPCommon {
        PPCommon() {
        }

        String[] platformSpecificCheck(String command) throws CoreException {
            if (!new File(command).exists()) {
                throw Util.coreException(Messages.fileutils_file_not_found, command);
            }
            return null;
        }
    }

    class PPLinux
    extends PPCommon {
        PPLinux() {
        }
    }

    class PPWindows
    extends PPCommon {
        PPWindows() {
        }

        @Override
        String[] platformSpecificCheck(String command) throws CoreException {
            if (!new File(command).exists() && !new File(String.valueOf(command) + ".exe").exists()) {
                throw Util.coreException(Messages.fileutils_file_not_found, command);
            }
            String ext = FileName.getSuffix((String)command).toLowerCase();
            if (".js".equals(ext) || ".vbs".equals(ext)) {
                return new String[]{"cscript.exe", "//nologo", command};
            }
            return null;
        }
    }
}

