/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallTransaction;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ExecInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.common.commonNativeAdapterData.ArgCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.ExecCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.CicFactory;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class ExecApplication
implements IApplication {
    private static final Logger log = Logger.getLogger(ExecApplication.class);
    private static final String LOGDIR_OPTION = "-logdir";
    private static final String WORKINGDIR_OPTION = "-workingDir";

    public Object start(IApplicationContext context) {
        try {
            IStatus status;
            CicCommonSettings.setInstanceArea();
            String[] arguments = (String[])context.getArguments().get("application.args");
            arguments = CmdLine.CL.ignoreArguments(arguments);
            ExecCommonNativeData data = this.createData(arguments);
            ExecInstallOperation op = this.createOperation(data);
            try {
                status = op.perform(InstallTransaction.NULL, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                op.writer.close();
            }
            if (status.isOK()) {
                return IApplication.EXIT_OK;
            }
            log.status(status);
        }
        catch (ErrorException e) {
            log.error(e.getMessage());
        }
        catch (Throwable e) {
            log.error(e);
        }
        PlatformUtils.disableErrorOutput();
        return 1;
    }

    public void stop() {
    }

    private ExecInstallOperation createOperation(ExecCommonNativeData data) {
        InstallContext installContext = new InstallContext((Object)new Profile("profile-id", "product"), "context-id", null, null);
        IInstallableUnit unit = CicFactory.getInstance().createInstallableUnit((IIdentity)new SimpleIdentity("iu-id"), Version.emptyVersion);
        PerformCommonNativeData performData = new PerformCommonNativeData(0x200000L, 0);
        ICommonNativeInstallAdapter.SupplementaryLogWriter writer = ICommonNativeInstallAdapter.SupplementaryLogWriter.create();
        return new ExecInstallOperation(21, unit, installContext, data, performData, writer);
    }

    private ExecCommonNativeData createData(String[] arguments) throws ErrorException {
        log.debug("Arguments: {0}", new Object[]{arguments});
        File workingDir = new File(".");
        File logDir = null;
        ArrayList<String> args = new ArrayList<String>(arguments.length);
        int i1 = 0;
        while (i1 < arguments.length) {
            String arg;
            if (LOGDIR_OPTION.equals(arg = arguments[i1++])) {
                logDir = this.getDirOption(arguments, i1++, LOGDIR_OPTION);
                continue;
            }
            if (WORKINGDIR_OPTION.equals(arg)) {
                workingDir = this.getDirOption(arguments, i1++, WORKINGDIR_OPTION);
                continue;
            }
            args.add(arg);
        }
        if (logDir == null) {
            log.note(Messages.ExecApplication_Log_File, new Object[]{LogManager.getDefaultLogFile()});
        } else {
            LogManager.setDirectory(logDir);
        }
        if (args.isEmpty()) {
            throw new ErrorException(Messages.ExecApplication_Usage, LogManager.getDirectory());
        }
        String cmd = (String)args.get(0);
        ExecCommonNativeData data = new ExecCommonNativeData(true, cmd, workingDir.getAbsolutePath(), 0, null);
        int i = 1;
        while (i < args.size()) {
            ArgCommonNativeData argData = new ArgCommonNativeData();
            argData.setArgText((String)args.get(i));
            data.addArgument(argData);
            ++i;
        }
        return data;
    }

    private File getDirOption(String[] args, int index, String optionName) throws ErrorException {
        if (args.length == index) {
            throw new ErrorException(Messages.InvokeApplication_Missing_Required_Log_Directory, optionName);
        }
        File result = new File(args[index]);
        if (!result.isDirectory()) {
            throw new ErrorException(Messages.InvokeApplication_Not_A_Directory, result);
        }
        return result;
    }

    private static class ErrorException
    extends Exception {
        public ErrorException(String message, Object arg) {
            super(NLS.bind((String)message, (Object)arg));
        }
    }
}

