/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallOperation;
import com.ibm.cic.common.commonNativeAdapterData.CreateFileNativeData;
import com.ibm.cic.common.commonNativeAdapterData.LineNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CreateFileInstallOperation
extends ICommonNativeInstallOperation {
    private static final Logger log = Logger.getLogger(CreateFileInstallOperation.class);
    private final CreateFileNativeData data;

    public CreateFileInstallOperation(int phase, IInstallableUnit unit, InstallContext context, CreateFileNativeData data) {
        super(phase, unit, context);
        this.data = data;
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws AbstractVariableSubstitution.VariableSubstitutionException {
        String filePath = this.performVariableSubstitutions(this.data.getFile());
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            file = new File(this.getInstallContext().getInstallLocation(), filePath);
        }
        if (this.getPhase() == 21) {
            file.getParentFile().mkdirs();
            boolean resolveString = this.data.isResolveString();
            LineNativeData[] lineData = this.data.getLines();
            String[] lines = new String[lineData.length];
            int i = 0;
            while (i < lineData.length) {
                String text = lineData[i].getLineText();
                lines[i] = resolveString ? this.performVariableSubstitutions(text) : text;
                ++i;
            }
            this.createTextFile(file, lines);
        } else if (this.getPhase() == 51) {
            file.delete();
        }
        return Status.OK_STATUS;
    }

    private void createTextFile(File file, String[] lines) {
        try (BufferedWriter writer = new BufferedWriter(Encodings.DEFAULT.writer(file));){
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                writer.write(line);
                writer.newLine();
                ++n2;
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }
}

