/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.sun.deploy.security.MozillaJSSDSAPrivateKey;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public abstract class MozillaJSSDSASignature
extends SignatureSpi {
    private MozillaJSSDSAPrivateKey privateKey = null;
    static /* synthetic */ Class array$B;

    protected abstract void update(byte[] var1, int var2, int var3);

    protected abstract byte[] getDigest() throws SignatureException;

    protected abstract void resetDigest();

    private Object getJSSSignature(Object object) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName("org.mozilla.jss.crypto.CryptoToken", true, ClassLoader.getSystemClassLoader());
        Class<?> clazz2 = Class.forName("org.mozilla.jss.crypto.SignatureAlgorithm", true, ClassLoader.getSystemClassLoader());
        Class[] classArray = new Class[]{clazz2};
        Method method = clazz.getMethod("getSignatureContext", classArray);
        Field field = clazz2.getField("DSASignature");
        Object[] objectArray = new Object[]{field.get(null)};
        return method.invoke(object, objectArray);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new InvalidKeyException("Key not supported");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof MozillaJSSDSAPrivateKey)) {
            throw new InvalidKeyException("Key not supported");
        }
        this.privateKey = (MozillaJSSDSAPrivateKey)privateKey;
    }

    protected void engineUpdate(byte by) throws SignatureException {
        byte[] byArray = new byte[]{by};
        this.update(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.update(byArray, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] engineSign() throws SignatureException {
        try {
            try {
                byte[] byArray = this.getDigest();
                Object object = this.privateKey.getJSSPrivateKey();
                Class<?> clazz = Class.forName("org.mozilla.jss.crypto.PrivateKey", true, ClassLoader.getSystemClassLoader());
                Method method = clazz.getMethod("getOwningToken", null);
                Object object2 = method.invoke(object, null);
                Object object3 = this.getJSSSignature(object2);
                Class<?> clazz2 = Class.forName("org.mozilla.jss.crypto.Signature", true, ClassLoader.getSystemClassLoader());
                Class[] classArray = new Class[]{clazz};
                Method method2 = clazz2.getMethod("initSign", classArray);
                Object[] objectArray = new Object[]{object};
                Object object4 = method2.invoke(object3, objectArray);
                Class[] classArray2 = new Class[]{array$B == null ? (array$B = MozillaJSSDSASignature.class$("[B")) : array$B};
                Method method3 = clazz2.getMethod("update", classArray2);
                Object[] objectArray2 = new Object[]{byArray};
                Object object5 = method3.invoke(object3, objectArray2);
                Method method4 = clazz2.getMethod("sign", null);
                byte[] byArray2 = (byte[])method4.invoke(object3, null);
                byte[] byArray3 = new byte[20];
                byte[] byArray4 = new byte[20];
                System.arraycopy(byArray2, 0, byArray3, 0, 20);
                System.arraycopy(byArray2, 20, byArray4, 0, 20);
                BigInteger bigInteger = new BigInteger(byArray3);
                BigInteger bigInteger2 = new BigInteger(byArray4);
                DerOutputStream derOutputStream = new DerOutputStream(100);
                derOutputStream.putInteger(bigInteger);
                derOutputStream.putInteger(bigInteger2);
                DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
                byte[] byArray5 = derValue.toByteArray();
                Object var26_28 = null;
                this.resetDigest();
                return byArray5;
            }
            catch (SignatureException signatureException) {
                throw signatureException;
            }
            catch (Throwable throwable) {
                SignatureException signatureException = new SignatureException("Error generating signature.");
                signatureException.initCause(throwable);
                throw signatureException;
            }
        }
        catch (Throwable throwable) {
            Object var26_29 = null;
            this.resetDigest();
            throw throwable;
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        throw new SignatureException("Signature verification not supported");
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class NONEwithDSA
    extends MozillaJSSDSASignature {
        private static final int SHA1_LEN = 20;
        private final byte[] digestBuffer = new byte[20];
        private int offset;

        protected void update(byte[] byArray, int n, int n2) {
            if (n2 == 0 || byArray == null) {
                return;
            }
            if (this.offset + n2 > 20) {
                this.offset = 21;
                return;
            }
            System.arraycopy(byArray, n, this.digestBuffer, this.offset, n2);
            this.offset += n2;
        }

        protected byte[] getDigest() throws SignatureException {
            if (this.offset != 20) {
                throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
            }
            this.offset = 0;
            return this.digestBuffer;
        }

        protected void resetDigest() {
            this.offset = 0;
        }
    }

    public static class SHA1withDSA
    extends MozillaJSSDSASignature {
        private final MessageDigest dataSHA = MessageDigest.getInstance("SHA-1");

        public SHA1withDSA() throws NoSuchAlgorithmException {
            this.dataSHA.reset();
        }

        protected void update(byte[] byArray, int n, int n2) {
            if (n2 == 0 || byArray == null) {
                return;
            }
            this.dataSHA.update(byArray, n, n2);
        }

        protected byte[] getDigest() {
            return this.dataSHA.digest();
        }

        protected void resetDigest() {
            this.dataSHA.reset();
        }
    }
}

