/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.iwm.internal.util;

import com.ibm.cic.common.core.iwm.internal.Activator;
import com.ibm.cic.common.core.iwm.internal.Messages;
import com.ibm.cic.common.core.iwm.internal.model.MultipleChoiceQuestion;
import com.ibm.cic.common.core.iwm.internal.util.NoNurtureQuestionsException;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.XMLParser;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NurtureQuestionsHelper {
    private static final Logger logger = Logger.getLogger(NurtureQuestionsHelper.class);
    private static NurtureQuestionsHelper instance = null;
    private SAXParserFactory factory = SAXParserFactory.newInstance();

    static {
        instance = new NurtureQuestionsHelper();
    }

    private NurtureQuestionsHelper() {
    }

    public static NurtureQuestionsHelper getInstance() {
        return instance;
    }

    public Map populateNurtureQuestions(File responseFile) throws Exception {
        Map map = new NurtureResponseParser(Activator.getDefault().getBundle().getBundleContext(), Activator.getPluginId()).parse(responseFile);
        this.updateSourceQuestionsMap(map);
        return map;
    }

    private void updateSourceQuestionsMap(Map map) throws ParserConfigurationException, SAXException, IOException, NoNurtureQuestionsException {
        Iterator iterator = map.entrySet().iterator();
        if (!map.isEmpty()) {
            NurtureQuestionsParser parser = new NurtureQuestionsParser(Activator.getDefault().getBundle().getBundleContext(), Activator.getPluginId());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String source = (String)entry.getValue();
                List questions = parser.parse(source);
                entry.setValue(questions);
            }
        }
    }

    private class NurtureQuestionsParser
    extends XMLParser {
        private static final String QUESTIONS = "IWM_Questions";
        private static final String NEXT_QUESTION = "IWM_NextQuestion";
        private static final String QUESTION_RADIO = "IWM_RadioQuestion";
        private static final String QUESTION_CHECKBOX = "IWM_CheckboxQuestion";
        private static final String QUESTION_TEXT = "IWM_OtherTextBox";
        private static final String QUESTION_DISPLAY_TEXT = "IWM_DisplayText";
        private static final String QUESTION_NAME = "IWM_QuestionName";
        private static final String QUESTION_VALUE = "IWM_QuestionValue";
        private static final String ANSWER_RADIO = "IWM_RadioOption";
        private static final String ANSWER_CHECKBOX = "IWM_CheckboxOption";
        private static final String ANSWER_DISPLAY_TEXT = "IWM_OptionDisplayText";
        private static final String ANSWER_VALUE = "IWM_OptionValue";
        private static final String ANSWER_TEXT_VALUE = "IWM_DefaultText";
        private static final int IGNORED_ELEMENT_STATE = 0;
        private static final int INITIAL_STATE = 2;
        private static final int QUESTIONS_STATE = 3;
        private static final int NEXT_QUESTION_STATE = 4;
        private static final int QUESTION_RADIO_STATE = 5;
        private static final int QUESTION_CHECKBOX_STATE = 6;
        private static final int QUESTION_TEXT_STATE = 7;
        private static final int QUESTION_DISPLAY_TEXT_STATE = 8;
        private static final int QUESTION_NAME_STATE = 9;
        private static final int QUESTION_VALUE_STATE = 10;
        private static final int ANSWER_RADIO_STATE = 11;
        private static final int ANSWER_CHECKBOX_STATE = 12;
        private static final int ANSWER_DISPLAY_TEXT_STATE = 13;
        private static final int ANSWER_VALUE_STATE = 14;
        private static final int ANSWER_TEXT_VALUE_STATE = 15;
        private static final String TXT = "_TXT";
        private List questions;
        private final Stack mcqStack;

        public NurtureQuestionsParser(BundleContext context, String pluginId) {
            super(context, pluginId);
            this.mcqStack = new Stack();
            this.stateStack = new XMLParser.StateStack();
            this.status = Statuses.ST.createMultiStatus();
        }

        public List parse(String content) throws ParserConfigurationException, SAXException, IOException {
            SAXParser parser = NurtureQuestionsHelper.this.factory.newSAXParser();
            InputSource source = new InputSource(new StringReader(content));
            logger.info("Parsing nurture questions");
            logger.debug(content);
            parser.parse(source, (DefaultHandler)((Object)this));
            logger.info("Successfully parsed nurture questions");
            int i = 0;
            while (i < this.questions.size()) {
                MultipleChoiceQuestion mcq = (MultipleChoiceQuestion)this.questions.get(i);
                if (mcq.getQuestionName().endsWith(TXT) && i < this.questions.size()) {
                    int index = mcq.getQuestionName().indexOf(TXT);
                    String prefix = mcq.getQuestionName().substring(0, index);
                    MultipleChoiceQuestion mcq2 = (MultipleChoiceQuestion)this.questions.get(i + 1);
                    if (mcq2.getQuestionName().startsWith(prefix)) {
                        List answers = mcq2.getAnswers();
                        MultipleChoiceQuestion.LocaleSupport ls = (MultipleChoiceQuestion.LocaleSupport)answers.get(answers.size() - 1);
                        ls.setMcq(mcq);
                        this.questions.remove(i + 1);
                        this.questions.add(i, mcq2);
                        this.questions.remove(i + 1);
                        ++i;
                    }
                }
                ++i;
            }
            return this.questions;
        }

        protected String getErrorMessage() {
            return Messages.NurtureQuestionsParser_parsing_error;
        }

        protected Logger getLogger() {
            return logger;
        }

        protected Object getRootObject() {
            return this.questions;
        }

        protected String processCharacters(String trimmedChars) {
            switch (this.stateStack.peekState()) {
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: {
                    this.setValue(trimmedChars);
                    break;
                }
            }
            return trimmedChars;
        }

        protected void setValue(String trimmedChars) {
            int state = this.stateStack.peekState();
            this.stateStack.pop();
            this.stateStack.push(state, (Object)trimmedChars);
        }

        public void unexpectedAttribute(String element, String attribute, String value) {
            super.unexpectedAttribute(element, attribute, value);
            this.questions = null;
        }

        public void unexpectedCharacterData(String cdata) {
            super.unexpectedCharacterData(cdata);
            this.questions = null;
        }

        public void unexpectedElement(String element, Attributes attributes) {
            super.unexpectedElement(element, attributes);
            this.questions = null;
        }

        protected void unexpectedElementError(String element, Attributes attributes) {
            super.unexpectedElementError(element, attributes);
            this.questions = null;
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.stateStack.clear();
            this.stateStack.push(2, null);
        }

        public void startElement(String uri, String name, String qName, Attributes attributes) {
            if (!this.status.isOK()) {
                return;
            }
            this.finishCharacters();
            MultipleChoiceQuestion lastQuestion = null;
            switch (this.stateStack.peekState()) {
                case 0: {
                    this.stateStack.push(0, (Object)("error: " + name));
                    break;
                }
                case 2: {
                    if (!qName.equals(QUESTIONS)) {
                        this.unexpectedElementError(name, attributes);
                        return;
                    }
                    this.stateStack.push(3, new LinkedList());
                    break;
                }
                case 3: {
                    if (!qName.equals(NEXT_QUESTION)) break;
                    this.stateStack.push(4, (Object)new MultipleChoiceQuestion());
                    this.mcqStack.push(this.stateStack.peekObject());
                    break;
                }
                case 4: {
                    if (!qName.equals(QUESTION_RADIO) && !qName.equals(QUESTION_CHECKBOX)) {
                        this.unexpectedElementError(name, attributes);
                        return;
                    }
                    lastQuestion = (MultipleChoiceQuestion)this.mcqStack.peek();
                    if (qName.equals(QUESTION_RADIO)) {
                        lastQuestion.setType(0);
                        this.stateStack.push(5, null);
                        break;
                    }
                    if (!qName.equals(QUESTION_CHECKBOX)) break;
                    lastQuestion.setType(1);
                    this.stateStack.push(6, null);
                    break;
                }
                case 5: {
                    if (!(qName.equals(QUESTION_DISPLAY_TEXT) || qName.equals(QUESTION_NAME) || qName.equals(QUESTION_VALUE) || qName.equals(ANSWER_RADIO) || qName.equals(QUESTION_TEXT))) {
                        return;
                    }
                    if (qName.equals(QUESTION_DISPLAY_TEXT)) {
                        this.stateStack.push(8, null);
                        break;
                    }
                    if (qName.equals(QUESTION_NAME)) {
                        this.stateStack.push(9, null);
                        break;
                    }
                    if (qName.equals(QUESTION_VALUE)) {
                        this.stateStack.push(10, null);
                        break;
                    }
                    if (qName.equals(ANSWER_RADIO)) {
                        lastQuestion = (MultipleChoiceQuestion)this.mcqStack.peek();
                        lastQuestion.getAnswers().add(lastQuestion.new MultipleChoiceQuestion.LocaleSupport());
                        this.stateStack.push(11, null);
                        break;
                    }
                    if (!qName.equals(QUESTION_TEXT)) break;
                    MultipleChoiceQuestion mcq = new MultipleChoiceQuestion();
                    mcq.setType(2);
                    this.stateStack.push(7, (Object)mcq);
                    this.mcqStack.push(this.stateStack.peekObject());
                    break;
                }
                case 6: {
                    if (!(qName.equals(QUESTION_DISPLAY_TEXT) || qName.equals(QUESTION_NAME) || qName.equals(QUESTION_VALUE) || qName.equals(ANSWER_CHECKBOX))) {
                        return;
                    }
                    if (qName.equals(QUESTION_DISPLAY_TEXT)) {
                        this.stateStack.push(8, null);
                        break;
                    }
                    if (qName.equals(QUESTION_NAME)) {
                        this.stateStack.push(9, null);
                        break;
                    }
                    if (qName.equals(QUESTION_VALUE)) {
                        this.stateStack.push(10, null);
                        break;
                    }
                    if (!qName.equals(ANSWER_CHECKBOX)) break;
                    lastQuestion = (MultipleChoiceQuestion)this.mcqStack.peek();
                    lastQuestion.getAnswers().add(lastQuestion.new MultipleChoiceQuestion.LocaleSupport());
                    this.stateStack.push(12, null);
                    break;
                }
                case 7: {
                    if (!(qName.equals(QUESTION_DISPLAY_TEXT) || qName.equals(QUESTION_NAME) || qName.equals(QUESTION_VALUE) || qName.equals(ANSWER_TEXT_VALUE))) {
                        return;
                    }
                    if (qName.equals(QUESTION_DISPLAY_TEXT)) {
                        this.stateStack.push(8, null);
                        break;
                    }
                    if (qName.equals(QUESTION_NAME)) {
                        this.stateStack.push(9, null);
                        break;
                    }
                    if (qName.equals(QUESTION_VALUE)) {
                        this.stateStack.push(10, null);
                        break;
                    }
                    if (!qName.equals(ANSWER_TEXT_VALUE)) break;
                    lastQuestion = (MultipleChoiceQuestion)this.mcqStack.peek();
                    lastQuestion.getAnswers().add(lastQuestion.new MultipleChoiceQuestion.LocaleSupport());
                    this.stateStack.push(15, null);
                    break;
                }
                case 11: 
                case 12: {
                    if (!qName.equals(ANSWER_DISPLAY_TEXT) && !qName.equals(ANSWER_VALUE)) {
                        return;
                    }
                    if (qName.equals(ANSWER_DISPLAY_TEXT)) {
                        this.stateStack.push(13, null);
                        break;
                    }
                    if (!qName.equals(ANSWER_VALUE)) break;
                    this.stateStack.push(14, null);
                    break;
                }
                case 15: {
                    this.stateStack.push(15, null);
                    break;
                }
            }
        }

        public void endElement(String uri, String localName, String qName) {
            this.finishCharacters();
            int state = this.stateStack.peekState();
            Object obj = this.stateStack.peekObject();
            List list = null;
            MultipleChoiceQuestion.LocaleSupport ls = null;
            Object parentObject = null;
            MultipleChoiceQuestion lastQuestion = null;
            block0 : switch (state) {
                case 15: {
                    this.stateStack.pop();
                    if (obj != null) {
                        if (!(obj instanceof String)) {
                            logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{obj.getClass()});
                            return;
                        }
                    } else {
                        obj = "";
                    }
                    lastQuestion = (MultipleChoiceQuestion)this.mcqStack.peek();
                    list = lastQuestion.getAnswers();
                    ls = (MultipleChoiceQuestion.LocaleSupport)list.get(list.size() - 1);
                    ls.setValue((String)obj);
                    ls.setDisplayText(ls.getValue());
                    break;
                }
                case 14: {
                    this.stateStack.pop();
                    if (!(obj instanceof String)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{obj.getClass()});
                        return;
                    }
                    lastQuestion = (MultipleChoiceQuestion)this.mcqStack.peek();
                    list = lastQuestion.getAnswers();
                    ls = (MultipleChoiceQuestion.LocaleSupport)list.get(list.size() - 1);
                    ls.setValue((String)obj);
                    break;
                }
                case 13: {
                    this.stateStack.pop();
                    if (!(obj instanceof String)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{obj.getClass()});
                        return;
                    }
                    lastQuestion = (MultipleChoiceQuestion)this.mcqStack.peek();
                    list = lastQuestion.getAnswers();
                    ls = (MultipleChoiceQuestion.LocaleSupport)list.get(list.size() - 1);
                    ls.setDisplayText((String)obj);
                    break;
                }
                case 8: {
                    this.stateStack.pop();
                    if (!(obj instanceof String)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{obj.getClass()});
                        return;
                    }
                    lastQuestion = (MultipleChoiceQuestion)this.mcqStack.peek();
                    lastQuestion.getQuestion().setDisplayText((String)obj);
                    break;
                }
                case 10: {
                    this.stateStack.pop();
                    if (!(obj instanceof String)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{obj.getClass()});
                        return;
                    }
                    lastQuestion = (MultipleChoiceQuestion)this.mcqStack.peek();
                    lastQuestion.getQuestion().setValue((String)obj);
                    break;
                }
                case 9: {
                    this.stateStack.pop();
                    if (!(obj instanceof String)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{obj.getClass()});
                        return;
                    }
                    lastQuestion = (MultipleChoiceQuestion)this.mcqStack.peek();
                    lastQuestion.setQuestionName((String)obj);
                    break;
                }
                case 4: {
                    this.stateStack.pop();
                    parentObject = this.getParentObjectFromStateStack();
                    if (!(parentObject instanceof List)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{parentObject.getClass()});
                        return;
                    }
                    lastQuestion = (MultipleChoiceQuestion)this.mcqStack.peek();
                    list = (List)parentObject;
                    list.add(lastQuestion);
                    break;
                }
                case 3: {
                    if (!qName.equals(QUESTIONS)) break;
                    this.stateStack.pop();
                    if (!(obj instanceof List)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{obj.getClass()});
                        return;
                    }
                    this.questions = (List)obj;
                    break;
                }
                case 7: {
                    if (!(qName.equals(ANSWER_TEXT_VALUE) || qName.equals(QUESTION_NAME) || qName.equals(QUESTION_DISPLAY_TEXT) || qName.equals(QUESTION_VALUE) || qName.equals(QUESTION_TEXT))) {
                        return;
                    }
                    this.stateStack.pop();
                    int i = 0;
                    while (i < this.stateStack.size()) {
                        Object object = this.stateStack.peekObject(i);
                        if (object instanceof List) {
                            List l = (List)object;
                            l.add(this.mcqStack.pop());
                            break block0;
                        }
                        ++i;
                    }
                    break;
                }
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    if (!qName.equals(QUESTION_RADIO) && !qName.equals(QUESTION_CHECKBOX) && !qName.equals(ANSWER_RADIO) && !qName.equals(ANSWER_CHECKBOX)) break;
                    this.stateStack.pop();
                    break;
                }
            }
        }

        private Object getParentObjectFromStateStack() {
            Object parentObject = null;
            if (this.stateStack.peekState() != 2) {
                parentObject = this.stateStack.peekObject();
            }
            return parentObject;
        }
    }

    private class NurtureResponseParser
    extends XMLParser {
        private static final String RESPONSE_TAG = "response";
        private static final String QUESTIONS_TAG = "questions";
        private static final String ATTR_VALUE = "source";
        private static final String ERRORS = "errors";
        private static final String ERROR = "error";
        private static final int IGNORED_ELEMENT_STATE = 0;
        private static final int INITIAL_STATE = 2;
        private static final int RESPONSE_STATE = 3;
        private static final int QUESTIONS_STATE = 4;
        private static final int ERRORS_STATE = 5;
        private static final int ERROR_STATE = 6;
        private Map sourceQuestionsMap;
        private List errors;
        private String lastSource;

        public NurtureResponseParser(BundleContext context, String pluginId) {
            super(context, pluginId);
            this.stateStack = new XMLParser.StateStack();
            this.status = Statuses.ST.createMultiStatus();
        }

        public Map parse(File responseFile) throws ParserConfigurationException, SAXException, IOException, NoNurtureQuestionsException {
            Map map;
            SAXParser parser = NurtureQuestionsHelper.this.factory.newSAXParser();
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(responseFile));
                InputSource source = new InputSource(is);
                logger.info("Parsing nurture response...");
                parser.parse(source, (DefaultHandler)((Object)this));
                if (this.errors != null) {
                    throw new NoNurtureQuestionsException(this.errors);
                }
                logger.info("Successfully parsed nurture questions");
                map = this.sourceQuestionsMap;
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                throw throwable;
            }
            FileUtil.close((Closeable)is);
            return map;
        }

        protected String getErrorMessage() {
            return Messages.NurtureQuestionsParser_parsing_error;
        }

        protected Logger getLogger() {
            return logger;
        }

        protected Object getRootObject() {
            return this.sourceQuestionsMap;
        }

        protected String processCharacters(String trimmedChars) {
            switch (this.stateStack.peekState()) {
                case 4: 
                case 6: {
                    this.setValue(trimmedChars);
                    break;
                }
                default: {
                    this.unexpectedCharacterData(trimmedChars);
                }
            }
            return trimmedChars;
        }

        protected void setValue(String trimmedChars) {
            int state = this.stateStack.peekState();
            this.stateStack.pop();
            this.stateStack.push(state, (Object)trimmedChars);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.stateStack.clear();
            this.stateStack.push(2, null);
        }

        public void startElement(String uri, String name, String qName, Attributes attributes) {
            if (!this.status.isOK()) {
                return;
            }
            this.finishCharacters();
            switch (this.stateStack.peekState()) {
                case 0: {
                    this.stateStack.push(0, (Object)("error: " + name));
                    break;
                }
                case 2: {
                    if (qName.equals(RESPONSE_TAG) && qName.equals(ERRORS)) {
                        this.unexpectedElementError(name, attributes);
                        return;
                    }
                    if (qName.equals(RESPONSE_TAG)) {
                        this.stateStack.push(3, new HashMap());
                        break;
                    }
                    this.stateStack.push(5, new LinkedList());
                    break;
                }
                case 3: {
                    if (!qName.equals(QUESTIONS_TAG)) {
                        this.unexpectedElementError(name, attributes);
                        return;
                    }
                    this.lastSource = attributes.getValue(ATTR_VALUE);
                    if (this.lastSource == null) {
                        this.unexpectedAttribute(uri, ATTR_VALUE, null);
                    }
                    this.stateStack.push(4, null);
                    break;
                }
                case 5: {
                    if (!qName.equals(ERROR)) {
                        this.unexpectedElementError(name, attributes);
                        return;
                    }
                    this.stateStack.push(6, null);
                    break;
                }
            }
        }

        public void endElement(String uri, String localName, String qName) {
            this.finishCharacters();
            int state = this.stateStack.peekState();
            Object obj = this.stateStack.peekObject();
            this.stateStack.pop();
            this.handleEndElementStates(state, obj);
        }

        private void handleEndElementStates(int state, Object obj) {
            Object parentObject = null;
            if (state != 5 || state != 3) {
                parentObject = this.stateStack.peekObject();
            }
            switch (state) {
                case 6: {
                    if (!(obj instanceof String)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{obj.getClass()});
                        return;
                    }
                    if (!(parentObject instanceof List)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{parentObject.getClass()});
                        return;
                    }
                    String buf1 = (String)obj;
                    List list1 = (List)parentObject;
                    list1.add(buf1.toString());
                    break;
                }
                case 5: {
                    if (!(obj instanceof List)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{obj.getClass()});
                        return;
                    }
                    this.errors = (List)obj;
                    break;
                }
                case 4: {
                    if (!(obj instanceof String)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{obj.getClass()});
                        return;
                    }
                    if (!(parentObject instanceof Map)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{parentObject.getClass()});
                        return;
                    }
                    ((Map)parentObject).put(this.lastSource, obj);
                    break;
                }
                case 3: {
                    if (!(obj instanceof Map)) {
                        logger.error(Messages.NurtureQuestionsParser_parser_state_error, new Object[]{obj.getClass()});
                        return;
                    }
                    this.sourceQuestionsMap = (Map)obj;
                    break;
                }
            }
        }
    }
}

