/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tivoli.omnibus.core.custompanel;

import com.ibm.cic.agent.core.api.ILogger;
import com.ibm.tivoli.omnibus.core.custompanel.Messages;
import java.io.File;

public class Utility {
    public static String checkMigrationSource(String migrateSrc, ILogger logger) {
        String errorMessage = null;
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            boolean omnibusPresent = Utility.isUnixOMNIbusInstalled(migrateSrc);
            if (!omnibusPresent) {
                errorMessage = Messages.MigrateInvalidMigrateDir;
            }
            logger.debug("Netcool/OMNIbus migration from {0} : {1}", (Object[])new String[]{migrateSrc, errorMessage});
        } else {
            boolean validDataStore = Utility.isWindowsDataStore(migrateSrc);
            if (!validDataStore) {
                errorMessage = Messages.MigrateInvalidDataSource;
            }
        }
        return errorMessage;
    }

    public static boolean isUnixOMNIbusInstalled(String installDir) {
        File installPath = new File(installDir);
        File omnibusPath = new File(installPath, "omnibus");
        File oldReleaseId = new File(installPath, "RELEASE_ID");
        File newReleaseId = new File(omnibusPath, "RELEASE_ID");
        return oldReleaseId.isFile() || newReleaseId.isFile();
    }

    public static boolean isWindowsDataStore(String datastoreDir) {
        File storePath = new File(datastoreDir);
        File omnibusPath = new File(storePath, "omnibus");
        File dbPath = new File(omnibusPath, "db");
        File probePath = new File(omnibusPath, "probes");
        File releaseId = new File(omnibusPath, "RELEASE_ID");
        return releaseId.isFile() || dbPath.isDirectory() || probePath.isDirectory();
    }
}

