/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Pattern;

public class WASPlatformConstants {
    public static final int N_UNKNOWN = 0;
    public static final int N_AIX = 1;
    public static final int N_HPUX = 2;
    public static final int N_SOLARIS = 3;
    public static final int N_LINUX = 4;
    public static final int N_WINDOWS = 5;
    public static final int N_Z_OS = 6;
    public static final int N_OS400 = 7;
    public static final int N_OS400_REMOTE = 8;
    public static final String S_PLATFORM_TYPE_UNKNOWN = "NA";
    public static final String S_PLATFORM_TYPE_AIX = "aix";
    public static final String S_PLATFORM_TYPE_HPUX = "hpux";
    public static final String S_PLATFORM_TYPE_SOLARIS = "solaris";
    public static final String S_PLATFORM_TYPE_LINUX = "linux";
    public static final String S_PLATFORM_TYPE_WINDOWS = "windows";
    public static final String S_PLATFORM_TYPE_OS400 = "os400";
    public static final String S_PLATFORM_TYPE_ZOS = "zos";
    public static final String S_PARAM_LIST_SEPARATOR = ";";
    public static final String S_PPC = "ppc";
    public static final String S_PPC32 = "ppc32";
    public static final String S_PPC64 = "ppc64";
    public static final String S_IA64 = "ia64";
    public static final String S_IA32 = "ia32";
    public static final String S_AMD64 = "x86_64";
    public static final String S_PARISC = "pa-risc";
    public static final String S_S390_32 = "s390_32";
    public static final String S_S390 = "s390";
    public static final String S_S390_64 = "s390_64";
    public static final String S_SPARC = "sparc";
    public static final String S_SPARC64 = "sparc64";
    public static final String S_ARCH_NAME_IA32 = "Intel (32 bit)";
    public static final String S_ARCH_NAME_AMD64 = "AMD (64 bit)";
    public static final String S_ARCH_NAME_PPC32 = "PPC32";
    public static final String S_ARCH_NAME_PPC64 = "PPC64";
    public static final String S_ARCH_NAME_IA64 = "Itanium (64 bit)";
    public static final String S_ARCH_NAME_PARISC = "PARISC (32 bit)";
    public static final String S_ARCH_NAME_SPARC = "SPARC (32 bit)";
    public static final String S_ARCH_NAME_SPARC64 = "SPARC (64 bit)";
    public static final String S_ARCH_NAME_OS400_PPC64 = "System i";
    public static final String S_ARCH_NAME_OS390_32 = "System z (31 bit)";
    public static final String S_ARCH_NAME_OS390_64 = "System z (64 bit)";
    public static final String S_ARCH_NAME_OS390 = "System z";
    public static final String S_LIB_EXT_WINDOWS = ".dll";
    public static final String S_LIB_EXT_AIX_SOLARIS_LINUX_HP64 = ".so";
    public static final String S_LIB_EXT_HP32 = ".sl";
    private static HashMap platformArchNameMap = new HashMap();
    private static final int N_UNDEFINED = -1;
    private static int nPlatformNumber;
    private static final String S_JAVA_OS_PROPERTY = "os.name";
    private static final String S_JAVA_OS_VERSION_PROPERTY = "os.version";
    private static final String S_AIX_PATTERN = "^.*aix.*$";
    private static final String S_HPUX_PATTERN = "^.*hp-ux.*$";
    private static final String S_SOLARIS_PATTERN = "^.*sunos.*$";
    private static final String S_LINUX_PATTERN = "^.*linux.*$";
    private static final String S_WINDOWS_PATTERN = "^.*windows.*$";
    private static final String S_Z_OS_PATTERN = "^.*z/os.*$";
    private static final String S_OS400_PATTERN = "^.*os/400.*$";
    private static final String S_WINDOWS_XP = "windows xp";
    private static final String S_WINDOWS_2000 = "windows 2000";
    private static final String S_WINDOWS_SERVER_2003 = "windows server 2003";
    private static final String S_WINDOWS_VISTA_VERSION = "6.0";
    private static final String[] AS_SHELL_EXEC_WIN;
    private static final String[] AS_SHELL_EXEC_UNIX;
    private static final String[] AS_SHELL_EXEC_OS400;
    private static final String[] AS_EMPTY;
    private static final String S_QUOTE = "\"";
    private static final String S_EMPTY = "";
    private static final String S_DOLLAR = "$";
    private static final String S_PERCENTAGE = "%";
    private static final String S_UNIX_SHELL_VARIABLE_BRACKET_START = "{";
    private static final String S_UNIX_SHELL_VARIABLE_BRACKET_STOP = "}";
    private static final String S_PATTERN_CHECK_IF_STRING_HAS_ANY_SPACES = "^.*\\s.*$";
    private static final char C_QUOTE = '\"';
    private static final char C_SPACE = ' ';
    private static final String S_WINDOWS_FS_PATH_SEPARATOR = "\\";
    private static final String S_UNIX_FS_PATH_SEPARATOR = "/";
    private static final String S_OS400_FS_PATH_SEPARATOR = "/";
    private static final String[] AS_WINOSNAME_VERSION_MAPPING;

    public static String[] getShellExecPrefixForCurrentPlatform() {
        if (WASPlatformConstants.isCurrentPlatformUNIX()) {
            return AS_SHELL_EXEC_UNIX;
        }
        if (WASPlatformConstants.isCurrentPlatformWindows()) {
            return AS_SHELL_EXEC_WIN;
        }
        if (WASPlatformConstants.isCurrentPlatformOS400()) {
            return AS_SHELL_EXEC_OS400;
        }
        return AS_EMPTY;
    }

    public static boolean isCurrentPlatformUNIX() {
        int n = WASPlatformConstants.getCurrentPlatform();
        return n == 1 || n == 2 || n == 3 || n == 4 || n == 6;
    }

    public static boolean isCurrentPlatformAIX() {
        int n = WASPlatformConstants.getCurrentPlatform();
        return n == 1;
    }

    public static boolean isCurrentPlatformHPUnix() {
        int n = WASPlatformConstants.getCurrentPlatform();
        return n == 2;
    }

    public static boolean isCurrentPlatformWindows() {
        return WASPlatformConstants.getCurrentPlatform() == 5;
    }

    public static boolean isCurrentPlatformWindowsVista() {
        String string;
        return WASPlatformConstants.isCurrentPlatformWindows() && (string = System.getProperty(S_JAVA_OS_VERSION_PROPERTY)).trim().startsWith(S_WINDOWS_VISTA_VERSION);
    }

    public static boolean isCurrentPlatformWindowsServer2003() {
        String string;
        return WASPlatformConstants.getCurrentPlatform() == 5 && (string = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase()).indexOf(S_WINDOWS_SERVER_2003) != -1;
    }

    public static boolean isCurrentPlatformWindows2000orXP() {
        if (WASPlatformConstants.getCurrentPlatform() == 5) {
            String string = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
            if (string.indexOf(S_WINDOWS_XP) != -1) {
                return true;
            }
            return string.indexOf(S_WINDOWS_2000) != -1;
        }
        return false;
    }

    public static boolean isCurrentPlatformOS400() {
        int n = WASPlatformConstants.getCurrentPlatform();
        return n == 7;
    }

    public static int getCurrentPlatform() {
        if (nPlatformNumber != -1) {
            return nPlatformNumber;
        }
        String string = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
        if (Pattern.matches(S_AIX_PATTERN, string)) {
            nPlatformNumber = 1;
            return 1;
        }
        if (Pattern.matches(S_HPUX_PATTERN, string)) {
            nPlatformNumber = 2;
            return 2;
        }
        if (Pattern.matches(S_SOLARIS_PATTERN, string)) {
            nPlatformNumber = 3;
            return 3;
        }
        if (Pattern.matches(S_LINUX_PATTERN, string)) {
            nPlatformNumber = 4;
            return 4;
        }
        if (Pattern.matches(S_WINDOWS_PATTERN, string)) {
            nPlatformNumber = 5;
            return 5;
        }
        if (Pattern.matches(S_Z_OS_PATTERN, string)) {
            nPlatformNumber = 6;
            return 6;
        }
        if (Pattern.matches(S_OS400_PATTERN, string)) {
            nPlatformNumber = 7;
            return 7;
        }
        nPlatformNumber = 0;
        return 0;
    }

    public static String getCurrentPlatformCode() {
        String string = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
        if (Pattern.matches(S_AIX_PATTERN, string)) {
            return S_PLATFORM_TYPE_AIX;
        }
        if (Pattern.matches(S_HPUX_PATTERN, string)) {
            return S_PLATFORM_TYPE_HPUX;
        }
        if (Pattern.matches(S_SOLARIS_PATTERN, string)) {
            return S_PLATFORM_TYPE_SOLARIS;
        }
        if (Pattern.matches(S_LINUX_PATTERN, string)) {
            return S_PLATFORM_TYPE_LINUX;
        }
        if (Pattern.matches(S_WINDOWS_PATTERN, string)) {
            return S_PLATFORM_TYPE_WINDOWS;
        }
        if (Pattern.matches(S_Z_OS_PATTERN, string)) {
            return S_PLATFORM_TYPE_ZOS;
        }
        if (Pattern.matches(S_OS400_PATTERN, string)) {
            return S_PLATFORM_TYPE_OS400;
        }
        return S_PLATFORM_TYPE_UNKNOWN;
    }

    public static String convertToShellVariable(String string) {
        if (WASPlatformConstants.isCurrentPlatformUNIX() || WASPlatformConstants.isCurrentPlatformOS400()) {
            return "${" + string + S_UNIX_SHELL_VARIABLE_BRACKET_STOP;
        }
        if (WASPlatformConstants.isCurrentPlatformWindows()) {
            return S_PERCENTAGE + string + S_PERCENTAGE;
        }
        return string;
    }

    public static String convertToShellParam(String string) {
        if (string.matches(S_PATTERN_CHECK_IF_STRING_HAS_ANY_SPACES) && !WASPlatformConstants.isQuoted(string)) {
            String string2 = S_QUOTE + string + S_QUOTE;
            return string2;
        }
        return string;
    }

    public static String getCurrentOSFSPathSeparator() {
        if (WASPlatformConstants.isCurrentPlatformOS400()) {
            return "/";
        }
        if (WASPlatformConstants.isCurrentPlatformUNIX()) {
            return "/";
        }
        if (WASPlatformConstants.isCurrentPlatformWindows()) {
            return S_WINDOWS_FS_PATH_SEPARATOR;
        }
        return "/";
    }

    public static String getWindowsOSName(String string) {
        String[] stringArray = AS_WINOSNAME_VERSION_MAPPING;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].substring(0, stringArray[i].indexOf(S_PARAM_LIST_SEPARATOR));
            String string3 = stringArray[i].substring(stringArray[i].indexOf(S_PARAM_LIST_SEPARATOR) + 1);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return S_EMPTY;
    }

    public static String getOfficialArchNameByOSArchKeyword(String string, String string2) {
        String string3 = (String)platformArchNameMap.get(string + S_PARAM_LIST_SEPARATOR + string2);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static String getArchByXcoffDecoder(String string) throws IOException {
        String string2 = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = fileInputStream.read() & 0xFF;
        int n2 = fileInputStream.read() & 0xFF;
        int n3 = n2 + (n << 8);
        fileInputStream.close();
        switch (n3) {
            case 479: {
                string2 = S_PPC32;
                break;
            }
            case 495: {
                string2 = S_PPC64;
                break;
            }
            case 503: {
                string2 = S_PPC64;
                break;
            }
            default: {
                string2 = null;
            }
        }
        return string2;
    }

    public static String getArchByElfDecoder(String string) throws IOException {
        String string2 = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = fileInputStream.read();
        int n2 = fileInputStream.read();
        int n3 = fileInputStream.read();
        int n4 = fileInputStream.read();
        if (n != 127 || n2 != 69 || n3 != 76 || n4 != 70) {
            // empty if block
        }
        int n5 = fileInputStream.read();
        fileInputStream.skip(13L);
        int n6 = fileInputStream.read();
        if (n6 == 0) {
            n6 = fileInputStream.read();
        }
        fileInputStream.close();
        switch (n6) {
            case 2: {
                string2 = S_SPARC;
                break;
            }
            case 3: {
                string2 = S_IA32;
                break;
            }
            case 15: {
                string2 = S_PARISC;
                break;
            }
            case 20: {
                string2 = S_PPC32;
                break;
            }
            case 21: {
                string2 = S_PPC64;
                break;
            }
            case 43: {
                string2 = S_SPARC64;
                break;
            }
            case 50: {
                string2 = S_IA64;
                break;
            }
            case 62: {
                string2 = S_AMD64;
                break;
            }
            case 22: {
                string2 = S_S390_32;
                if (n5 != 2) break;
                string2 = S_S390_64;
                break;
            }
            default: {
                string2 = null;
            }
        }
        return string2;
    }

    public static String getArchByDllDecoder(String string) throws IOException {
        String string2 = S_EMPTY;
        FileInputStream fileInputStream = new FileInputStream(string);
        fileInputStream.skip(60L);
        int n = fileInputStream.read() & 0xFF;
        int n2 = fileInputStream.read() & 0xFF;
        int n3 = n + (n2 << 8);
        fileInputStream.skip(n3 - 62);
        int n4 = fileInputStream.read();
        int n5 = fileInputStream.read();
        fileInputStream.skip(2L);
        if (n4 != 80 || n5 != 69) {
            return string2;
        }
        int n6 = fileInputStream.read() & 0xFF;
        int n7 = fileInputStream.read() & 0xFF;
        int n8 = n6 + (n7 << 8);
        fileInputStream.close();
        switch (n8) {
            case 332: {
                string2 = S_IA32;
                break;
            }
            case 496: {
                string2 = S_PPC32;
                break;
            }
            case 512: {
                string2 = S_IA64;
                break;
            }
            case 34404: {
                string2 = S_AMD64;
                break;
            }
            default: {
                string2 = null;
            }
        }
        return string2;
    }

    private static boolean isQuoted(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\"') {
                boolean bl2 = bl = !bl;
            }
            if (string.charAt(i) != ' ' || bl) continue;
            return false;
        }
        return true;
    }

    static {
        platformArchNameMap.put("windows;ia32", S_ARCH_NAME_IA32);
        platformArchNameMap.put("windows;x86_64", S_ARCH_NAME_AMD64);
        platformArchNameMap.put("aix;ppc32", S_ARCH_NAME_PPC32);
        platformArchNameMap.put("aix;ppc64", S_ARCH_NAME_PPC64);
        platformArchNameMap.put("hpux;pa-risc", S_ARCH_NAME_PARISC);
        platformArchNameMap.put("hpux;ia64", S_ARCH_NAME_IA64);
        platformArchNameMap.put("solaris;sparc", S_ARCH_NAME_SPARC);
        platformArchNameMap.put("solaris;sparc64", S_ARCH_NAME_SPARC64);
        platformArchNameMap.put("solaris;x86_64", S_ARCH_NAME_AMD64);
        platformArchNameMap.put("os400;ppc64", S_ARCH_NAME_OS400_PPC64);
        platformArchNameMap.put("linux;ia32", S_ARCH_NAME_IA32);
        platformArchNameMap.put("linux;x86_64", S_ARCH_NAME_AMD64);
        platformArchNameMap.put("linux;ppc32", S_ARCH_NAME_PPC32);
        platformArchNameMap.put("linux;ppc64", S_ARCH_NAME_PPC64);
        platformArchNameMap.put("linux;s390_32", S_ARCH_NAME_OS390_32);
        platformArchNameMap.put("linux;s390_64", S_ARCH_NAME_OS390_64);
        platformArchNameMap.put("zos;s390", S_ARCH_NAME_OS390);
        nPlatformNumber = -1;
        AS_SHELL_EXEC_WIN = new String[]{"cmd.exe", "/c"};
        AS_SHELL_EXEC_UNIX = new String[]{"sh", "-c"};
        AS_SHELL_EXEC_OS400 = new String[]{"sh", "-c"};
        AS_EMPTY = new String[0];
        AS_WINOSNAME_VERSION_MAPPING = new String[]{"Windows 2000;5.0", "Windows XP;5.1", "Windows 2003;5.2"};
    }
}

