/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.history;

import com.ibm.websphere.product.VersionInfo;
import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASDirectoryException;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.formatters.HTMLPrintFormatter;
import com.ibm.websphere.product.formatters.PrintFormatter;
import com.ibm.websphere.product.formatters.TextPrintFormatter;
import com.ibm.websphere.product.history.WASHistory;
import com.ibm.websphere.product.history.xml.enumEventResult;
import com.ibm.websphere.product.history.xml.enumEventType;
import com.ibm.websphere.product.history.xml.enumUpdateAction;
import com.ibm.websphere.product.history.xml.enumUpdateType;
import com.ibm.websphere.product.history.xml.eventHistory;
import com.ibm.websphere.product.history.xml.updateEvent;
import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASComponentUpdate;
import com.ibm.websphere.product.metadata.WASMaintenancePackage;
import com.ibm.websphere.product.utils.WASDirectoryHelper;
import com.ibm.websphere.product.utils.WASDirectoryResourceBundleUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class HistoryInfo {
    public static final String pgmVersion = "1.7.1.22";
    public static final String pgmUpdate = "8/9/08";
    public static final String TEXT_MODE = "text";
    public static final String HTML_MODE = "html";
    public static final String DEFAULT_REPORT_MODE = "text";
    protected boolean printStack;
    protected WASProduct wasProduct;
    protected WASHistory wasHistory;
    protected WASDirectory wasDirectory;
    protected boolean exceptionThrown = false;
    protected PrintFormatter formatter;
    String updateId;
    String componentName;
    protected static final int[] tableWidths = new int[]{25, 75};
    private static final String S_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
    private static final String S_BACKUP_FILENAME_NA = "not applicable";
    private static final String S_EMPTY_STRING = "";

    protected static String getDefaultedString(String string, String string2) {
        String string3 = WASDirectoryResourceBundleUtils.getHistoryLocaleString(string);
        if (string3.equals(string)) {
            return string2;
        }
        return string3;
    }

    protected static String getDefaultedString(String string, String string2, Object[] objectArray) {
        String string3 = HistoryInfo.getDefaultedString(string, string2);
        return MessageFormat.format(string3, objectArray);
    }

    protected static String getString(String string) {
        return WASDirectoryResourceBundleUtils.getHistoryLocaleString(string);
    }

    protected static String getString(String string, Object object) {
        return WASDirectoryResourceBundleUtils.getHistoryLocaleString(string, object);
    }

    protected static String getString(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return WASDirectoryResourceBundleUtils.getHistoryLocaleString(string, objectArray);
    }

    protected static String getString(String string, Object[] objectArray) {
        return WASDirectoryResourceBundleUtils.getHistoryLocaleString(string, objectArray);
    }

    public static void printCopyright() {
        System.out.println(HistoryInfo.getDefaultedString("WVER0210I", "WVER0210I: Copyright (c) IBM Corporation 2002, 2008; All rights reserved."));
        System.out.println(HistoryInfo.getDefaultedString("WVER0212I", "WVER0212I: HistoryInfo Reporter Version {0}, Dated {1}", new Object[]{pgmVersion, pgmUpdate}));
        System.out.println();
    }

    public static void main(String[] stringArray) {
        HistoryInfo.main(stringArray, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int main(String[] stringArray, boolean bl) {
        Object object;
        HistoryInfo.printCopyright();
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        String string3 = "text";
        String string4 = null;
        boolean bl5 = false;
        String string5 = null;
        String string6 = null;
        for (int i = 0; !bl2 && i < stringArray.length; ++i) {
            String string7 = stringArray[i];
            if (string7.equalsIgnoreCase("-format")) {
                if (++i < stringArray.length) {
                    string7 = stringArray[i];
                    if (string7.equalsIgnoreCase("text") || string7.equalsIgnoreCase(HTML_MODE)) {
                        string3 = string7;
                        continue;
                    }
                    bl2 = true;
                    string = string7;
                    string2 = "WVER0226E";
                    continue;
                }
                bl2 = true;
                string = string7;
                string2 = "WVER0225E";
                continue;
            }
            if (string7.equalsIgnoreCase("-file")) {
                if (++i < stringArray.length) {
                    string4 = stringArray[i];
                    continue;
                }
                bl2 = true;
                string = string7;
                string2 = "WVER0225E";
                continue;
            }
            if (string7.equalsIgnoreCase("-maintenancePackageId")) {
                if (++i < stringArray.length) {
                    string5 = stringArray[i];
                    continue;
                }
                bl2 = true;
                string = string7;
                string2 = "WVER0225E";
                continue;
            }
            if (string7.equalsIgnoreCase("-component")) {
                if (++i < stringArray.length) {
                    string6 = stringArray[i];
                    continue;
                }
                bl2 = true;
                string = string7;
                string2 = "WVER0225E";
                continue;
            }
            if (string7.equalsIgnoreCase("-help") || string7.equalsIgnoreCase("-?") || string7.equalsIgnoreCase("/?") || string7.equalsIgnoreCase("/help")) {
                bl2 = true;
                bl3 = true;
                continue;
            }
            if (string7.equalsIgnoreCase("-usage")) {
                bl2 = true;
                bl4 = true;
                continue;
            }
            if (string7.equalsIgnoreCase("-printStack")) {
                bl5 = true;
                continue;
            }
            bl2 = true;
            string = string7;
            string2 = "WVER0228E";
        }
        if (bl4) {
            System.out.println(HistoryInfo.getString("WVER0230I"));
            if (!bl) return 0;
            System.exit(0);
            return -1;
        }
        if (bl3) {
            System.out.println(HistoryInfo.getString("WVER0231I"));
            if (!bl) return 0;
            System.exit(0);
            return -1;
        }
        if (string != null) {
            System.out.println(HistoryInfo.getString(string2, string));
            if (!bl) return -1;
            System.exit(-1);
            return -1;
        }
        Throwable throwable = null;
        boolean bl6 = false;
        try {
            object = new HistoryInfo();
            ((HistoryInfo)object).setPrintStack(bl5);
            ((HistoryInfo)object).runReport(string3, string4, string5, string6);
            bl6 = ((HistoryInfo)object).hasExceptionThrown();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throwable = fileNotFoundException;
        }
        catch (IOException iOException) {
            throwable = iOException;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (throwable != null) {
            String string8;
            object = string4 == null ? HistoryInfo.getString("label.standard.out") : string4;
            try {
                String string9 = throwable.getMessage();
                string8 = HistoryInfo.getString("WVER0240E", object, string9);
            }
            catch (Throwable throwable3) {
                string8 = HistoryInfo.getString("WVER0241E", new Object[]{object, throwable.getClass().getName(), throwable3.getClass().getName()});
            }
            System.err.println(string8);
            if (bl5) {
                throwable.printStackTrace();
            }
            if (!bl) return -1;
            System.exit(-1);
            return -1;
        }
        if (bl6) {
            if (!bl) return -1;
            System.exit(-1);
            return -1;
        } else {
            if (!bl) return 0;
            System.exit(0);
        }
        return -1;
    }

    public HistoryInfo() {
        this.setPrintStack(false);
        this.clearSource();
        this.clearFormatter();
        this.clearUpdateId();
        this.clearComponentName();
    }

    protected void setPrintStack(boolean bl) {
        this.printStack = bl;
    }

    protected boolean getPrintStack() {
        return this.printStack;
    }

    protected boolean setSource() {
        this.wasProduct = new WASProduct();
        this.wasHistory = new WASHistory();
        return VersionInfo.handleErrors(this.wasProduct, this.wasHistory, System.err, this.getPrintStack());
    }

    protected WASProduct getProduct() {
        return this.wasProduct;
    }

    protected WASHistory getHistory() {
        return this.wasHistory;
    }

    protected void clearSource() {
        this.wasHistory = null;
        this.wasProduct = null;
        this.wasDirectory = null;
    }

    protected boolean setWASDirectory() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException, WASDirectoryException {
        String string = WASDirectoryHelper.getInstallRootPath();
        if (this.getPrintStack()) {
            WASDirectoryLogger.getWASDirectoryLogger(string, Level.FINEST);
        }
        this.wasDirectory = new WASDirectory();
        return true;
    }

    protected void setFormatter(String string, PrintWriter printWriter) {
        if (string == null || !string.equalsIgnoreCase("text") && !string.equalsIgnoreCase(HTML_MODE)) {
            string = "text";
        }
        this.formatter = string.equalsIgnoreCase(HTML_MODE) ? new HTMLPrintFormatter() : new TextPrintFormatter();
        this.formatter.setPrintWriter(printWriter);
    }

    protected PrintFormatter getFormatter() {
        return this.formatter;
    }

    protected void clearFormatter() {
        this.formatter = null;
    }

    protected void setUpdateId(String string) {
        this.updateId = string;
    }

    protected String getUpdateId() {
        return this.updateId;
    }

    protected void clearUpdateId() {
        this.updateId = null;
    }

    protected void setComponentName(String string) {
        this.componentName = string;
    }

    protected String getComponentName() {
        return this.componentName;
    }

    protected void clearComponentName() {
        this.componentName = null;
    }

    protected boolean eventIsOfInterest(updateEvent updateEvent2) {
        String string = this.getUpdateId();
        String string2 = this.getComponentName();
        if (string != null && !updateEvent2.getId().equals(string)) {
            return false;
        }
        if (string2 != null) {
            boolean bl = false;
            int n = updateEvent2.getUpdateEventCount();
            for (int i = 0; !bl && i < n; ++i) {
                updateEvent updateEvent3 = updateEvent2.getUpdateEvent(i);
                bl = this.componentEventIsOfInterest(updateEvent3);
            }
            if (!bl) {
                return false;
            }
        }
        return true;
    }

    protected boolean componentEventIsOfInterest(updateEvent updateEvent2) {
        String string = this.getComponentName();
        boolean bl = string == null || updateEvent2.getId().equals(string);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String string, String string2, String string3, String string4) throws FileNotFoundException, IOException {
        if (string2 == null) {
            this.runReport(string, System.out, string3, string4);
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            try {
                this.runReport(string, fileOutputStream, string3, string4);
            }
            finally {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String string, OutputStream outputStream, String string2, String string3) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        try {
            this.runReport(string, printWriter, string2, string3);
        }
        finally {
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String string, PrintWriter printWriter, String string2, String string3) {
        this.setFormatter(string, printWriter);
        this.setUpdateId(string2);
        this.setComponentName(string3);
        try {
            if (this.setWASDirectory() && this.setSource()) {
                this.printReport();
            }
        }
        catch (Exception exception) {
            this.exceptionThrown = true;
            printWriter.close();
            this.printException(exception, System.err, this.getPrintStack());
        }
        finally {
            this.clearSource();
            this.clearComponentName();
            this.clearUpdateId();
            this.clearFormatter();
        }
    }

    protected boolean hasExceptionThrown() {
        return this.exceptionThrown;
    }

    protected void printReport() throws Exception {
        PrintFormatter printFormatter = this.getFormatter();
        String string = this.getUpdateId();
        String string2 = this.getComponentName();
        String string3 = string == null && string2 == null ? HistoryInfo.getString("report.header") : (string == null ? HistoryInfo.getString("report.header.component", string2) : (string2 == null ? HistoryInfo.getString("report.header.update", string) : HistoryInfo.getString("report.header.update.component", string, string2)));
        printFormatter.printHeader(string3);
        this.printTimeStamp();
        this.printSource();
        int n = this.printHistory(this.wasDirectory.getHistoryMaintenancePackageList());
        if (n == 0) {
            printFormatter.println(S_EMPTY_STRING);
            String string4 = string == null && string2 == null ? HistoryInfo.getString("warning.no.events") : (string == null ? HistoryInfo.getString("warning.no.events.for.component", string2) : (string2 == null ? HistoryInfo.getString("warning.no.events.for.update", string) : HistoryInfo.getString("warning.no.events.for.update.component", string, string2)));
            printFormatter.println(string4, true);
        }
        printFormatter.blankLine();
        printFormatter.printFooter(HistoryInfo.getString("report.footer"));
    }

    protected void printTimeStamp() {
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(HistoryInfo.getString("info.report.on", this.getTimeStamp()));
    }

    protected String getTimeStamp() {
        Date date = new Date(System.currentTimeMillis());
        return DateFormat.getDateTimeInstance(1, 1).format(date);
    }

    protected String unsub(String string, String string2, String string3) {
        int n = string2.indexOf(string);
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n) + string3 + string2.substring(n + string.length());
    }

    protected void printSource() {
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(HistoryInfo.getString("info.source"), true);
        printFormatter.separator();
        String string = this.wasDirectory.getWasLocation();
        String string2 = WASDirectoryHelper.getVersionDirPath(string);
        String string3 = WASDirectoryHelper.getHistoryDirPath(string);
        String string4 = WASDirectoryHelper.getDTDDirPath(string);
        String string5 = WASDirectoryHelper.getLogDirPath(string);
        String string6 = WASDirectoryHelper.getBackupDirPath(string);
        String string7 = WASDirectoryHelper.getTmpDirPath();
        Vector<String[]> vector = new Vector<String[]>();
        vector.add(new String[]{HistoryInfo.getString("label.product.dir"), string});
        vector.add(new String[]{HistoryInfo.getString("label.version.dir"), string2});
        vector.add(new String[]{HistoryInfo.getString("label.version.dtd.dir"), string4});
        vector.add(new String[]{HistoryInfo.getString("label.version.log.dir"), string5});
        File file = new File(string6);
        if (file.exists()) {
            vector.add(new String[]{HistoryInfo.getString("label.version.backup.dir"), string6});
        }
        vector.add(new String[]{HistoryInfo.getString("label.version.tmp.dir"), string7});
        vector.add(new String[]{HistoryInfo.getString("label.version.history.dir"), string3});
        int[] nArray = new int[]{25, 75};
        printFormatter.printTable(nArray, vector, 0);
    }

    protected int printHistory(eventHistory eventHistory2) {
        int n = 0;
        int n2 = eventHistory2.getUpdateEventCount();
        for (int i = 0; i < n2; ++i) {
            updateEvent updateEvent2 = eventHistory2.getUpdateEvent(i);
            if (!this.eventIsOfInterest(updateEvent2)) continue;
            this.printEvent(updateEvent2);
            ++n;
        }
        return n;
    }

    protected String consumeNull(String string) {
        return string == null ? S_EMPTY_STRING : string;
    }

    protected void printEvent(updateEvent updateEvent2) {
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.println(S_EMPTY_STRING);
        printFormatter.println(HistoryInfo.getString("info.event"), true);
        printFormatter.separator();
        Vector vector = new Vector();
        String string = this.fillEventFields(updateEvent2, vector);
        printFormatter.printTable(tableWidths, vector, 0);
        this.printComponentEvents(string, updateEvent2);
    }

    protected void printComponentEvents(String string, updateEvent updateEvent2) {
        int n = updateEvent2.getUpdateEventCount();
        for (int i = 0; i < n; ++i) {
            updateEvent updateEvent3 = updateEvent2.getUpdateEvent(i);
            if (!this.componentEventIsOfInterest(updateEvent3)) continue;
            this.printComponentEvent(string, updateEvent3);
        }
    }

    protected void printComponentEvent(String string, updateEvent updateEvent2) {
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(HistoryInfo.getString("info.component.event"), 1, true);
        printFormatter.separator(1);
        Vector vector = new Vector();
        this.fillComponentEventFields(string, updateEvent2, vector);
        printFormatter.printTable(tableWidths, vector, 1);
    }

    protected String fillEventFields(updateEvent updateEvent2, Vector vector) {
        String string = this.getEventIdPrefix(updateEvent2);
        vector.add(new Object[]{string, updateEvent2.getId()});
        vector.add(new String[]{HistoryInfo.getString("label.action"), this.getEventActionText(updateEvent2)});
        vector.add(new String[]{HistoryInfo.getString("label.primary.content"), updateEvent2.getPrimaryContent()});
        if (!updateEvent2.getLogName().equalsIgnoreCase(S_EMPTY_STRING)) {
            vector.add(new String[]{HistoryInfo.getString("label.log.file.name"), updateEvent2.getLogName()});
        }
        if (updateEvent2.getBackupName().equalsIgnoreCase(S_BACKUP_FILENAME_NA)) {
            vector.add(new String[]{HistoryInfo.getString("label.backup.file.name"), HistoryInfo.getString("label.backup.file.name.notapplicable")});
        } else if (!updateEvent2.getBackupName().equalsIgnoreCase(S_EMPTY_STRING)) {
            vector.add(new String[]{HistoryInfo.getString("label.backup.file.name"), updateEvent2.getBackupName()});
        }
        vector.add(new String[]{HistoryInfo.getString("label.start.time.stamp"), updateEvent2.getStartTimeStamp()});
        vector.add(new String[]{HistoryInfo.getString("label.result"), this.getEventResultText(updateEvent2)});
        String string2 = updateEvent2.getResultMessage();
        if (string2 == null) {
            string2 = S_EMPTY_STRING;
        }
        return string;
    }

    protected void fillComponentEventFields(String string, updateEvent updateEvent2, Vector vector) {
        vector.add(new Object[]{string, updateEvent2.getParentId()});
        vector.add(new String[]{HistoryInfo.getString("label.component.name"), updateEvent2.getId()});
        vector.add(new String[]{HistoryInfo.getString("label.action"), this.getEventActionText(updateEvent2)});
        vector.add(new Object[]{HistoryInfo.getString("label.update.type"), this.getUpdateTypeText(updateEvent2)});
        vector.add(new String[]{HistoryInfo.getString("label.start.time.stamp"), updateEvent2.getStartTimeStamp()});
        vector.add(new String[]{HistoryInfo.getString("label.result"), this.getEventResultText(updateEvent2)});
    }

    protected String getEventIdPrefix(updateEvent updateEvent2) {
        enumEventType enumEventType2 = updateEvent2.getEventTypeAsEnum();
        String string = enumEventType2 == enumEventType.EFIX_EVENT_TYPE ? "label.efix.id" : (enumEventType2 == enumEventType.PTF_EVENT_TYPE ? "label.ptf.id" : "label.unknown.id");
        return HistoryInfo.getString(string);
    }

    protected String booleanText(boolean bl) {
        return HistoryInfo.getString(bl ? "label.true" : "label.false");
    }

    protected String getEventActionText(updateEvent updateEvent2) {
        enumUpdateAction enumUpdateAction2 = updateEvent2.getUpdateActionAsEnum();
        String string = enumUpdateAction2 == enumUpdateAction.INSTALL_UPDATE_ACTION ? "label.install.action" : (enumUpdateAction2 == enumUpdateAction.UNINSTALL_UPDATE_ACTION ? "label.uninstall.action" : (enumUpdateAction2 == enumUpdateAction.SELECTIVE_INSTALL_UPDATE_ACTION ? "label.selective.install.action" : (enumUpdateAction2 == enumUpdateAction.SELECTIVE_UNINSTALL_UPDATE_ACTION ? "label.selective.uninstall.action" : "label.unknown.action")));
        String string2 = HistoryInfo.getString(string);
        return string2;
    }

    protected String getUpdateTypeText(updateEvent updateEvent2) {
        enumUpdateType enumUpdateType2 = updateEvent2.getUpdateTypeAsEnum();
        String string = enumUpdateType2 == enumUpdateType.ADD_UPDATE_TYPE ? "label.update.add.tag" : (enumUpdateType2 == enumUpdateType.REPLACE_UPDATE_TYPE ? "label.update.replace.tag" : (enumUpdateType2 == enumUpdateType.REMOVE_UPDATE_TYPE ? "label.update.remove.tag" : (enumUpdateType2 == enumUpdateType.PATCH_UPDATE_TYPE ? "label.update.patch.tag" : (enumUpdateType2 == enumUpdateType.COMPOSITE_UPDATE_TYPE ? "label.update.composite.tag" : "label.update.unknown.tag"))));
        return HistoryInfo.getString(string);
    }

    protected String getEventResultText(updateEvent updateEvent2) {
        enumEventResult enumEventResult2 = updateEvent2.getResultAsEnum();
        String string = enumEventResult2 == enumEventResult.SUCCEEDED_EVENT_RESULT ? "label.result.succeeded.tag" : (enumEventResult2 == enumEventResult.FAILED_EVENT_RESULT ? "label.result.failed.tag" : (enumEventResult2 == enumEventResult.CANCELLED_EVENT_RESULT ? "label.result.cancelled.tag" : (enumEventResult2 == enumEventResult.PARTIALSUCCESS_EVENT_RESULT ? "label.result.partialSuccess.tag" : "label.result.unknown.tag")));
        return HistoryInfo.getString(string);
    }

    protected String getActionText(String string) {
        String string2 = "install".equals(string) ? "label.install.action" : ("uninstall".equals(string) ? "label.uninstall.action" : "label.unknown.action");
        return HistoryInfo.getString(string2);
    }

    protected String getResultText(String string) {
        String string2 = "success".equals(string) ? "label.result.succeeded.tag" : ("failure".equals(string) ? "label.result.failed.tag" : ("partialSuccess".equals(string) ? "label.result.partialSuccess.tag" : "label.result.unknown.tag"));
        return HistoryInfo.getString(string2);
    }

    protected String getUpdateEffectText(String string) {
        String string2 = "replace".equals(string) ? "label.update.replace.tag" : "label.update.unknown.tag";
        return HistoryInfo.getString(string2);
    }

    protected void printException(Exception exception, PrintStream printStream, boolean bl) {
        String string;
        if (!exception.getClass().getName().equals(WASDirectoryException.class.getName())) {
            string = HistoryInfo.getString("WVER0242E");
            printStream.println(string);
        }
        string = exception.getMessage();
        printStream.println(string);
        if (bl) {
            exception.printStackTrace(printStream);
        }
    }

    protected int printHistory(WASMaintenancePackage[] wASMaintenancePackageArray) {
        int n = 0;
        String string = this.getUpdateId();
        for (int i = 0; i < wASMaintenancePackageArray.length; ++i) {
            String string2 = wASMaintenancePackageArray[i].getMaintenancePackageID();
            if (string != null && !string.equals(string2)) continue;
            this.printInstallationEvent(wASMaintenancePackageArray[i]);
            ++n;
        }
        return n;
    }

    protected void printInstallationEvent(WASMaintenancePackage wASMaintenancePackage) {
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.println(S_EMPTY_STRING);
        printFormatter.println(HistoryInfo.getString("info.event"), true);
        printFormatter.separator();
        Vector<Object[]> vector = new Vector<Object[]>();
        vector.add(new Object[]{HistoryInfo.getString("label.ptf.id"), wASMaintenancePackage.getMaintenancePackageID()});
        vector.add(new String[]{HistoryInfo.getString("label.action"), this.getActionText(wASMaintenancePackage.getAction())});
        vector.add(new String[]{HistoryInfo.getString("label.primary.content"), wASMaintenancePackage.getPackageFileName()});
        if (!S_EMPTY_STRING.equalsIgnoreCase(wASMaintenancePackage.getLogFileName())) {
            vector.add(new String[]{HistoryInfo.getString("label.log.file.name"), wASMaintenancePackage.getLogFileName()});
        }
        if (!S_EMPTY_STRING.equalsIgnoreCase(wASMaintenancePackage.getBackupFileName())) {
            vector.add(new String[]{HistoryInfo.getString("label.backup.file.name"), wASMaintenancePackage.getBackupFileName()});
        }
        vector.add(new String[]{HistoryInfo.getString("label.start.time.stamp"), wASMaintenancePackage.getTimestamp()});
        vector.add(new String[]{HistoryInfo.getString("label.result"), this.getResultText(wASMaintenancePackage.getResult())});
        printFormatter.printTable(tableWidths, vector, 0);
        this.printComponentInstallationEvents(wASMaintenancePackage.getComponentUpdateList());
    }

    protected void printComponentInstallationEvents(WASComponentUpdate[] wASComponentUpdateArray) {
        String string = this.getComponentName();
        for (int i = 0; i < wASComponentUpdateArray.length; ++i) {
            String string2 = wASComponentUpdateArray[i].getComponentName();
            if (string != null && !string.equals(string2)) continue;
            this.printComponentInstallationEvent(wASComponentUpdateArray[i]);
        }
    }

    protected void printComponentInstallationEvent(WASComponentUpdate wASComponentUpdate) {
        PrintFormatter printFormatter = this.getFormatter();
        printFormatter.blankLine();
        printFormatter.println(HistoryInfo.getString("info.component.event"), 1, true);
        printFormatter.separator(1);
        Vector<Object[]> vector = new Vector<Object[]>();
        vector.add(new Object[]{HistoryInfo.getString("label.ptf.id"), wASComponentUpdate.getMaintenancePackageID()});
        vector.add(new String[]{HistoryInfo.getString("label.component.name"), wASComponentUpdate.getComponentName()});
        vector.add(new String[]{HistoryInfo.getString("label.action"), this.getActionText(wASComponentUpdate.getAction())});
        vector.add(new Object[]{HistoryInfo.getString("label.update.type"), this.getUpdateEffectText(wASComponentUpdate.getUpdateEffect())});
        vector.add(new String[]{HistoryInfo.getString("label.start.time.stamp"), wASComponentUpdate.getTimestamp()});
        vector.add(new String[]{HistoryInfo.getString("label.result"), this.getResultText(wASComponentUpdate.getResult())});
        printFormatter.printTable(tableWidths, vector, 1);
    }
}

