/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.wizards;

import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.internal.views.AbstractCicWizardView;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;

public abstract class CustomMessageWizardPage
extends WizardPage {
    private final Map currentPageErrors = new HashMap();
    private final Map currentPageWarnings = new HashMap();
    private boolean isInitializingPage = false;

    protected CustomMessageWizardPage(String pageName) {
        super(pageName);
    }

    protected CustomMessageWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected void setWarningState(WarningId warningId, String text) {
        boolean messageUpdated = this.setWarningMessage(warningId, text);
        if (messageUpdated) {
            this.getContainer().updateButtons();
        }
    }

    protected void setWarningStateWithStatus(WarningId warningId, IStatus status) {
        boolean messageUpdated = this.setWarningMessageWithStatus(warningId, status);
        if (messageUpdated) {
            this.getContainer().updateButtons();
        }
    }

    protected boolean setWarningMessage(WarningId warningId, String text) {
        if (text == null) {
            return this.setWarningMessageWithStatus(warningId, null);
        }
        return this.setWarningMessageWithStatus(warningId, (IStatus)Statuses.WARNING.get(text, new Object[0]));
    }

    protected boolean setWarningMessageWithStatus(WarningId warningId, IStatus status) {
        if (this.isInitializingPage) {
            return false;
        }
        boolean needsUpdate = false;
        if (status == null) {
            needsUpdate = this.currentPageWarnings.remove(warningId) != null;
        } else {
            IStatus oldVal = this.currentPageWarnings.put(warningId, status);
            boolean bl = oldVal == null ? true : (needsUpdate = !oldVal.equals(status));
        }
        if (needsUpdate) {
            StringBuffer sb = null;
            boolean needShowDetails = false;
            IStatus displayStatus = null;
            for (Object object : this.currentPageWarnings.values()) {
                if (sb == null) {
                    sb = new StringBuffer();
                } else {
                    sb.append(LogUtil.NEWLINE);
                }
                if (!(object instanceof IStatus)) continue;
                IStatus checkingStatus = (IStatus)object;
                if (CommonSharedUIUtils.shouldShowViewDetails((IStatus)checkingStatus)) {
                    needShowDetails = true;
                    displayStatus = checkingStatus;
                }
                sb.append(checkingStatus.getMessage());
            }
            if (sb == null) {
                this.clearMessageStatus(false);
                this.setMessage(null);
            } else if (!needShowDetails) {
                this.clearMessageStatus(false);
                this.setMessage(sb.toString(), 2);
            } else {
                String msg = String.valueOf(sb.toString()) + " " + Messages.ViewTitlePart_viewDetail;
                this.setMessage(msg, 2);
                AbstractCicWizardView view = (AbstractCicWizardView)this.getContainer();
                if (this.currentPageWarnings.size() == 1 && displayStatus != null) {
                    view.updateWarningMessageStatus(displayStatus);
                } else {
                    CicMultiStatus showStatus = Statuses.ST.createMultiStatus();
                    showStatus.setMessage(sb.toString());
                    for (Object object : this.currentPageWarnings.values()) {
                        if (!(object instanceof IStatus)) continue;
                        showStatus.add((IStatus)object);
                    }
                    view.updateWarningMessageStatus(displayStatus);
                }
            }
        }
        return needsUpdate;
    }

    protected void setErrorStateWithStatus(ErrorId error, IStatus status) {
        if (this.isInitializingPage) {
            return;
        }
        boolean needsUpdate = false;
        if (status == null) {
            needsUpdate = this.currentPageErrors.remove(error) != null;
        } else {
            IStatus oldVal = this.currentPageErrors.put(error, status);
            boolean bl = oldVal == null ? true : (needsUpdate = !oldVal.equals(status));
        }
        if (needsUpdate) {
            StringBuffer sb = null;
            boolean needShowDetails = false;
            IStatus displayStatus = null;
            for (Object object : this.currentPageErrors.values()) {
                if (sb == null) {
                    sb = new StringBuffer();
                } else {
                    sb.append(LogUtil.NEWLINE);
                }
                if (!(object instanceof IStatus)) continue;
                IStatus checkingStatus = (IStatus)object;
                if (CommonSharedUIUtils.shouldShowViewDetails((IStatus)checkingStatus)) {
                    needShowDetails = true;
                    displayStatus = checkingStatus;
                }
                sb.append(checkingStatus.getMessage());
            }
            if (sb == null) {
                this.clearMessageStatus(true);
                this.setErrorMessage(null);
            } else if (!needShowDetails) {
                this.clearMessageStatus(true);
                this.setErrorMessage(sb.toString());
            } else {
                String msg = String.valueOf(sb.toString()) + " " + Messages.ViewTitlePart_viewDetail;
                this.setErrorMessage(msg);
                AbstractCicWizardView view = (AbstractCicWizardView)this.getContainer();
                if (this.currentPageErrors.size() == 1 && displayStatus != null) {
                    view.updateErrorMessageStatus(displayStatus);
                } else {
                    CicMultiStatus showStatus = Statuses.ST.createMultiStatus();
                    showStatus.setMessage(sb.toString());
                    for (Object object : this.currentPageErrors.values()) {
                        if (!(object instanceof IStatus)) continue;
                        showStatus.add((IStatus)object);
                    }
                    view.updateErrorMessageStatus(displayStatus);
                }
            }
            this.getContainer().updateButtons();
        }
    }

    protected void setErrorState(ErrorId error, String text) {
        if (text == null) {
            this.setErrorStateWithStatus(error, null);
        } else {
            this.setErrorStateWithStatus(error, (IStatus)Statuses.ERROR.get(text, new Object[0]));
        }
    }

    public boolean hasErrors() {
        return !this.currentPageErrors.isEmpty();
    }

    protected void reportErrorOnPage(IStatus status, ErrorId errorId, WarningId warningId) {
        if (status.getSeverity() >= 2) {
            if (status.getChildren().length > 0 || status.getSeverity() == 2) {
                WrapDetailUIDErrorDialog errorDialog = new WrapDetailUIDErrorDialog(this.getShell(), this.getDialogTitleBasedOnStatus(status), null, status, 15);
                errorDialog.open();
            }
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                this.setErrorStateWithStatus(errorId, status);
                this.setWarningState(warningId, null);
            } else {
                this.setErrorState(errorId, null);
                this.setWarningMessageWithStatus(warningId, status);
            }
        } else {
            this.setErrorState(errorId, null);
            this.setWarningState(warningId, null);
        }
    }

    private String getDialogTitleBasedOnStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            return Messages.DialogTitle_Error;
        }
        if (status.getSeverity() == 2) {
            return Messages.DialogTitle_Warning;
        }
        if (status.getSeverity() == 8) {
            return Messages.DialogTitle_Cancel;
        }
        return Messages.DialogTitle_Info;
    }

    private int getDialogMessageType(IStatus status) {
        if (status.getSeverity() == 4) {
            return 3;
        }
        if (status.getSeverity() == 2) {
            return 2;
        }
        if (status.getSeverity() == 1) {
            return 1;
        }
        return 0;
    }

    protected void setInitializingPage(boolean value) {
        this.isInitializingPage = value;
    }

    protected boolean isInitializingPage() {
        return this.isInitializingPage;
    }

    public void setErrorMessageWithStatus(IStatus status) {
        if (status == null) {
            this.clearMessageStatus(true);
            this.setErrorMessage(null);
            return;
        }
        String msg = status.getMessage();
        AbstractCicWizardView view = (AbstractCicWizardView)this.getContainer();
        if (CommonSharedUIUtils.shouldShowViewDetails((IStatus)status)) {
            msg = String.valueOf(msg) + " " + Messages.ViewTitlePart_viewDetail;
            view.updateErrorMessageStatus(status);
        } else {
            view.updateErrorMessageStatus(null);
        }
        this.setErrorMessage(msg);
    }

    public void setMessageWithStatus(IStatus status) {
        if (status == null) {
            this.clearMessageStatus(false);
            this.setMessage(null);
            return;
        }
        String msg = status.getMessage();
        AbstractCicWizardView view = (AbstractCicWizardView)this.getContainer();
        if (CommonSharedUIUtils.shouldShowViewDetails((IStatus)status)) {
            msg = String.valueOf(msg) + " " + Messages.ViewTitlePart_viewDetail;
            view.updateWarningMessageStatus(status);
        } else {
            view.updateWarningMessageStatus(null);
        }
        this.setMessage(msg, this.getDialogMessageType(status));
    }

    public void clearMessageStatus(boolean isError) {
        AbstractCicWizardView view = (AbstractCicWizardView)this.getContainer();
        if (isError) {
            view.updateErrorMessageStatus(null);
        } else {
            view.updateWarningMessageStatus(null);
        }
    }

    protected static class ErrorId {
    }

    protected static class WarningId {
    }
}

