/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.views;

import com.ibm.cic.common.ui.internal.AbstractCICLabelProvider;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUILabelProvider;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.parts.ImageDesHyperlink;
import com.ibm.cic.common.ui.internal.views.BackgroundHandler;
import com.ibm.cic.common.ui.internal.wizardry.IHelpRefPage;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.IViewDescriptor;

public abstract class AbstractQSView
extends ViewPart
implements IHyperlinkListener,
IHelpRefPage {
    private Composite top;
    private Font niceFont;
    protected BackgroundFixer backgroundFixer;
    private Color niceColor;
    private String helpRef;
    private CommonUILabelProvider commonUILabelProvider;

    protected abstract AbstractCICLabelProvider getImageCache();

    public final void createPartControl(Composite parent) {
        DisplayKeeper.INSTANCE.getDisplay().getSystemImage(2);
        FontData[] systemFont = parent.getFont().getFontData();
        systemFont[0].setHeight(systemFont[0].getHeight() + 5);
        FontData[] fontDataArray = systemFont;
        int n = systemFont.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            element.setStyle(element.getStyle() | 1);
            ++n2;
        }
        this.niceFont = new Font((Device)DisplayKeeper.INSTANCE.getDisplay(), systemFont);
        this.niceColor = new Color((Device)DisplayKeeper.INSTANCE.getDisplay(), 255, 255, 255);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractQSView.this.niceFont != null) {
                    AbstractQSView.this.niceFont.dispose();
                    AbstractQSView.this.niceFont = null;
                }
                if (AbstractQSView.this.niceColor != null) {
                    AbstractQSView.this.niceColor.dispose();
                    AbstractQSView.this.niceColor = null;
                }
                if (AbstractQSView.this.commonUILabelProvider != null) {
                    AbstractQSView.this.commonUILabelProvider.disconnect(this);
                }
            }
        });
        ScrolledComposite scroller = new ScrolledComposite(parent, 768);
        scroller.setAlwaysShowScrollBars(false);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        this.commonUILabelProvider = CicCommonUiPlugin.getDefault().getLabelProvider();
        this.commonUILabelProvider.connect(this);
        this.top = new Composite((Composite)scroller, 0);
        scroller.setContent((Control)this.top);
        this.top.setLayout((Layout)new GridLayout());
        this.top.setLayoutData((Object)new GridData(4, 4, true, true));
        if (CommonUIUtils.runningBiDiLocale()) {
            Label productTitle = new Label(this.top, 0);
            ImageDescriptor productTitleID = this.getProductTitleImage();
            if (productTitleID != null) {
                productTitle.setImage(this.commonUILabelProvider.get(productTitleID));
            }
            GridData productTitleData = new GridData();
            productTitleData.horizontalAlignment = 1;
            productTitleData.verticalAlignment = 1;
            productTitle.setLayoutData((Object)productTitleData);
        }
        Composite center = new Composite(this.top, 0);
        center.setLayout((Layout)new GridLayout());
        GridData centerGridData = new GridData(0x1000000, 0x1000000, true, true);
        centerGridData.verticalIndent = 20;
        center.setLayoutData((Object)centerGridData);
        this.configureBackgroundControl(this.top);
        this.createImagesAndText(center);
        this.top.setBackgroundMode(1);
        scroller.setMinSize(scroller.computeSize(-1, -1));
        Label ibmLogo = new Label(this.top, 0);
        ibmLogo.setImage(this.commonUILabelProvider.get(CommonImages.WELCOME_IBM_LOGO));
        GridData data = new GridData();
        data.horizontalAlignment = 1;
        data.verticalAlignment = 3;
        ibmLogo.setLayoutData((Object)data);
        if (!DisplayKeeper.INSTANCE.getDisplay().getHighContrast() && CommonUIUtils.isWindowsServer2003()) {
            this.backgroundFixer = new BackgroundFixer(this.top);
        }
    }

    protected void configureBackgroundControl(Composite parent) {
        new BackgroundHandler(parent, this.getBackgroundImageDescriptor(), null);
    }

    protected ImageDescriptor getBackgroundImageDescriptor() {
        return CommonImages.WELCOME_BG_BIDI;
    }

    protected ImageDescriptor getBackgroundLowerRightImageDescriptor() {
        return null;
    }

    protected ImageDescriptor getProductTitleImage() {
        return null;
    }

    protected abstract void createImagesAndText(Composite var1);

    protected final void createImageAndText(Composite parent, ImageDescriptor descr, ImageDescriptor hoverDescr, String label, Font font, IAction actionToRun, Color linkColor, String description, Color descriptionColor) {
        ImageDesHyperlink link = new ImageDesHyperlink(parent, 0x1000040);
        link.setText(label);
        link.setImage(this.getImageCache().get(descr));
        if (hoverDescr != null) {
            link.setHoverImage(this.getImageCache().get(hoverDescr));
        }
        if (actionToRun != null) {
            link.setToolTipText(actionToRun.getToolTipText());
            link.addHyperlinkListener(this);
            link.setHref(actionToRun);
        }
        link.setFont(font);
        link.setForeground(linkColor);
        link.setDescription(description);
        link.setDescriptionFont(parent.getFont());
        link.setDescriptionColor(descriptionColor);
        GridData data = new GridData(4, 0, true, false);
        data.widthHint = 300;
        link.setLayoutData(data);
    }

    protected final void createImageAndText(Composite parent, ImageDescriptor descr, ImageDescriptor hoverDescr, String label, Font font, IAction actionToRun, Color linkColor) {
        ImageHyperlink link = new ImageHyperlink(parent, 0);
        link.setText(label);
        link.setImage(this.getImageCache().get(descr));
        if (hoverDescr != null) {
            link.setHoverImage(this.getImageCache().get(hoverDescr));
        }
        if (actionToRun != null) {
            link.setToolTipText(actionToRun.getToolTipText());
            link.addHyperlinkListener((IHyperlinkListener)this);
            link.setHref((Object)actionToRun);
        }
        link.setFont(font);
        link.setForeground(linkColor);
    }

    protected final void createImageAndText(Composite parent, ImageDescriptor descr, String string, IAction actionToRun) {
        this.createImageAndText(parent, descr, null, string, this.niceFont, actionToRun, this.niceColor);
    }

    protected final void createImageAndText(Composite parent, ImageDescriptor descr, ImageDescriptor hoverDescr, String string, IAction actionToRun) {
        this.createImageAndText(parent, descr, hoverDescr, string, this.niceFont, actionToRun, this.niceColor);
    }

    protected final void createImageAndText(Composite parent, ImageDescriptor descr, ImageDescriptor hoverDescr, String string, IAction actionToRun, String description) {
        this.createImageAndText(parent, descr, hoverDescr, string, this.niceFont, actionToRun, this.niceColor, description, this.niceColor);
    }

    protected final void createImageAndText(Composite parent, ImageDescriptor descr, String string, IAction actionToRun, Color linkColor) {
        this.createImageAndText(parent, descr, null, string, this.niceFont, actionToRun, linkColor);
    }

    protected final void createImageAndText(Composite parent, ImageDescriptor descr, ImageDescriptor hoverDescr, String string, IAction actionToRun, Color linkColor) {
        this.createImageAndText(parent, descr, hoverDescr, string, this.niceFont, actionToRun, linkColor);
    }

    protected final void createImageAndText(Composite parent, ImageDescriptor descr, ImageDescriptor hoverDescr, String string, IAction actionToRun, Color linkColor, String description, Color desColor) {
        this.createImageAndText(parent, descr, hoverDescr, string, this.niceFont, actionToRun, linkColor, description, desColor);
    }

    protected abstract void logException(Exception var1);

    public void setFocus() {
        this.resetSetHelp();
        this.top.setFocus();
    }

    private void resetSetHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getSite().getShell(), this.getHelpRef());
    }

    static final IViewDescriptor getViewDescriptor(String id) {
        return PlatformUI.getWorkbench().getViewRegistry().find(id);
    }

    public Font getFont() {
        return this.niceFont;
    }

    public void linkActivated(HyperlinkEvent e) {
        IAction action = (IAction)e.getHref();
        action.run();
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    public void setHelpRef(String helpRef) {
        this.helpRef = helpRef;
    }

    @Override
    public String getHelpRef() {
        return this.helpRef;
    }

    protected static class BackgroundFixer
    implements Listener {
        private static final String LASTBOUNDS = "LASTBOUNDS";
        private final Composite root;
        private final Set inUseImages = new HashSet();
        private final Set disposableImages = new HashSet();
        private boolean modeRecovered;
        private final GC rootImageGC;

        public BackgroundFixer(Composite parent) {
            this.root = parent;
            this.rootImageGC = new GC((Drawable)parent);
            this.hookListener((Control)this.root);
        }

        private void hookListener(Control control) {
            control.addListener(9, (Listener)this);
            control.addListener(12, (Listener)this);
            if (control instanceof Composite) {
                Control[] children;
                Control[] controlArray = children = ((Composite)control).getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control element = controlArray[n2];
                    this.hookListener(element);
                    ++n2;
                }
            }
        }

        public void hookListener(Control[] control) {
            Control[] controlArray = control;
            int n = control.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                this.hookListener(element);
                ++n2;
            }
        }

        private void releaseListener(Control control) {
            control.removeListener(9, (Listener)this);
            control.removeListener(12, (Listener)this);
            if (control instanceof Composite) {
                Control[] children;
                Control[] controlArray = children = ((Composite)control).getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control element = controlArray[n2];
                    this.releaseListener(element);
                    ++n2;
                }
            }
        }

        public void releaseListener(Control[] control) {
            Control[] controlArray = control;
            int n = control.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                this.releaseListener(element);
                ++n2;
            }
        }

        public void handleEvent(Event event) {
            if (event.type == 9) {
                final Control control = (Control)event.widget;
                Rectangle lastBounds = (Rectangle)control.getData(LASTBOUNDS);
                Rectangle imageSection = DisplayKeeper.INSTANCE.getDisplay().map(control, (Control)this.root, new Rectangle(0, 0, control.getSize().x, control.getSize().y));
                if (imageSection.equals((Object)lastBounds)) {
                    return;
                }
                for (Image image : this.disposableImages) {
                    image.dispose();
                }
                this.disposableImages.clear();
                control.setData(LASTBOUNDS, (Object)imageSection);
                final Image childImage = new Image((Device)DisplayKeeper.INSTANCE.getDisplay(), imageSection.width, imageSection.height);
                this.rootImageGC.drawImage(childImage, imageSection.x, imageSection.y);
                Image oldImage = control.getBackgroundImage();
                if (this.inUseImages.remove(oldImage)) {
                    this.disposableImages.add(oldImage);
                }
                this.inUseImages.add(childImage);
                if (!this.modeRecovered) {
                    DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!BackgroundFixer.this.modeRecovered) {
                                int rootImageMode = BackgroundFixer.this.root.getBackgroundMode();
                                BackgroundFixer.this.root.setBackgroundMode(0);
                                BackgroundFixer.this.root.setBackgroundMode(rootImageMode);
                                BackgroundFixer.this.modeRecovered = true;
                            }
                            control.setBackgroundImage(childImage);
                        }
                    });
                } else {
                    control.setBackgroundImage(childImage);
                }
            } else if (event.type == 12) {
                for (Image image : this.inUseImages) {
                    image.dispose();
                }
                for (Image image : this.disposableImages) {
                    image.dispose();
                }
                this.rootImageGC.dispose();
            }
        }
    }
}

