/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.views;

import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.internal.PixelConverter;
import com.ibm.cic.common.ui.internal.SWTUtil;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.internal.parts.ProgressPart;
import com.ibm.cic.common.ui.internal.parts.ViewTitlePart;
import com.ibm.cic.common.ui.internal.views.AbstractCicView;
import com.ibm.cic.common.ui.internal.views.WizardAreaLayout;
import com.ibm.cic.common.ui.internal.wizardry.AbstractCicWizard;
import com.ibm.cic.common.ui.internal.wizardry.AbstractCicWizardPage;
import com.ibm.cic.common.ui.internal.wizardry.IHelpRefPage;
import com.ibm.cic.common.ui.internal.wizardry.IWizardBreadCrumbs;
import com.ibm.cic.common.ui.listeners.ICancelButtonStateListener;
import com.ibm.cic.common.ui.listeners.ICancelStatusListener;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.ISkippableWizardPage;
import com.ibm.cic.common.ui.wizards.SkippableWizardPage;
import com.ibm.cic.eclipse.internals.dialogs.TimeTriggeredProgressMonitorDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.forms.FormColors;

public abstract class AbstractCicWizardView
extends AbstractCicView
implements IWizardContainer,
IPageChangeProvider {
    private AbstractCicWizard wizard;
    private final ArrayList createdWizards = new ArrayList();
    private final ArrayList nestedWizards = new ArrayList();
    private IWizardPage currentPage = null;
    private ViewTitlePart titleArea;
    private ScrolledComposite scrolledWizardArea;
    private Composite wizardArea;
    private ImageDescriptor titleBarBackgroundImageDescriptor;
    private ImageDescriptor wizardProgressBarBackgroundImageDescriptor;
    private ImageDescriptor wizardProgressLabelImageDescriptor;
    private ImageDescriptor defaultPageBackgroundImageDescriptor;
    private StackLayout buttonAreaStack;
    private Composite buttonBar;
    private Composite progressBar;
    private ProgressPart progressPart;
    private Button backButton;
    private Button nextButton;
    private Button finishButton;
    private Button cancelButton;
    protected Control helpButton;
    private Listener escKeyListener;
    private Cursor waitCursor;
    private Cursor arrowCursor;
    private boolean isHidingDisabledButtons = false;
    private boolean isMovingToPreviousPage = false;
    private final SelectionAdapter cancelListener;
    private String jobName = Messages.AbstractCicWizardView_defaultJobName;
    private IStatus result = Status.OK_STATUS;
    private final WizardAreaLayout wizardAreaLayout = new WizardAreaLayout(28, 6, 600, 225);
    private final ListenerList pageChangedListeners = new ListenerList(0);
    private IWizardBreadCrumbs crumbs;
    private IWizardPage completionPage = null;
    private Menu menuBar = null;
    private IJobChangeListener jobChangeListener = null;
    private boolean busy = false;
    private Object state = null;
    private static final String FOCUS_CONTROL = "focusControl";

    public AbstractCicWizardView() {
        this.cancelListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCicWizardView.this.cancelPressed();
            }
        };
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        AbstractCicWizard inputWizard = this.getWizard();
        this.setWizard(inputWizard);
        this.showMenuBar(false);
        this.wizard.addPages();
        this.createViewControls(parent);
        this.escKeyListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2 && ((AbstractCicWizardView)AbstractCicWizardView.this).buttonAreaStack.topControl == AbstractCicWizardView.this.buttonBar) {
                    AbstractCicWizardView.this.cancelPressed();
                }
            }
        };
        this.getViewSite().getShell().addListener(31, this.escKeyListener);
        this.showStartingPage();
    }

    private void createViewControls(Composite parent) {
        Composite viewContainer = this.getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        viewContainer.setLayout((Layout)layout);
        this.createTitleBar(viewContainer);
        this.createWizardArea(viewContainer);
        this.createButtonBar(viewContainer);
    }

    private void createTitleBar(Composite parent) {
        this.titleArea = new ViewTitlePart(parent, this.getToolkit(), -1);
        this.titleArea.setBackgroundImage(this.getTitleBarBackgroundImage());
        this.titleArea.setLinkSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractCicWizardView.this.currentPage != null && AbstractCicWizardView.this.currentPage instanceof SkippableWizardPage) {
                    ((SkippableWizardPage)AbstractCicWizardView.this.currentPage).performLinkSelection();
                }
            }
        });
    }

    private void createWizardArea(Composite viewContainer) {
        this.scrolledWizardArea = new ScrolledComposite(viewContainer, 768);
        this.getToolkit().adapt((Composite)this.scrolledWizardArea);
        this.scrolledWizardArea.setAlwaysShowScrollBars(false);
        this.scrolledWizardArea.setExpandHorizontal(true);
        this.scrolledWizardArea.setExpandVertical(true);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.scrolledWizardArea.setLayout((Layout)layout);
        this.scrolledWizardArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.wizardArea = this.getToolkit().createComposite((Composite)this.scrolledWizardArea, 0);
        this.wizardArea.setLayout((Layout)this.wizardAreaLayout);
        this.wizardArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledWizardArea.setContent((Control)this.wizardArea);
        this.crumbs = UiServices.getInstance().createWizardBreadcrumbs(this.wizardArea);
        this.wizardAreaLayout.setPermanent(this.crumbs.getControl());
        Display display = DisplayKeeper.INSTANCE.getDisplay();
        final Color selectedTextColor = new Color((Device)display, this.createRGB(1, 2, 50));
        final Color unselectedTextColor = new Color((Device)display, this.createRGB(1, 2, 50));
        final Color selectedFillStartColor = new Color((Device)display, this.createRGB(1, 23, 90));
        final Color selectedFillEndColor = new Color((Device)display, this.createRGB(1, 23, 80));
        final Color unselectedFillStartColor = new Color((Device)display, this.createRGB(1, 19, 50));
        final Color unselectedFillEndColor = new Color((Device)display, this.createRGB(1, 19, 50));
        final Color selectedBorderStartColor = new Color((Device)display, this.createRGB(1, 23, 50));
        final Color selectedBorderEndColor = new Color((Device)display, this.createRGB(1, 23, 30));
        final Color unselectedBorderStartColor = new Color((Device)display, this.createRGB(1, 18, 40));
        final Color unselectedBorderEndColor = new Color((Device)display, this.createRGB(1, 18, 40));
        if (!DisplayKeeper.INSTANCE.getDisplay().getHighContrast()) {
            this.crumbs.setSelectedTextColor(selectedTextColor);
        } else {
            this.crumbs.setSelectedTextColor(null);
        }
        this.crumbs.setUnselectedTextColor(unselectedTextColor);
        this.crumbs.setUnselectedFillStartColor(unselectedFillStartColor);
        this.crumbs.setUnselectedFillEndColor(unselectedFillEndColor);
        if (!DisplayKeeper.INSTANCE.getDisplay().getHighContrast()) {
            this.crumbs.setSelectedFillStartColor(selectedFillStartColor);
            this.crumbs.setSelectedFillEndColor(selectedFillEndColor);
        } else {
            this.crumbs.setSelectedFillStartColor(null);
            this.crumbs.setSelectedFillEndColor(null);
        }
        this.crumbs.setSelectedBorderStartColor(selectedBorderStartColor);
        this.crumbs.setSelectedBorderEndColor(selectedBorderEndColor);
        this.crumbs.setUnselectedBorderStartColor(unselectedBorderStartColor);
        this.crumbs.setUnselectedBorderEndColor(unselectedBorderEndColor);
        this.crumbs.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                this.dispose((Resource)selectedTextColor);
                this.dispose((Resource)unselectedTextColor);
                this.dispose((Resource)selectedFillStartColor);
                this.dispose((Resource)selectedFillEndColor);
                this.dispose((Resource)unselectedFillStartColor);
                this.dispose((Resource)unselectedFillEndColor);
                this.dispose((Resource)selectedBorderStartColor);
                this.dispose((Resource)selectedBorderEndColor);
                this.dispose((Resource)unselectedBorderStartColor);
                this.dispose((Resource)unselectedBorderEndColor);
            }

            private void dispose(Resource resource) {
                if (resource != null) {
                    resource.dispose();
                }
            }
        });
        GridData crumbsData = new GridData(4, 1, true, false);
        this.crumbs.getControl().setLayoutData((Object)crumbsData);
        this.createPageControls(this.wizardArea);
    }

    private RGB createRGB(int foreground, int background, int percentOpacity) {
        return FormColors.blend((RGB)DisplayKeeper.INSTANCE.getDisplay().getSystemColor(foreground).getRGB(), (RGB)DisplayKeeper.INSTANCE.getDisplay().getSystemColor(background).getRGB(), (int)percentOpacity);
    }

    private void createPageControls(Composite parent) {
        IWizardPage[] pages;
        this.wizard.createPageControls(parent);
        IWizardPage[] iWizardPageArray = pages = this.getExpandedPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page.getControl() != null) {
                Composite c = (Composite)page.getControl();
                if (c.getBackgroundImage() == null) {
                    Image image = this.getDefaultPageBackgroundImage();
                    if (image != null) {
                        c.setBackgroundImage(image);
                    } else if (!(c instanceof SashForm)) {
                        this.adapt(c);
                    }
                }
                c.setBackgroundMode(2);
                page.getControl().setVisible(false);
            }
            ++n2;
        }
    }

    protected void createButtonBar(Composite parent) {
        Composite buttonArea = this.getToolkit().createComposite(parent);
        buttonArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonAreaStack = new StackLayout();
        buttonArea.setLayout((Layout)this.buttonAreaStack);
        this.buttonBar = this.getToolkit().createComposite(buttonArea, 0);
        this.buttonAreaStack.topControl = this.buttonBar;
        this.progressBar = this.getToolkit().createComposite(buttonArea);
        this.progressPart = new ProgressPart(this.getToolkit(), this.progressBar, this, this.wizard.hasDownloadActivities(), this.wizard.isDisplaySuspend());
        this.progressBar.setBackgroundMode(1);
        this.registerCancelStatusListener(this.progressPart);
        this.registerCancelButtonStateListener(this.progressPart);
        PixelConverter pc = new PixelConverter((Control)parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = pc.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = pc.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = pc.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = pc.convertVerticalDLUsToPixels(4);
        this.buttonBar.setLayout((Layout)layout);
        this.buttonBar.setFont(parent.getFont());
        this.createButtonsForButtonBar(this.buttonBar);
    }

    private void registerCancelStatusListener(ICancelStatusListener listener) {
        if (this.createdWizards != null && !this.createdWizards.isEmpty()) {
            int i = 0;
            while (i < this.createdWizards.size()) {
                IWizard createdWizard = (IWizard)this.createdWizards.get(i);
                if (createdWizard instanceof AbstractCicWizard) {
                    ((AbstractCicWizard)createdWizard).addCancelStatusListener(listener);
                }
                ++i;
            }
        }
    }

    private void registerCancelButtonStateListener(ICancelButtonStateListener listener) {
        if (this.createdWizards != null && !this.createdWizards.isEmpty()) {
            int i = 0;
            while (i < this.createdWizards.size()) {
                IWizard createdWizard = (IWizard)this.createdWizards.get(i);
                if (createdWizard instanceof AbstractCicWizard) {
                    ((AbstractCicWizard)createdWizard).addCancelButtonStateListener(listener);
                }
                ++i;
            }
        }
    }

    private ToolBar createHelpImageButton(Composite parent, Image image) {
        ToolBar toolBar = new ToolBar(parent, 0x880000);
        toolBar.setBackground(parent.getBackground());
        ++((GridLayout)parent.getLayout()).numColumns;
        toolBar.setLayoutData((Object)new GridData(64));
        final Cursor cursor = new Cursor((Device)DisplayKeeper.INSTANCE.getDisplay(), 21);
        toolBar.setCursor(cursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                cursor.dispose();
            }
        });
        ToolItem item = new ToolItem(toolBar, 0);
        item.setImage(image);
        item.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCicWizardView.this.helpPressed();
            }
        });
        return toolBar;
    }

    protected void createButtonsForButtonBar(Composite bar) {
        final Image image = CommonImages.DESC_HELP_ELCL.createImage();
        this.helpButton = this.createHelpImageButton(bar, image);
        this.helpButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.helpButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (image != null) {
                    image.dispose();
                }
            }
        });
        boolean helpAvailable = this.wizard.isHelpAvailable();
        this.helpButton.setVisible(helpAvailable);
        this.helpButton.setEnabled(helpAvailable);
        Label spacer = this.getToolkit().createLabel(bar, "");
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.wizard.needsPreviousAndNextButtons()) {
            this.createPreviousAndNextButtons(bar);
        }
        this.finishButton = this.createButton(bar, 16, this.wizard.getFinishLabel(), false);
        this.cancelButton = this.createCancelButton(bar);
    }

    private void createPreviousAndNextButtons(Composite bar) {
        ++((GridLayout)bar.getLayout()).numColumns;
        Composite composite = this.getToolkit().createComposite(bar, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(68);
        composite.setLayoutData((Object)data);
        composite.setFont(composite.getParent().getFont());
        this.backButton = this.createButton(composite, 14, com.ibm.cic.common.ui.internal.licensePanel.Messages.Wizard_BackButtonLabel, false);
        this.nextButton = this.createButton(composite, 15, com.ibm.cic.common.ui.internal.licensePanel.Messages.Wizard_NextButtonLabel, false);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = this.getToolkit().createButton(parent, label, 8);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractCicWizardView.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    private Button createCancelButton(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = this.getToolkit().createButton(parent, com.ibm.cic.common.ui.internal.licensePanel.Messages.Wizard_CancelButtonLabel, 8);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)1);
        button.addSelectionListener((SelectionListener)this.cancelListener);
        SWTUtil.setButtonDimensionHint(button);
        return button;
    }

    protected void setWizard(AbstractCicWizard newWizard) {
        this.wizard = newWizard;
        this.wizard.setContainer(this);
        this.wizard.setToolkit(this.getToolkit());
        if (!this.createdWizards.contains((Object)this.wizard)) {
            this.createdWizards.add(this.wizard);
            if (this.progressPart != null) {
                this.wizard.addCancelStatusListener(this.progressPart);
                this.wizard.addCancelButtonStateListener(this.progressPart);
            }
            this.nestedWizards.add(this.wizard);
            if (this.wizardArea != null) {
                this.createPageControls(this.wizardArea);
            }
        } else {
            int size = this.nestedWizards.size();
            if (size >= 2 && this.nestedWizards.get(size - 2) == this.wizard) {
                this.nestedWizards.remove(size - 1);
            } else {
                this.nestedWizards.add(this.wizard);
            }
        }
    }

    private void showStartingPage() {
        this.currentPage = this.wizard.getStartingPage();
        if (this.currentPage == null) {
            return;
        }
        if (this.currentPage.getControl() == null) {
            this.currentPage.createControl(this.wizardArea);
            Assert.isNotNull((Object)this.currentPage.getControl());
        }
        this.currentPage.setVisible(true);
        this.updateWizardProgressBar();
        this.update();
    }

    public void showPage(IWizardPage page) {
        if (!this.isMovingToPreviousPage) {
            page.setPreviousPage(this.currentPage);
        } else {
            this.isMovingToPreviousPage = false;
        }
        if (this.getToolkit() == null) {
            this.updateForPage(page);
        } else {
            final IWizardPage finalPage = page;
            BusyIndicator.showWhile((Display)DisplayKeeper.INSTANCE.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractCicWizardView.this.updateForPage(finalPage);
                }
            });
        }
        this.updateWizardProgressBar();
    }

    private void updateHelp() {
        if (this.getCurrentPage() instanceof IHelpRefPage) {
            IHelpRefPage helpRef = (IHelpRefPage)this.getCurrentPage();
            Shell lastControl = this.getCurrentPage().getControl().getShell();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)lastControl, helpRef.getHelpRef());
        }
    }

    private void updateWizardProgressBar() {
        IWizardPage[] pages = this.getExpandedPages();
        if (this.currentPage == this.completionPage || pages.length < 2 || this.wizard.getPrimaryPages() != null && pages.length == this.wizard.getPrimaryPages().length) {
            this.wizardAreaLayout.setPermanent(null);
            this.crumbs.getControl().setVisible(false);
            return;
        }
        this.wizardAreaLayout.setPermanent(this.crumbs.getControl());
        ArrayList<String> list = new ArrayList<String>(pages.length);
        int position = 0;
        String previousCrumbName = "";
        IWizardPage[] iWizardPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            String crumbName = page.getName();
            if (!crumbName.equals(previousCrumbName)) {
                list.add(crumbName);
                previousCrumbName = crumbName;
            }
            if (this.currentPage == page) {
                position = list.size() - 1;
            }
            ++n2;
        }
        this.crumbs.setCrumbs(list.toArray(new String[list.size()]), position);
        this.crumbs.getControl().setVisible(true);
        this.wizardArea.setBackgroundMode(1);
        this.wizardArea.layout(true);
    }

    private IWizardPage[] getExpandedPages() {
        ArrayList<IWizardPage> allPages = new ArrayList<IWizardPage>();
        int i = 0;
        while (i < this.nestedWizards.size()) {
            IWizardPage[] pages;
            IWizardPage[] iWizardPageArray = pages = ((IWizard)this.nestedWizards.get(i)).getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                allPages.add(page);
                ++n2;
            }
            ++i;
        }
        return allPages.toArray(new IWizardPage[allPages.size()]);
    }

    private void updateForPage(IWizardPage page) {
        if (this.wizard != page.getWizard()) {
            this.setWizard((AbstractCicWizard)page.getWizard());
            this.helpButton.setVisible(this.wizard.isHelpAvailable());
            this.helpButton.setEnabled(this.wizard.isHelpAvailable());
        }
        if (page.getControl() == null) {
            page.createControl(this.wizardArea);
            Assert.isNotNull((Object)page.getControl());
        }
        IWizardPage oldPage = this.currentPage;
        this.currentPage = page;
        this.currentPage.setVisible(true);
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.update();
        if (Platform.getOS().equals("macosx")) {
            page.getControl().update();
        }
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 17: {
                this.helpPressed();
                break;
            }
            case 14: {
                this.backPressed();
                break;
            }
            case 15: {
                this.nextPressed();
                break;
            }
            case 16: {
                this.finishPressed();
            }
        }
    }

    protected void helpPressed() {
        if (this.currentPage != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
        }
    }

    protected void backPressed() {
        IWizardPage page = this.currentPage;
        while (page != null) {
            boolean isSkippableWizardPage = (page = page.getPreviousPage()) instanceof ISkippableWizardPage;
            if (!isSkippableWizardPage || ((ISkippableWizardPage)page).evalPageEntry().equals(ISkippableWizardPage.EvalStatus.EVAL_STOP)) break;
        }
        if (page != null && page != this.currentPage) {
            this.isMovingToPreviousPage = true;
            if (this.currentPage instanceof AbstractCicWizardPage) {
                AbstractCicWizardPage pg = (AbstractCicWizardPage)this.currentPage;
                pg.previousPage();
            }
            this.showPage(page);
        }
    }

    public void nextPressed() {
        boolean originalStatus = this.backButton.getEnabled();
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        if (this.currentPage instanceof AbstractCicWizardPage) {
            try {
                AbstractCicWizardPage pg = (AbstractCicWizardPage)this.currentPage;
                pg.validatePage();
                pg.nextPage();
            }
            catch (AbstractCicWizardPage.ValidationFailed validationFailed) {
                String err = this.currentPage.getErrorMessage();
                if (err == null || err.length() == 0) {
                    err = Messages.AbstractCicWizardView_unexpectedPageValidationError;
                }
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.AbstractCicWizardView_validationErrorDialogTitle, (String)err);
                return;
            }
        }
        IWizardPage page = this.currentPage;
        while (page != null && this.canGoNext(page)) {
            boolean isSkippableWizardPage = (page = page.getNextPage()) instanceof ISkippableWizardPage;
            if (!isSkippableWizardPage || ((ISkippableWizardPage)page).evalPageEntry().equals(ISkippableWizardPage.EvalStatus.EVAL_STOP)) break;
        }
        if (page == null) {
            this.finishPressed();
        } else if (page != this.currentPage) {
            this.showPage(page);
        } else {
            if (!(page instanceof AbstractCicWizardPage && ((AbstractCicWizardPage)page).hasInternalNavigation() || page.getErrorMessage() != null)) {
                this.nextButton.setEnabled(true);
            }
            this.backButton.setEnabled(originalStatus);
        }
    }

    private boolean canGoNext(IWizardPage page) {
        if (page instanceof AbstractCicWizardPage && ((AbstractCicWizardPage)page).hasInternalNavigation()) {
            return true;
        }
        return page.isPageComplete();
    }

    protected void finishPressed() {
        if (this.wizard.performFinish()) {
            this.finishSucceeded();
        }
    }

    public void finishSucceeded() {
        int i = 0;
        while (i < this.nestedWizards.size() - 1) {
            ((IWizard)this.nestedWizards.get(i)).performFinish();
            ++i;
        }
        this.finish();
    }

    public void finish() {
        this.completionPage = this.wizard.getCompletionPage(this.result);
        this.showCompletionPage();
    }

    private void showCompletionPage() {
        this.setHideDisabledButtons(true);
        if (this.completionPage == null) {
            this.hardClose(false, false);
        } else {
            this.showPage(this.completionPage);
            this.cancelButton.setText(this.wizard.getCompletionPageFinishLabel());
            SWTUtil.setButtonDimensionHint(this.cancelButton);
            this.cancelButton.getParent().layout();
        }
    }

    public void cancelPressed() {
        if (this.okToClose(false)) {
            this.hardClose(true, false);
        }
    }

    public boolean close() {
        if (this.okToClose(true)) {
            return this.hardClose(true, true);
        }
        return false;
    }

    protected boolean okToClose(boolean promptToSave) {
        if (this.currentPage == this.completionPage) {
            return this.wizard.performDone();
        }
        return this.wizard.performCancel();
    }

    public IWizardPage getCurrentPage() {
        return this.currentPage;
    }

    public void setFocus() {
    }

    protected abstract AbstractCicWizard getWizard();

    protected boolean hardClose(boolean cancel, boolean closeFromWorkbench) {
        this.preCloseCleanup(cancel);
        if (closeFromWorkbench) {
            this.waitForJobDone();
            return true;
        }
        String returnViewId = null;
        if (!cancel) {
            returnViewId = this.wizard.getReturnViewId();
        }
        IWorkbenchPage page = this.getViewSite().getPage();
        IPerspectiveDescriptor persp = page.getPerspective();
        page.closePerspective(persp, false, false);
        if (returnViewId != null) {
            try {
                page.showView(returnViewId);
            }
            catch (PartInitException e) {
                CicCommonUiPlugin.logException(e);
            }
        }
        this.showMenuBar(true);
        return true;
    }

    protected void waitForJobDone() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("", -1);
                while (AbstractCicWizardView.this.busy) {
                    Display display = DisplayKeeper.INSTANCE.getDisplay();
                    if (display == null || display.isDisposed() || display.readAndDispatch()) continue;
                    display.sleep();
                }
                monitor.done();
            }
        };
        try {
            TimeTriggeredProgressMonitorDialog dialog = new TimeTriggeredProgressMonitorDialog(this.getSite().getShell(), 800);
            dialog.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            CicCommonUiPlugin.logException(e);
        }
        catch (InterruptedException e) {
            CicCommonUiPlugin.logException(e);
        }
    }

    protected void preCloseCleanup(boolean cancel) {
        int i = 0;
        while (i < this.createdWizards.size()) {
            IWizard createdWizard = (IWizard)this.createdWizards.get(i);
            createdWizard.dispose();
            createdWizard.setContainer(null);
            ++i;
        }
        if (cancel && this.progressPart != null) {
            this.progressPart.resumeBeforeCancel();
            this.progressPart.setCanceled(true);
        }
    }

    public void runInWorkbenchWindow(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.getViewSite().getWorkbenchWindow().run(fork, cancelable, runnable);
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) {
        if (!(this.currentPage == null || this.currentPage instanceof SkippableWizardPage && ((SkippableWizardPage)this.currentPage).isReadOnlyPage())) {
            this.state = this.aboutToStart();
        }
        if (this.buttonAreaStack.topControl != this.progressBar) {
            this.buttonAreaStack.topControl = this.progressBar;
            this.progressBar.getParent().layout();
        }
        this.runInProgressPart(cancelable, runnable);
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    private void stopped(Object savedState) {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            Map stateMap = (Map)savedState;
            this.restoreUIState(stateMap);
            if (this.currentPage != null) {
                this.currentPage.getControl().setCursor(null);
            }
            if (this.waitCursor != null && !this.waitCursor.isDisposed()) {
                this.waitCursor.dispose();
            }
            this.waitCursor = null;
            if (this.arrowCursor != null && !this.arrowCursor.isDisposed()) {
                this.arrowCursor.dispose();
            }
            this.arrowCursor = null;
            Control focusControl = (Control)stateMap.get(FOCUS_CONTROL);
            if (focusControl != null && !focusControl.isDisposed()) {
                focusControl.setFocus();
            }
        }
    }

    private void restoreUIState(Map stateMap) {
        Object pageValue = stateMap.get("page");
        if (pageValue != null) {
            ((ControlEnableState)pageValue).restore();
        }
    }

    private Object aboutToStart() {
        Map savedState = null;
        if (this.getShell() != null) {
            Control focusControl = DisplayKeeper.INSTANCE.getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            Display d = DisplayKeeper.INSTANCE.getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            if (this.currentPage != null) {
                this.currentPage.getControl().setCursor(this.waitCursor);
            }
            this.arrowCursor = new Cursor((Device)d, 0);
            this.progressBar.setCursor(this.arrowCursor);
            savedState = this.saveUIState();
            if (focusControl != null) {
                savedState.put(FOCUS_CONTROL, focusControl);
            }
        }
        return savedState;
    }

    private Map saveUIState() {
        HashMap<String, ControlEnableState> savedState = new HashMap<String, ControlEnableState>(5);
        if (this.currentPage != null) {
            savedState.put("page", ControlEnableState.disable((Control)this.currentPage.getControl()));
        }
        return savedState;
    }

    private void runInProgressPart(boolean cancelable, IRunnableWithProgress runnable) {
        this.jobChangeListener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                final Job job = event.getJob();
                if (!job.belongsTo((Object)"com.ibm.cic.common.ui")) {
                    return;
                }
                AbstractCicWizardView.this.busy = false;
                AbstractCicWizardView.this.setCancelStatus(0);
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                final IStatus status = event.getResult();
                DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = AbstractCicWizardView.this.getShell();
                        if (shell == null) {
                            return;
                        }
                        Display display = DisplayKeeper.INSTANCE.getDisplay();
                        if (display == null || display.isDisposed()) {
                            return;
                        }
                        if (AbstractCicWizardView.this.state != null) {
                            AbstractCicWizardView.this.stopped(AbstractCicWizardView.this.state);
                            AbstractCicWizardView.this.state = null;
                        }
                        ((AbstractCicWizardView)(this).AbstractCicWizardView.this).buttonAreaStack.topControl = AbstractCicWizardView.this.buttonBar;
                        AbstractCicWizardView.this.buttonBar.getParent().layout();
                        try {
                            IPerspectiveDescriptor pd = AbstractCicWizardView.this.getSite().getPage().getPerspective();
                            PlatformUI.getWorkbench().showPerspective(pd.getId(), AbstractCicWizardView.this.getSite().getWorkbenchWindow());
                        }
                        catch (WorkbenchException e) {
                            CicCommonUiPlugin.logException(e);
                        }
                        AbstractCicWizardView.this.result = status;
                        if (status.matches(12)) {
                            if (!AbstractCicWizardView.this.wizard.isKeepFetchedFilesInvoked()) {
                                String currentJobName = job.getName();
                                String message = null;
                                String statusMessage = status.getMessage();
                                if (statusMessage == null || statusMessage.length() == 0) {
                                    message = NLS.bind((String)Messages.RunJobErrorMsg, (Object)currentJobName);
                                }
                                WrapDetailUIDErrorDialog.openError(shell, currentJobName, message, status, 14);
                            }
                            AbstractCicWizardView.this.finish();
                        } else if (status.matches(2)) {
                            AbstractCicWizardView.this.finish();
                        } else {
                            AbstractCicWizardView.this.finishSucceeded();
                        }
                    }
                });
            }
        };
        Job.getJobManager().addJobChangeListener(this.jobChangeListener);
        this.busy = true;
        this.restoreConfirmCancelStatus();
        this.progressPart.run(cancelable, runnable, this.jobName);
    }

    protected void update() {
        Point minSize = this.wizardArea.computeSize(this.wizardAreaLayout.minimumWidth, -1);
        this.scrolledWizardArea.setMinSize(minSize);
        this.updateWindowTitle();
        this.updateTitleBar();
        this.updateButtons();
        this.updateHelp();
        this.fireCurrentPageChanged();
    }

    public void fireCurrentPageChanged() {
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, (Object)this.getCurrentPage()));
    }

    public final void updateWindowTitle() {
    }

    public void updateButtons() {
        if (this.currentPage == null) {
            return;
        }
        if (this.currentPage == this.completionPage) {
            if (this.backButton != null) {
                this.backButton.setEnabled(false);
            }
            if (this.nextButton != null) {
                this.nextButton.setEnabled(false);
            }
            this.finishButton.setEnabled(false);
            this.getShell().setDefaultButton(this.cancelButton);
        } else {
            boolean canFlipToNextPage = false;
            boolean canFinish = this.wizard.canFinish();
            if (this.backButton != null) {
                boolean hasPreviousPage = false;
                hasPreviousPage = this.currentPage instanceof AbstractCicWizardPage ? ((AbstractCicWizardPage)this.currentPage).canFlipToPreviousPage() : this.currentPage.getPreviousPage() != null;
                this.backButton.setEnabled(hasPreviousPage);
            }
            if (this.nextButton != null) {
                try {
                    canFlipToNextPage = this.currentPage.canFlipToNextPage();
                }
                catch (Exception e) {
                    String reason = e.getMessage();
                    if (reason == null || reason.length() == 0) {
                        reason = e.toString();
                    }
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.CanFlipToNextPage_errorTitle, (String)NLS.bind((String)Messages.CanFlipToNextPage_errorMsg, (Object)reason));
                    canFlipToNextPage = false;
                }
                this.nextButton.setEnabled(canFlipToNextPage);
            }
            this.finishButton.setEnabled(canFinish);
            if (canFlipToNextPage && !canFinish) {
                this.getShell().setDefaultButton(this.nextButton);
            } else {
                this.getShell().setDefaultButton(this.finishButton);
            }
        }
        if (this.isHidingDisabledButtons) {
            this.hideDisabledButtons(this.buttonBar);
        }
        this.buttonBar.getParent().layout();
    }

    private void hideDisabledButtons(Composite composite) {
        Control[] children;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                this.hideDisabledButtons((Composite)child);
            } else {
                child.setVisible(child.isEnabled());
            }
            ++n2;
        }
    }

    public void updateTitleBar() {
        String title = this.wizard.getDefaultPageTitle();
        if (title == null && this.currentPage != null) {
            title = this.currentPage.getTitle();
        }
        if (title == null) {
            title = "";
        }
        this.titleArea.setTitle(title);
        Image image = null;
        if (this.currentPage != null) {
            image = this.currentPage.getImage();
        }
        if (image == null) {
            image = this.wizard.getDefaultPageImage();
        }
        this.titleArea.setTitleImage(image);
        this.updateMessage();
    }

    public void updateMessage() {
        String message = null;
        int msgKind = 0;
        if (this.currentPage != null) {
            msgKind = 3;
            message = this.currentPage.getErrorMessage();
            if (message == null && this.currentPage instanceof IMessageProvider) {
                IMessageProvider messageProviderPage = (IMessageProvider)this.currentPage;
                message = messageProviderPage.getMessage();
                msgKind = messageProviderPage.getMessageType();
            }
            if (message == null) {
                message = this.currentPage.getDescription();
                msgKind = 0;
            }
        }
        if (message == null) {
            message = "";
        }
        this.titleArea.setMessageImage(msgKind);
        this.titleArea.setMessageText(message);
    }

    protected void setHideDisabledButtons(boolean hide) {
        this.isHidingDisabledButtons = hide;
    }

    protected boolean isHidingDisabledButtons() {
        return this.isHidingDisabledButtons;
    }

    protected void firePageChanged(final PageChangedEvent event) {
        Object[] listeners;
        Object[] objectArray = listeners = this.pageChangedListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPageChangedListener l = (IPageChangedListener)listener;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
            ++n2;
        }
    }

    protected void setTitleBarBackgroundImageDescriptor(ImageDescriptor descriptor) {
        this.titleBarBackgroundImageDescriptor = descriptor;
    }

    protected void setWizardProgressBarBackgroundImageDescriptor(ImageDescriptor descriptor) {
        this.wizardProgressBarBackgroundImageDescriptor = descriptor;
    }

    protected void setWizardProgressLabelImageDescriptor(ImageDescriptor descriptor) {
        this.wizardProgressLabelImageDescriptor = descriptor;
    }

    protected void setDefaultPageBackgroundImageDescriptor(ImageDescriptor descriptor) {
        this.defaultPageBackgroundImageDescriptor = descriptor;
    }

    public Image getTitleBarBackgroundImage() {
        return this.getBackgroundImage(this.titleBarBackgroundImageDescriptor);
    }

    public Image getWizardProgressBarBackgroundImage() {
        return this.getBackgroundImage(this.wizardProgressBarBackgroundImageDescriptor);
    }

    public Image getWizardProgressLabelImageDescriptor() {
        return this.getBackgroundImage(this.wizardProgressLabelImageDescriptor);
    }

    public Image getDefaultPageBackgroundImage() {
        return this.getBackgroundImage(this.defaultPageBackgroundImageDescriptor);
    }

    public Object getSelectedPage() {
        return this.getCurrentPage();
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.remove((Object)listener);
    }

    @Override
    public void dispose() {
        Shell shell;
        if (this.progressPart != null) {
            this.progressPart.dispose();
        }
        if ((shell = this.getViewSite().getShell()) != null && !shell.isDisposed() && this.escKeyListener != null) {
            shell.removeListener(31, this.escKeyListener);
            this.escKeyListener = null;
        }
        super.dispose();
    }

    private void showMenuBar(boolean show) {
        Shell shell = this.getShell();
        if (shell != null) {
            boolean showing;
            Menu currentMenuBar = shell.getMenuBar();
            boolean bl = showing = currentMenuBar != null;
            if (show != showing) {
                if (show) {
                    shell.setMenuBar(this.menuBar);
                    shell.layout(true);
                } else {
                    this.menuBar = currentMenuBar;
                    shell.setMenuBar(null);
                }
            }
        }
    }

    public void removeCreatedWizard(IWizard constructedWizard) {
        this.createdWizards.remove(constructedWizard);
    }

    public boolean hasJobRunning() {
        return this.busy;
    }

    public boolean isCanceled() {
        return this.progressPart != null && this.progressPart.isCanceled();
    }

    public void confirmCancel() {
        this.progressPart.confirmCancel();
    }

    public int getConfirmCancelStatus() {
        if (this.progressPart != null) {
            return this.progressPart.getConfirmCancelStatus();
        }
        return -1;
    }

    public void restoreConfirmCancelStatus() {
        if (this.progressPart != null) {
            this.progressPart.restoreConfirmCancelStatus();
        }
    }

    private void setCancelStatus(int status) {
        this.progressPart.setCancelStatus(status);
    }

    public void updateErrorMessageStatus(IStatus msgStatus) {
        this.titleArea.setErrorMessageStatus(msgStatus);
    }

    public void updateWarningMessageStatus(IStatus msgStatus) {
        this.titleArea.setWarningMessageStatus(msgStatus);
    }
}

