/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.preferences;

import com.ibm.cic.common.core.sharedUI.Messages;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class PortFieldEditor
extends IntegerFieldEditor {
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;

    public PortFieldEditor() {
        this.init();
    }

    public PortFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        super(name, labelText, parent, textLimit);
        this.init();
    }

    public PortFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.init();
    }

    private void init() {
        super.setValidRange(0, 65535);
        this.setTextLimit(Integer.toString(65535).length());
        this.setErrorMessage(Messages.ProxyPreferencePage_PortField_OutOfRangeError);
    }

    public void setValidRange(int min, int max) {
        throw new UnsupportedOperationException();
    }

    protected void doStore() {
        boolean catchErrorsSilent;
        boolean bl = catchErrorsSilent = !this.getTextControl().getEnabled();
        if (catchErrorsSilent) {
            try {
                super.doStore();
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            super.doStore();
        }
    }

    public boolean checkState() {
        block5: {
            Text text = this.getTextControl();
            if (text == null) {
                return false;
            }
            boolean enabled = text.getEnabled();
            if (!enabled) {
                this.clearErrorMessage();
                return true;
            }
            String numberString = text.getText();
            try {
                int number = Integer.valueOf(numberString);
                if (number < 0 || number > 65535) break block5;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showErrorMessage();
                return false;
            }
        }
        this.showErrorMessage();
        return false;
    }

    public boolean isValid() {
        Text textField = this.getTextControl();
        if (textField == null) {
            return true;
        }
        boolean enabled = textField.getEnabled();
        String txt = textField.getText();
        boolean result = txt.trim().length() > 0 || !enabled;
        return result;
    }
}

