/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.parts;

import com.ibm.cic.common.downloads.DownloadUI;
import com.ibm.cic.common.downloads.IDownloadUI;
import com.ibm.cic.common.downloads.IRestorePrevious;
import com.ibm.cic.common.downloads.ISuspendResumeControllerUI;
import com.ibm.cic.common.downloads.ISuspendResumeUI;
import com.ibm.cic.common.downloads.SuspendResumeUIController;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.internal.parts.CicProgressMonitorPart;
import com.ibm.cic.common.ui.internal.parts.IBusyListener;
import com.ibm.cic.common.ui.internal.views.AbstractCicWizardView;
import com.ibm.cic.common.ui.listeners.CancelButtonStateEvent;
import com.ibm.cic.common.ui.listeners.CancelEvent;
import com.ibm.cic.common.ui.listeners.ICancelButtonStateListener;
import com.ibm.cic.common.ui.listeners.ICancelStatusListener;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.IProgressConstants;

public class ProgressPart
implements IProgressMonitor,
ICancelStatusListener,
ICancelButtonStateListener {
    private ProgressMonitorPart monitorPart;
    private Button cancelButton;
    private IProgressMonitor slaveMonitor;
    private Composite parent;
    private final ListenerList busyListenerList = new ListenerList();
    private boolean busy;
    private Button suspendButton;
    private int actionId = -1;
    private Runnable callback;
    private IRestorePrevious previousUI;
    private ProgressJob job;
    private int state = -1;
    private String textMsg;
    private IStatusLineManager statusLineManager = null;
    private boolean hasDownloadActivities;
    private String taskName = "";
    private String jobName = "";
    private boolean displaySuspend;
    private boolean cancelButtonEnabled;
    private ISuspendResumeUI srDelegate;
    private int confirmCancelStatus = -1;

    public ProgressPart(FormToolkit toolkit, Composite parent, AbstractCicWizardView view, boolean hasDownloadActivities, boolean displaySuspend) {
        IActionBars actionBars;
        this.parent = parent;
        this.hasDownloadActivities = hasDownloadActivities;
        this.displaySuspend = displaySuspend;
        if (view != null && (actionBars = view.getViewSite().getActionBars()) != null) {
            this.statusLineManager = actionBars.getStatusLineManager();
        }
        this.createFormContent(toolkit);
        if (hasDownloadActivities) {
            this.srDelegate = new SuspendResumeUIController.SuspendResumeUIConnector(new ISuspendResumeControllerUI(){

                public boolean isCanceled() {
                    return ProgressPart.this.isCanceled();
                }

                public void disableAction() {
                    ProgressPart.this.disableAction();
                }

                public boolean requestInterruptedState() {
                    return true;
                }

                public void setAction(int actionId, Runnable actionCallback) {
                    ProgressPart.this.setAction(actionId, actionCallback);
                }

                public void setState(int stateId, String text) {
                    ProgressPart.this.setState(stateId, text);
                }
            });
            this.previousUI = DownloadUI.INSTANCE.setRestoreUIRequest((IDownloadUI)this.srDelegate, true);
        }
    }

    public void dispose() {
        this.busyListenerList.clear();
        if (this.hasDownloadActivities && this.previousUI != null) {
            this.previousUI.restore();
        }
    }

    private void createFormContent(FormToolkit toolkit) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = this.hasDownloadActivities && this.displaySuspend ? 3 : 2;
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 2;
        this.parent.setLayout((Layout)gridLayout);
        this.monitorPart = new CicProgressMonitorPart(this.parent, null);
        this.monitorPart.addListener(1, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        this.monitorPart.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: {
                        event.doit = true;
                    }
                }
                event.doit = true;
            }
        });
        this.monitorPart.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ProgressPart.this.jobName;
            }
        });
        this.monitorPart.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                e.result = ProgressPart.this.taskName;
            }
        });
        if (this.hasDownloadActivities && this.displaySuspend) {
            this.suspendButton = toolkit.createButton(this.parent, Messages.ProgressPart_suspend, 8);
            this.suspendButton.setLayoutData((Object)new GridData(1, 0x1000008, false, false));
            this.suspendButton.setEnabled(false);
            this.suspendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ProgressPart.this.callback != null) {
                        ProgressPart.this.callback.run();
                    }
                }
            });
        }
        this.cancelButton = toolkit.createButton(this.parent, Messages.ProgressPart_CancelCaption, 8);
        this.cancelButton.setLayoutData((Object)new GridData(1, 0x1000008, false, false));
        this.cancelButton.setVisible(false);
        this.monitorPart.setLayoutData((Object)new GridData(768));
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressPart.this.cancelButtonSetEnabled(false);
                if (!ProgressPart.this.monitorPart.isCanceled()) {
                    ProgressPart.this.restoreConfirmCancelStatus();
                    ProgressPart.this.resumeBeforeCancel();
                    ProgressPart.this.monitorPart.setCanceled(true);
                }
            }
        });
    }

    private void cancelButtonSetEnabled(boolean enabled) {
        this.cancelButton.setEnabled(enabled);
        this.cancelButtonEnabled = enabled;
    }

    private boolean isCancelButtonEnabled() {
        return this.cancelButtonEnabled;
    }

    public void confirmCancel() {
        if (!this.monitorPart.isCanceled()) {
            this.resumeBeforeCancel();
            this.monitorPart.setCanceled(true);
        }
    }

    public void resumeBeforeCancel() {
        if (this.state == 4 && this.actionId == 2 && this.callback != null) {
            this.callback.run();
        }
    }

    public void beginTask(final String name, final int totalWork) {
        this.taskName = name;
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressPart.this.monitorPart.setVisible(true);
                    ProgressPart.this.monitorPart.beginTask(name, totalWork);
                    if (ProgressPart.this.slaveMonitor != null) {
                        ProgressPart.this.slaveMonitor.beginTask(name, totalWork);
                    }
                    ProgressPart.this.setBusy(true);
                }
            });
        }
    }

    private Display getDisplay() {
        if (this.parent.isDisposed()) {
            return null;
        }
        return DisplayKeeper.INSTANCE.getDisplay();
    }

    public void done() {
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressPart.this.monitorPart == null || ProgressPart.this.monitorPart.isDisposed()) {
                        return;
                    }
                    ProgressPart.this.monitorPart.done();
                    ProgressPart.this.monitorPart.setVisible(false);
                    ProgressPart.this.cancelButton.setVisible(false);
                    if (ProgressPart.this.suspendButton != null) {
                        ProgressPart.this.suspendButton.setVisible(false);
                    }
                    if (ProgressPart.this.slaveMonitor != null) {
                        ProgressPart.this.slaveMonitor.done();
                    }
                    ProgressPart.this.setBusy(false);
                }
            });
        }
    }

    private void setBusy(boolean busy) {
        boolean fireEvent = this.busy ^ busy;
        this.busy = busy;
        if (fireEvent) {
            Object[] listeners;
            Object[] objectArray = listeners = this.busyListenerList.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener2 = objectArray[n2];
                IBusyListener listener = (IBusyListener)listener2;
                listener.busyChanged(this, busy);
                ++n2;
            }
        }
    }

    public void internalWorked(final double work) {
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressPart.this.monitorPart == null || ProgressPart.this.monitorPart.isDisposed()) {
                        return;
                    }
                    ProgressPart.this.monitorPart.internalWorked(work);
                    if (ProgressPart.this.slaveMonitor != null) {
                        ProgressPart.this.slaveMonitor.internalWorked(work);
                    }
                }
            });
        }
    }

    public boolean isCanceled() {
        if (this.slaveMonitor != null && this.slaveMonitor.isCanceled()) {
            return true;
        }
        return this.monitorPart.isCanceled();
    }

    public void setCanceled(boolean value) {
        if (value && this.job != null) {
            this.job.cancel();
        }
        this.monitorPart.setCanceled(value);
        if (this.slaveMonitor != null) {
            this.slaveMonitor.setCanceled(value);
        }
    }

    public void setTaskName(final String name) {
        this.taskName = name;
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressPart.this.monitorPart == null || ProgressPart.this.monitorPart.isDisposed()) {
                        return;
                    }
                    ProgressPart.this.monitorPart.setTaskName(name);
                    if (ProgressPart.this.slaveMonitor != null) {
                        ProgressPart.this.slaveMonitor.setTaskName(name);
                    }
                }
            });
        }
    }

    public void subTask(final String name) {
        this.taskName = name;
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressPart.this.monitorPart == null || ProgressPart.this.monitorPart.isDisposed()) {
                        return;
                    }
                    ProgressPart.this.monitorPart.subTask(name);
                    if (ProgressPart.this.slaveMonitor != null) {
                        ProgressPart.this.slaveMonitor.subTask(name);
                    }
                }
            });
        }
    }

    public void worked(final int work) {
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressPart.this.monitorPart == null || ProgressPart.this.monitorPart.isDisposed()) {
                        return;
                    }
                    ProgressPart.this.monitorPart.worked(work);
                    if (ProgressPart.this.slaveMonitor != null) {
                        ProgressPart.this.slaveMonitor.worked(work);
                    }
                }
            });
        }
    }

    public void run(boolean cancelable, IRunnableWithProgress runnable, String runJobName) {
        this.jobName = runJobName;
        this.cancelButton.setVisible(true);
        this.cancelButtonSetEnabled(cancelable);
        this.job = new ProgressJob(runnable, runJobName);
        this.job.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
        this.job.schedule();
    }

    public void addBusyListener(IBusyListener listener) {
        this.busyListenerList.add((Object)listener);
    }

    public void removeBusyListener(IBusyListener listener) {
        this.busyListenerList.remove((Object)listener);
    }

    public void disableAction() {
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressPart.this.suspendButton == null || ProgressPart.this.suspendButton.isDisposed()) {
                        return;
                    }
                    ProgressPart.this.suspendButton.setEnabled(false);
                    if (ProgressPart.this.statusLineManager != null) {
                        ProgressPart.this.statusLineManager.setMessage(null);
                    }
                }
            });
        }
        this.callback = null;
    }

    public void setAction(int id, Runnable actionCallback) {
        this.actionId = id;
        this.callback = actionCallback;
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressPart.this.suspendButton == null || ProgressPart.this.suspendButton.isDisposed()) {
                        return;
                    }
                    ProgressPart.this.suspendButton.setEnabled(true);
                    if (ProgressPart.this.actionId == 1) {
                        ProgressPart.this.suspendButton.setText(Messages.ProgressPart_suspend);
                    } else if (ProgressPart.this.actionId == 2) {
                        ProgressPart.this.suspendButton.setText(Messages.ProgressPart_resume);
                    } else if (ProgressPart.this.actionId == 3) {
                        ProgressPart.this.suspendButton.setText(Messages.ProgressPart_retry);
                    }
                    Composite parentComp = ProgressPart.this.suspendButton.getParent();
                    if (parentComp != null) {
                        parentComp.layout();
                    }
                }
            });
        }
    }

    public void setState(int stateId, String text) {
        this.state = stateId;
        this.textMsg = text;
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressPart.this.state == 3) {
                        if (ProgressPart.this.textMsg != null && ProgressPart.this.statusLineManager != null) {
                            String msg = NLS.bind((String)Messages.ProgressPart_downloadInterruptedWithArg, (Object)ProgressPart.this.textMsg);
                            ProgressPart.this.statusLineManager.setMessage(msg);
                        } else if (ProgressPart.this.statusLineManager != null) {
                            ProgressPart.this.statusLineManager.setMessage(Messages.ProgressPart_downloadInterrupted);
                        }
                    } else if (ProgressPart.this.state == 4) {
                        if (ProgressPart.this.statusLineManager != null) {
                            ProgressPart.this.statusLineManager.setMessage(Messages.ProgressPart_downloadSuspended);
                        }
                    } else if (ProgressPart.this.statusLineManager != null) {
                        ProgressPart.this.statusLineManager.setMessage(null);
                    }
                }
            });
        }
    }

    @Override
    public void notify(CancelEvent event) {
        final boolean canceled = event.getCancelStatus();
        this.confirmCancelStatus = canceled ? 0 : 1;
        Display display = this.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProgressPart.this.cancelButton != null && !ProgressPart.this.cancelButton.isDisposed()) {
                        ProgressPart.this.cancelButtonSetEnabled(!canceled);
                    }
                }
            });
        }
    }

    public int getConfirmCancelStatus() {
        return this.confirmCancelStatus;
    }

    public void restoreConfirmCancelStatus() {
        this.confirmCancelStatus = -1;
    }

    public void setCancelStatus(int status) {
        this.confirmCancelStatus = status;
    }

    @Override
    public Boolean notifyCancelButtonState(final CancelButtonStateEvent event) {
        Boolean previousStatus = this.isCancelButtonEnabled();
        Display display = this.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ProgressPart.this.cancelButton.isDisposed() && ProgressPart.this.monitorPart != null && !ProgressPart.this.monitorPart.isCanceled()) {
                        ProgressPart.this.cancelButtonSetEnabled(event.getEnableCancelButton());
                    }
                }
            });
        }
        return previousStatus;
    }

    class ProgressJob
    extends Job {
        private final IRunnableWithProgress fOp;

        public ProgressJob(IRunnableWithProgress op, String jobName) {
            super(jobName);
            this.fOp = op;
        }

        public boolean belongsTo(Object family) {
            return family.equals("com.ibm.cic.common.ui");
        }

        protected IStatus run(IProgressMonitor monitor) {
            ProgressPart.this.slaveMonitor = monitor;
            Object status = Status.OK_STATUS;
            try {
                try {
                    this.fOp.run((IProgressMonitor)ProgressPart.this);
                    ProgressPart.this.done();
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    status = t instanceof CoreException ? ((CoreException)t).getStatus() : (t instanceof InterruptedException ? new Status(8, CicCommonUiPlugin.getPluginId(), 0, Messages.ProgressPart_taskCancelledText0, t) : new Status(4, CicCommonUiPlugin.getPluginId(), 0, Messages.ProgressPart_runningTaskError, e.getTargetException()));
                    ProgressPart.this.done();
                    ProgressPart.this.slaveMonitor = null;
                }
                catch (InterruptedException e) {
                    status = new Status(2, CicCommonUiPlugin.getPluginId(), 0, Messages.ProgressPart_taskCancelledText0, e.getCause());
                    ProgressPart.this.done();
                    ProgressPart.this.slaveMonitor = null;
                }
            }
            finally {
                ProgressPart.this.done();
                ProgressPart.this.slaveMonitor = null;
            }
            return status;
        }
    }
}

