/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.model;

import com.ibm.cic.common.ui.internal.model.IPropertyChangeListener;
import com.ibm.cic.common.ui.internal.model.ITreeNode;
import com.ibm.cic.common.ui.internal.model.Property;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;

class PropertyChangeListenerSets {
    private final Map node2listenerSet = new Hashtable();

    public void addListener(ITreeNode node, IPropertyChangeListener listener) {
        HashSet<IPropertyChangeListener> listenerSet = (HashSet<IPropertyChangeListener>)this.node2listenerSet.get(node);
        if (listenerSet == null) {
            listenerSet = new HashSet<IPropertyChangeListener>();
            this.node2listenerSet.put(node, listenerSet);
        }
        listenerSet.add(listener);
    }

    public void removeListener(ITreeNode node, IPropertyChangeListener listener) {
        Set listenerSet = (Set)this.node2listenerSet.get(node);
        if (listenerSet != null) {
            listenerSet.remove(listener);
            if (listenerSet.isEmpty()) {
                this.node2listenerSet.remove(node);
            }
        }
    }

    public void firePropertyChangedEvent(final ITreeNode node, final Property property) {
        Set listenerSet = (Set)this.node2listenerSet.get(node);
        if (listenerSet == null) {
            return;
        }
        for (final IPropertyChangeListener listener : listenerSet) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.propertyChanged(node, property);
                }
            });
        }
    }
}

