/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.misc;

import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.ui.internal.LinkListener;
import com.ibm.cic.common.ui.internal.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class PaErrorDialog
extends ErrorDialog {
    private Link messageLink;
    private Link supportLink;
    private static final String PA_ECARE_URL = "http://www.ibm.com/software/howtobuy/passportadvantage/paocustomer/docs/en_US/ecare.html";

    public PaErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
        super(parentShell, dialogTitle, message, status, displayMask);
    }

    protected boolean shouldShowDetailsButton() {
        return false;
    }

    protected Control createMessageArea(Composite composite) {
        this.createMessageImage(composite);
        this.createMessageLabel(composite);
        return composite;
    }

    protected void createMessageLabel(Composite parent) {
        if (this.message != null) {
            this.messageLink = new Link(parent, 72);
            this.messageLink.setText(this.message);
            this.messageLink.addListener(13, (Listener)new LinkListener(parent.getShell(), Messages.PaErrorDialog_title, Messages.PaErrorDialog_program_launch_failed));
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageLink);
        }
    }

    protected void createMessageImage(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.addImageAccessibleListeners(this.imageLabel, image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
    }

    protected void addImageAccessibleListeners(Label label, final Image image) {
        label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                String accessibleMessage = this.getAccessibleMessageForImage(image);
                if (accessibleMessage == null) {
                    return;
                }
                event.result = accessibleMessage;
            }

            private String getAccessibleMessageForImage(Image im) {
                if (im.equals((Object)PaErrorDialog.this.getErrorImage())) {
                    return JFaceResources.getString((String)"error");
                }
                if (im.equals((Object)PaErrorDialog.this.getWarningImage())) {
                    return JFaceResources.getString((String)"warning");
                }
                if (im.equals((Object)PaErrorDialog.this.getInfoImage())) {
                    return JFaceResources.getString((String)"info");
                }
                if (image.equals((Object)PaErrorDialog.this.getQuestionImage())) {
                    return JFaceResources.getString((String)"question");
                }
                return null;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createPaMessageArea(composite);
        return composite;
    }

    private void createPaMessageArea(Composite parent) {
        Label dummyLabel = new Label(parent, 0);
        dummyLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        String msg = NLS.bind((String)Messages.Pa_Support_Link, (Object)PA_ECARE_URL);
        this.supportLink = this.createSupportLink(parent, msg);
        GridData data = new GridData(0x1000008, 0, false, false);
        this.supportLink.setLayoutData((Object)data);
    }

    protected Link createSupportLink(Composite parent, String text) {
        Link link = new Link(parent, 72);
        link.setText(text);
        link.addListener(13, (Listener)new LinkListener(parent.getShell(), Messages.PaErrorDialog_title, Messages.PaErrorDialog_program_launch_failed));
        return link;
    }

    protected Link createInstallLink(Composite parent, String text) {
        Link link = new Link(parent, 72);
        link.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        link.setLayoutData((Object)data);
        link.addListener(13, (Listener)new LinkListener(parent.getShell(), Messages.PaErrorDialog_title, Messages.PaErrorDialog_program_launch_failed));
        return link;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        Control[] tabList = composite.getTabList();
        Control control = tabList[tabList.length - 1];
        int i = tabList.length - 2;
        while (i >= 0) {
            tabList[i + 1] = tabList[i];
            --i;
        }
        tabList[0] = control;
        composite.setTabList(tabList);
        return composite;
    }
}

