/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.dialogs;

import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.FormTextUtil;
import com.ibm.cic.common.ui.services.IClipboard;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class WrapDetailUIDErrorDialog
extends ErrorDialog {
    private boolean displayDetailsArea;
    private SharedScrolledComposite detailScrolledForm;
    private FormText detailAreaText;
    private Button detailsButton;
    private final IStatus status;
    private static int DIALOG_DEFAULT_WIDTH = 640;
    private IClipboard clipboard;

    public WrapDetailUIDErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
        this(parentShell, dialogTitle, message, status, displayMask, false);
    }

    public WrapDetailUIDErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask, boolean showDetailsByDefault) {
        status = StatusUtil.fixMultiStatusNoMsgProblem((IStatus)status);
        super(parentShell, dialogTitle, message, status, displayMask);
        this.displayDetailsArea = false;
        this.detailScrolledForm = null;
        this.detailAreaText = null;
        this.clipboard = null;
        this.message = StatusUtil.stripAnchors((String)status.getMessage());
        this.status = status;
        this.displayDetailsArea = showDetailsByDefault;
    }

    public boolean isDialogMessageContainsAnchor() {
        return StatusUtil.hasAnchor((String)this.message);
    }

    protected boolean shouldShowDetailsButton() {
        boolean shouldDisplayDetailButton = super.shouldShowDetailsButton();
        if (!shouldDisplayDetailButton && CommonSharedUIUtils.hasUID((IStatus)this.status)) {
            shouldDisplayDetailButton = true;
        }
        return shouldDisplayDetailButton;
    }

    protected void createDetailsButton(Composite parent) {
        super.createDetailsButton(parent);
        this.detailsButton = this.getButton(13);
        if (this.detailsButton != null && this.displayDetailsArea) {
            this.createDetailsArea(this.detailsButton.getParent().getParent());
            this.detailsButton.setText(JFaceResources.getString((String)"hideDetails"));
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.displayDetailsArea) {
            this.detailAreaText.dispose();
            this.detailScrolledForm.dispose();
            this.displayDetailsArea = false;
            this.detailsButton.setText(JFaceResources.getString((String)"showDetails"));
        } else {
            this.createDetailsArea((Composite)this.getContents());
            this.detailsButton.setText(JFaceResources.getString((String)"hideDetails"));
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void createDetailsArea(Composite parent) {
        FormToolkit toolKit = CicCommonUiPlugin.getDefault().getFormToolkit();
        boolean useXMLFormating = StatusUtil.hasAnchor((IStatus)this.status);
        String detailContents = this.getDetailContents(useXMLFormating);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.detailScrolledForm = new SharedScrolledComposite(parent, 0xA00 | toolKit.getOrientation()){};
        toolKit.adapt((Composite)this.detailScrolledForm);
        this.detailScrolledForm.setExpandVertical(true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.calculateHeight((Composite)this.detailScrolledForm);
        this.detailScrolledForm.setLayoutData((Object)gridData);
        this.detailAreaText = new FormText((Composite)this.detailScrolledForm, 64);
        toolKit.adapt((Control)this.detailAreaText, true, true);
        this.detailAreaText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.detailAreaText.setParagraphsSeparated(false);
        if (useXMLFormating) {
            try {
                this.detailAreaText.setWhitespaceNormalized(true);
                this.detailAreaText.setText(detailContents, true, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                detailContents = this.getDetailContents(false);
                this.detailAreaText.setWhitespaceNormalized(false);
                this.detailAreaText.setText(detailContents, false, true);
            }
        } else {
            this.detailAreaText.setWhitespaceNormalized(false);
            this.detailAreaText.setText(detailContents, false, true);
        }
        this.detailAreaText.setHyperlinkSettings((HyperlinkSettings)toolKit.getHyperlinkGroup());
        this.detailAreaText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String href = e.getHref().toString();
                if (!UiServices.getInstance().launchProgram(href)) {
                    UiServices.getInstance().findAndExecuteProgram("*.xml", href);
                }
            }
        });
        this.detailScrolledForm.setContent((Control)this.detailAreaText);
        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!WrapDetailUIDErrorDialog.this.detailScrolledForm.isDisposed()) {
                    WrapDetailUIDErrorDialog.this.detailScrolledForm.reflow(true);
                }
            }
        });
        Menu copyMenu = new Menu((Control)this.detailAreaText);
        MenuItem copyItem = new MenuItem(copyMenu, 0);
        copyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WrapDetailUIDErrorDialog.this.copyToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                WrapDetailUIDErrorDialog.this.copyToClipboard();
            }
        });
        copyItem.setText(JFaceResources.getString((String)"copy"));
        this.detailAreaText.setMenu(copyMenu);
        this.displayDetailsArea = true;
    }

    private int calculateHeight(Composite comp) {
        return UiServices.getInstance().calculateCompositeHeight(comp);
    }

    private String getDetailContents(boolean useXMLFormating) {
        OutputFormatter untaggedOutput = new OutputFormatter(2);
        CommonSharedUIUtils.populateDetailArea((IStatus)this.status, (OutputFormatter)untaggedOutput);
        String taggedDetails = useXMLFormating ? FormTextUtil.toFormText(untaggedOutput) : untaggedOutput.toString();
        return taggedDetails;
    }

    private void copyToClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = UiServices.getInstance().createClipboard(DisplayKeeper.INSTANCE.getDisplay());
        if (this.clipboard != null) {
            this.clipboard.setContents(new Object[]{StatusFormatter.toString((IStatus)this.status)}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public void create() {
        super.create();
        Point dlgSize = this.getShell().getSize();
        if (dlgSize.x > DIALOG_DEFAULT_WIDTH) {
            this.getShell().setSize(DIALOG_DEFAULT_WIDTH, dlgSize.y);
            Shell parentShell = this.getParentShell();
            if (parentShell != null) {
                Point dlgLocation = this.getShell().getLocation();
                int newX = parentShell.getLocation().x + (parentShell.getSize().x - DIALOG_DEFAULT_WIDTH) / 2;
                this.getShell().setLocation(newX, dlgLocation.y);
            }
        }
    }

    public static int openError(Shell parent, String dialogTitle, String message, IStatus status) {
        return WrapDetailUIDErrorDialog.openError(parent, dialogTitle, message, status, 7);
    }

    public static int openError(Shell parentShell, String title, String message, IStatus status, int displayMask) {
        WrapDetailUIDErrorDialog dialog = new WrapDetailUIDErrorDialog(parentShell, title, message, status, displayMask);
        return dialog.open();
    }
}

