/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.dialogs;

import com.ibm.cic.common.core.auth.PasswordManager;
import com.ibm.cic.common.core.sharedUI.Messages;
import com.ibm.cic.common.ui.internal.dialogs.ChangePasswordWizard;
import org.eclipse.equinox.internal.security.storage.friends.ReEncrypter;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ChangePasswordWizardDialog
extends WizardDialog {
    private final transient ReEncrypter reEncrypter;
    private boolean decryptedOK;
    private boolean recodeDone;

    public ChangePasswordWizardDialog(Shell parentShell, ISecurePreferences node, String moduleID) {
        super(parentShell, (IWizard)new ChangePasswordWizard());
        this.reEncrypter = new ReEncrypter(node, moduleID);
    }

    public boolean isDecryptedOK() {
        return this.decryptedOK;
    }

    public boolean isRecodeDone() {
        return this.recodeDone;
    }

    protected void nextPressed() {
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage instanceof ChangePasswordWizard.DecodePage) {
            if (!PasswordManager.INSTANCE.triggerPasswordPrompt(SecurePreferencesFactory.getDefault())) {
                return;
            }
            if (!this.reEncrypter.decrypt()) {
                MessageBox messageBox = new MessageBox(this.getShell(), 200);
                messageBox.setText(Messages.changePasswordWizardTitle);
                messageBox.setMessage(Messages.wizardDecodeWarning);
                if (messageBox.open() == 64) {
                    this.setReturnCode(1);
                    this.close();
                    return;
                }
            }
        } else if (currentPage instanceof ChangePasswordWizard.EncodePage) {
            if (!this.reEncrypter.switchToNewPassword()) {
                if (!PasswordManager.INSTANCE.isPasswordDialogCanceled()) {
                    MessageBox messageBox = new MessageBox(this.getShell(), 33);
                    messageBox.setText(Messages.changePasswordWizardTitle);
                    messageBox.setMessage(Messages.wizardSwitchError);
                    messageBox.open();
                }
                this.close();
                return;
            }
            this.reEncrypter.encrypt();
            try {
                PasswordManager.INSTANCE.savePasswordUsage();
            }
            catch (StorageException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.changePasswordWizardTitle, (String)NLS.bind((String)Messages.ChangePasswordWizardDialog_errorSavingExtraData, (Object)e.getMessage()));
            }
            this.recodeDone = true;
        }
        super.nextPressed();
    }
}

