/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.actions;

import com.ibm.cic.common.ui.utils.DisplayKeeper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ActionButton {
    private final NamedSelectableWidget button;

    public ActionButton(Button button, IAction action) {
        this.button = new NamedSelectableWidget(button);
        this.bind(action);
    }

    public ActionButton(ToolItem button, IAction action) {
        this.button = new NamedSelectableWidget(button);
        this.bind(action);
    }

    public ActionButton(Composite parent, IAction action, FormToolkit toolkit, int style) {
        this(parent, action, toolkit, style, true);
    }

    public ActionButton(Composite parent, IAction action, FormToolkit toolkit, int style, boolean showImage) {
        Button btn;
        String text = action.getText();
        if (toolkit != null) {
            btn = toolkit.createButton(parent, text, style | 0x800000 | toolkit.getOrientation());
        } else {
            btn = new Button(parent, style | 0x800000);
            btn.setText(text);
        }
        btn.setToolTipText(action.getToolTipText());
        if (showImage) {
            btn.setImage(this.createImage((Widget)btn, action.getImageDescriptor()));
        }
        this.button = new NamedSelectableWidget(btn);
        this.bind(action);
    }

    public ActionButton(ToolBar toolBar, IAction action, int style) {
        ToolItem toolItem = new ToolItem(toolBar, style | 0x800000);
        ImageDescriptor imageDescriptor = action.getImageDescriptor();
        if (imageDescriptor != null) {
            toolItem.setImage(this.createImage((Widget)toolItem, imageDescriptor));
            toolItem.setDisabledImage(this.createImage((Widget)toolItem, action.getDisabledImageDescriptor()));
        } else {
            toolItem.setText(action.getText());
        }
        toolItem.setToolTipText(action.getToolTipText());
        this.button = new NamedSelectableWidget(toolItem);
        this.bind(action);
    }

    private void bind(IAction action) {
        this.button.setEnabled(action.isEnabled());
        action.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("enabled")) {
                    ActionButton.this.button.setEnabled((Boolean)event.getNewValue());
                }
            }
        });
        this.button.setAction(action);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionButton.this.button.getAction().run();
            }
        });
    }

    private Image createImage(Widget widget, ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        final Image image = imageDescriptor.createImage();
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                image.dispose();
            }
        });
        return image;
    }

    public Button getButton() {
        return this.button.b;
    }

    public ToolItem getToolItem() {
        return this.button.t;
    }

    public static IAction getAction(Widget widget) {
        return (IAction)widget.getData("action");
    }

    private static class NamedSelectableWidget {
        private Button b;
        private ToolItem t;
        private final boolean isButton;
        private static final String ACTION = "action";

        NamedSelectableWidget(Button button) {
            this.b = button;
            this.isButton = true;
        }

        NamedSelectableWidget(ToolItem toolItem) {
            this.t = toolItem;
            this.isButton = false;
        }

        void setEnabled(final boolean enabled) {
            if (this.isButton) {
                DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        NamedSelectableWidget.this.b.setEnabled(enabled);
                    }
                });
            } else {
                DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        NamedSelectableWidget.this.t.setEnabled(enabled);
                    }
                });
            }
        }

        void addSelectionListener(SelectionListener listener) {
            if (this.isButton) {
                this.b.addSelectionListener(listener);
            } else {
                this.t.addSelectionListener(listener);
            }
        }

        void setAction(IAction action) {
            if (this.isButton) {
                this.b.setData(ACTION, (Object)action);
            } else {
                this.t.setData(ACTION, (Object)action);
            }
        }

        IAction getAction() {
            if (this.isButton) {
                return (IAction)this.b.getData(ACTION);
            }
            return (IAction)this.t.getData(ACTION);
        }
    }
}

