/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal;

import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class RepositoryPathResolver {
    private static final int KIND_UNKNOWN = 0;
    private static final int KIND_NON_ABSOLUTE_LOCATION = 1;
    private static final int KIND_DIRECTORY_REPOSITORY = 2;
    private static final int KIND_CREATE_DIRECTORY_REPOSITORY = 3;
    private static final int KIND_REMOTE_REPOSITORY = 4;
    private final Shell parentShell;
    private String errorMessage;
    private boolean created = false;
    private int kind = 0;
    private String location;
    private IStatus repStatus;

    public RepositoryPathResolver(Shell shell) {
        this.parentShell = shell;
    }

    public IRepository getRepository(String path, String name, boolean mustBeWritable, boolean silent) {
        this.kind = 0;
        this.location = null;
        this.errorMessage = null;
        this.created = false;
        this.resolveLocation(path, false);
        return this.obtainRepository(name, mustBeWritable, silent);
    }

    public IRepository getRepositoryNoCreate(String path, String name, boolean mustBeWritable, boolean silent) {
        this.kind = 0;
        this.location = null;
        this.errorMessage = null;
        this.created = false;
        this.resolveLocation(path, true);
        if (this.kind == 3) {
            this.kind = 0;
        }
        return this.obtainRepository(name, mustBeWritable, silent);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean wasCreated() {
        return this.created;
    }

    private void resolveLocation(String path, boolean existingRep) {
        try {
            if (path.length() > 0) {
                if (path.startsWith("https://") || path.startsWith("http://") || path.startsWith("ftp://")) {
                    URL u = new URL(path);
                    if (u.getHost().length() > 0) {
                        boolean isRepDir = false;
                        isRepDir = existingRep ? this.isRepositoryDirForExistingRep(path) : this.isRepositoryDirForNewRep(path);
                        if (isRepDir) {
                            this.location = path;
                            this.kind = 4;
                        }
                    }
                } else if (path.startsWith("//") || path.startsWith("\\\\")) {
                    this.location = path;
                    boolean isRepDir = false;
                    isRepDir = existingRep ? this.isRepositoryDirForExistingRep(path) : this.isRepositoryDirForNewRep(path);
                    this.kind = isRepDir ? 2 : 3;
                } else {
                    File dir = new File(path);
                    boolean isRepDir = false;
                    isRepDir = existingRep ? this.isRepositoryDirForExistingRep(path) : this.isRepositoryDirForNewRep(path);
                    if (isRepDir) {
                        this.location = path;
                        this.kind = 2;
                    } else if (dir.isAbsolute() || this.isRelativelyAbsoluteOnWindows(dir)) {
                        this.location = path;
                        this.kind = 3;
                    } else {
                        this.location = null;
                        this.kind = 1;
                    }
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtil.debugLogToReview((Throwable)t);
            this.kind = 0;
            this.location = null;
        }
    }

    private boolean isRelativelyAbsoluteOnWindows(File dir) {
        if (File.separatorChar == '\\') {
            char first = dir.getPath().charAt(0);
            return first == '\\' || first == '/';
        }
        return false;
    }

    private IRepository obtainRepository(String name, boolean mustBeWritable, boolean silent) {
        IRepositoryInfo repInfo = null;
        switch (this.kind) {
            case 0: {
                if (silent) {
                    this.errorMessage = Messages.RepositoryPathResolver_couldNotFindDestinationErrorMessage;
                } else {
                    this.openError(Messages.RepositoryPathResolver_invalidDestinationErrorTitle, Messages.RepositoryPathResolver_couldNotFindDestinationErrorMessage);
                }
                return null;
            }
            case 1: {
                if (silent) {
                    this.errorMessage = Messages.RepositoryPathResolver_destinationPathNotAbsoluteErrorMessage;
                } else {
                    this.openError(Messages.RepositoryPathResolver_invalidDestinationErrorTitle, Messages.RepositoryPathResolver_destinationPathNotAbsoluteErrorMessage);
                }
                return null;
            }
            case 3: {
                boolean doCreate = true;
                if (!silent) {
                    doCreate = this.openQuestion(Messages.RepositoryPathResolver_createDirectoryConfirmationTitle, Messages.RepositoryPathResolver_createDirectoryConfirmationMessage);
                }
                if (doCreate) {
                    File dir = new File(this.location);
                    dir.mkdirs();
                    if (!dir.isDirectory()) {
                        if (silent) {
                            this.errorMessage = Messages.RepositoryPathResolver_couldNotCreateDirectoryErrorMessage;
                        } else {
                            this.openError(Messages.RepositoryPathResolver_invalidDestinationErrorTitle, Messages.RepositoryPathResolver_couldNotCreateDirectoryErrorTitle);
                        }
                        return null;
                    }
                    this.created = true;
                }
            }
            case 2: {
                if (mustBeWritable) {
                    repInfo = RepositoryUtils.createRepInfoForNewRepository((String)this.location);
                    break;
                }
                repInfo = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)RepositoryGroup.getDefault(), (String)name, null, null, (String)this.location, null);
                break;
            }
            case 4: {
                if (mustBeWritable) {
                    if (silent) {
                        this.errorMessage = Messages.RepositoryPathResolver_directoryNotwriableErrorMessage;
                    } else {
                        this.openError(Messages.RepositoryPathResolver_invalidDestinationErrorTitle, Messages.RepositoryPathResolver_directoryNotwriableErrorMessage);
                    }
                    return null;
                }
                repInfo = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)RepositoryGroup.getDefault(), (String)name, null, null, (String)this.location, null);
            }
        }
        IRepository repository = null;
        try {
            if (this.kind == 3) {
                this.repStatus = RepositoryGroup.getDefault().canCreateRepository(repInfo);
                if (this.repStatus.isOK()) {
                    repository = RepositoryGroup.getDefault().createRepository(repInfo);
                }
            } else {
                repository = RepositoryGroup.getDefault().addExistingRepository(repInfo, true);
            }
            if (repository == null) {
                repInfo.setRepositoryDescriptor(null);
                repInfo.setType(null);
                repInfo.setVersion(null);
                if (this.kind != 3) {
                    repository = RepositoryGroup.getDefault().addExistingRepository(repInfo, false);
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtil.debugLogToReview((Throwable)t);
            t.printStackTrace();
        }
        return repository;
    }

    private void openError(final String title, final String message) {
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)RepositoryPathResolver.this.parentShell, (String)title, (String)message);
            }
        });
    }

    private boolean openQuestion(final String title, final String question) {
        final boolean[] retval = new boolean[1];
        DisplayKeeper.INSTANCE.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                retval[0] = MessageDialog.openQuestion((Shell)RepositoryPathResolver.this.parentShell, (String)title, (String)question);
            }
        });
        return retval[0];
    }

    private boolean isRepositoryDirForExistingRep(String loc) {
        RepositoryGroup group = RepositoryGroup.getDefault();
        IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)group, (String)loc);
        return group.canAddExistingRepository(repInfo, null).isOK();
    }

    private boolean isRepositoryDirForNewRep(String loc) {
        IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForNewRepository((String)loc);
        return RepositoryGroup.getDefault().canAddExistingRepository(repInfo, null).isOK();
    }

    public IStatus getRepositoryStatus() {
        return this.repStatus;
    }

    public IStatus setRepositoryStatus(IStatus newStatus) {
        this.repStatus = newStatus;
        return this.repStatus;
    }
}

